/*
 * Decompiled with CFR 0.152.
 */
package math;

import biomart.SpeciesSettings;
import gui.Logger;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.GregorianCalendar;
import math.MathFun;
import settings.ExperimentSettings;

public class ExperimentReporter {
    private ExperimentSettings settings;
    private int chromosomes;
    private int[] loci;
    private int[] lociMatched;
    private int[] positionsMatched;
    private int[] prefilteredLoci;
    private int[] nearLociFiltered;
    private int[] shortLociFiltered;
    private float[] lowTagsInLociFiltered;
    private float[] multiTagsInLociFiltered;
    private float[] lowTagsLociFiltered;
    private float[] multiTagsLociFiltered;
    private float[] tags;
    private float[] tagsMatched;
    private float[] multiAssignmentTagsFiltered;
    private float[] multiTagsInPositionsFiltered;
    private float[] lowTagsInPositionsFiltered;
    private float[] multiTagsPositionsFiltered;
    private float[] lowTagsPositionsFiltered;
    private float[] maxTags;
    private double[] meanTags;
    private float[] maxPos;
    private double[] meanPos;
    private long elapsedTime;

    public ExperimentReporter(int chromosomes, ExperimentSettings settings) {
        this.chromosomes = chromosomes;
        this.settings = settings;
        this.loci = new int[this.chromosomes];
        this.lociMatched = new int[this.chromosomes];
        this.positionsMatched = new int[this.chromosomes];
        this.prefilteredLoci = new int[this.chromosomes];
        this.nearLociFiltered = new int[this.chromosomes];
        this.shortLociFiltered = new int[this.chromosomes];
        this.tags = new float[this.chromosomes];
        this.tagsMatched = new float[this.chromosomes];
        this.multiAssignmentTagsFiltered = new float[this.chromosomes];
        this.multiTagsInPositionsFiltered = new float[this.chromosomes];
        this.lowTagsInPositionsFiltered = new float[this.chromosomes];
        this.multiTagsInLociFiltered = new float[this.chromosomes];
        this.lowTagsInLociFiltered = new float[this.chromosomes];
        this.multiTagsPositionsFiltered = new float[this.chromosomes];
        this.lowTagsPositionsFiltered = new float[this.chromosomes];
        this.multiTagsLociFiltered = new float[this.chromosomes];
        this.lowTagsLociFiltered = new float[this.chromosomes];
    }

    public void clearCalculatedData() {
        this.lociMatched = new int[this.chromosomes];
        this.positionsMatched = new int[this.chromosomes];
        this.nearLociFiltered = new int[this.chromosomes];
        this.prefilteredLoci = new int[this.chromosomes];
        this.shortLociFiltered = new int[this.chromosomes];
        this.tagsMatched = new float[this.chromosomes];
        this.multiAssignmentTagsFiltered = new float[this.chromosomes];
        this.multiTagsInPositionsFiltered = new float[this.chromosomes];
        this.lowTagsInPositionsFiltered = new float[this.chromosomes];
        this.multiTagsInLociFiltered = new float[this.chromosomes];
        this.lowTagsInLociFiltered = new float[this.chromosomes];
        this.multiTagsPositionsFiltered = new float[this.chromosomes];
        this.lowTagsPositionsFiltered = new float[this.chromosomes];
        this.multiTagsLociFiltered = new float[this.chromosomes];
        this.lowTagsLociFiltered = new float[this.chromosomes];
    }

    public int[] getLoci() {
        return this.loci;
    }

    public int[] getLociMatched() {
        return this.lociMatched;
    }

    public int[] getPositionsMatched() {
        return this.positionsMatched;
    }

    public int[] getNearLociFiltered() {
        return this.nearLociFiltered;
    }

    public int[] getPrefilteredLoci() {
        return this.prefilteredLoci;
    }

    public int[] getShortLociFiltered() {
        return this.shortLociFiltered;
    }

    public float[] getTags() {
        return this.tags;
    }

    public float[] getTagsMatched() {
        return this.tagsMatched;
    }

    public float[] getTagsFiltered() {
        return this.multiAssignmentTagsFiltered;
    }

    public float[] getLowTagInLociFiltered() {
        return this.lowTagsInLociFiltered;
    }

    public float[] getMultiTagInLociFiltered() {
        return this.multiTagsInLociFiltered;
    }

    public float[] getMultiTagInPositionsFiltered() {
        return this.multiTagsInPositionsFiltered;
    }

    public float[] getLowTagInPositionsFiltered() {
        return this.lowTagsInPositionsFiltered;
    }

    public float[] getLowTagLociFiltered() {
        return this.lowTagsLociFiltered;
    }

    public float[] getMultiTagLociFiltered() {
        return this.multiTagsLociFiltered;
    }

    public float[] getMultiTagPositionsFiltered() {
        return this.multiTagsPositionsFiltered;
    }

    public float[] getLowTagPositionsFiltered() {
        return this.lowTagsPositionsFiltered;
    }

    public void setElapsedTime(long elapsedTime) {
        this.elapsedTime = elapsedTime;
    }

    public void setMaxTags(float[] maxTags) {
        this.maxTags = maxTags;
    }

    public void setMeanTags(double[] meanTags) {
        this.meanTags = meanTags;
    }

    public void setMaxPos(float[] maxPos) {
        this.maxPos = maxPos;
    }

    public void setMeanPos(double[] meanPos) {
        this.meanPos = meanPos;
    }

    public void saveReportToFile(String fileName) {
        File file = new File(fileName);
        try {
            int i;
            file.createNewFile();
            BufferedWriter writer = new BufferedWriter(new FileWriter(file));
            writer.write("<!DOCTYPE html>");
            writer.newLine();
            writer.write("<html>");
            writer.newLine();
            writer.write("<body>");
            writer.newLine();
            writer.write("<h1><center>Report</center></h1>");
            writer.newLine();
            GregorianCalendar c = new GregorianCalendar();
            writer.write("<h3><center>" + c.get(1) + "-" + (c.get(2) + 1) + "-" + c.get(5) + " " + c.get(11) + ":" + c.get(12) + ":" + c.get(13) + "</center></h3>");
            writer.newLine();
            writer.write("<h2><center>Settings</center></h2>");
            writer.newLine();
            writer.write("<table align=\"center\" border=\"1\">");
            writer.newLine();
            writer.write("\t<tr>");
            writer.newLine();
            writer.write("\t\t<th align=\"center\" bgcolor=\"#DADADA\">Parameter</th>");
            writer.newLine();
            writer.write("\t\t<th align=\"center\" bgcolor=\"#DADADA\">Value</td>");
            writer.newLine();
            writer.write("\t</tr>");
            writer.newLine();
            writer.write("\t<tr>");
            writer.newLine();
            writer.write("\t\t<th align=\"center\">Locus length</th>");
            writer.newLine();
            writer.write("\t\t<td align=\"center\">" + this.settings.getParams().getLocusLength() + "</td>");
            writer.newLine();
            writer.write("\t</tr>");
            writer.newLine();
            writer.write("\t<tr>");
            writer.newLine();
            writer.write("\t\t<th align=\"center\">Locus offset</th>");
            writer.newLine();
            writer.write("\t\t<td align=\"center\">" + this.settings.getParams().getLocusOffset() + "</td>");
            writer.newLine();
            writer.write("\t</tr>");
            writer.newLine();
            writer.write("\t<tr>");
            writer.newLine();
            writer.write("\t\t<th align=\"center\">Tags file</th>");
            writer.newLine();
            writer.write("\t\t<td align=\"center\">" + this.settings.getBowtieFile() + "</th>");
            writer.newLine();
            writer.write("\t</tr>");
            writer.newLine();
            writer.write("\t<tr>");
            writer.newLine();
            writer.write("\t\t<th align=\"center\">Multiple assignments filtering</th>");
            writer.newLine();
            writer.write("\t\t<td align=\"center\">" + this.settings.getParams().isFilterMultipleAssignments() + "</th>");
            writer.newLine();
            writer.write("\t</tr>");
            writer.newLine();
            writer.write("\t<tr>");
            writer.newLine();
            writer.write("\t\t<th align=\"center\">Assignments count normalization    </th>");
            writer.newLine();
            writer.write("\t\t<td align=\"center\">" + this.settings.getParams().isAssignmentsCountNormalisation() + "</th>");
            writer.newLine();
            writer.write("\t</tr>");
            writer.newLine();
            writer.write("\t<tr>");
            writer.newLine();
            writer.write("\t\t<th align=\"center\">Species</th>");
            writer.newLine();
            writer.write("\t\t<td align=\"center\">" + this.settings.getParams().getSpeciesId() + "</th>");
            writer.newLine();
            writer.write("\t</tr>");
            writer.newLine();
            writer.write("\t<tr>");
            writer.newLine();
            writer.write("\t\t<th align=\"center\">Main attribute</th>");
            writer.newLine();
            writer.write("\t\t<td align=\"center\">" + this.settings.getParams().getMainAttribute() + "</th>");
            writer.newLine();
            writer.write("\t</tr>");
            writer.newLine();
            writer.write("\t<tr>");
            writer.newLine();
            writer.write("\t\t<th align=\"center\">Strand checking</th>");
            writer.newLine();
            writer.write("\t\t<td align=\"center\">" + this.settings.getParams().isCheckStrand() + "</th>");
            writer.newLine();
            writer.write("\t</tr>");
            writer.newLine();
            if (this.settings.getParams().isCheckStrand()) {
                writer.write("\t<tr>");
                writer.newLine();
                writer.write("\t\t<th align=\"center\">Secondary attribute</th>");
                writer.newLine();
                writer.write("\t\t<td align=\"center\">" + this.settings.getParams().getSecondaryAttribute() + "</th>");
                writer.newLine();
                writer.write("\t</tr>");
                writer.newLine();
            }
            writer.write("\t<tr>");
            writer.newLine();
            writer.write("\t\t<th align=\"center\">Gene types</th>");
            writer.newLine();
            if (this.settings.getParams().isFilterLociTypes()) {
                i = 0;
                while (i < this.settings.getParams().getLociTypesCount()) {
                    writer.write("\t\t<td align=\"center\">" + this.settings.getParams().getLociTypes(i) + "</th>");
                    ++i;
                }
            } else {
                writer.write("\t\t<td align=\"center\">all</th>");
            }
            writer.newLine();
            writer.write("\t</tr>");
            writer.newLine();
            writer.write("\t<tr>");
            writer.newLine();
            writer.write("\t\t<th align=\"center\">GO terms</th>");
            writer.newLine();
            writer.write("\t\t<td align=\"center\">" + (this.settings.getParams().isFilterGOTerm() ? this.settings.getParams().getGOTermsFile() : "all") + "</th>");
            writer.newLine();
            writer.write("\t</tr>");
            writer.newLine();
            writer.write("\t<tr>");
            writer.newLine();
            writer.write("\t\t<th align=\"center\">Loci list loading</th>");
            writer.newLine();
            writer.write("\t\t<td align=\"center\">" + (this.settings.getParams().isLociLoad() ? this.settings.getParams().getLociLoadFile() : "false") + "</th>");
            writer.newLine();
            writer.write("\t</tr>");
            writer.newLine();
            writer.write("\t<tr>");
            writer.newLine();
            writer.write("\t\t<th align=\"center\">Loci list saving</th>");
            writer.newLine();
            writer.write("\t\t<td align=\"center\">" + (this.settings.getParams().isLociSave() ? this.settings.getParams().getLociSaveFile() : "false") + "</th>");
            writer.newLine();
            writer.write("\t</tr>");
            writer.newLine();
            writer.write("\t<tr>");
            writer.newLine();
            writer.write("\t\t<th align=\"center\">Short loci filtering</th>");
            writer.newLine();
            writer.write("\t\t<td align=\"center\">" + (this.settings.getParams().isFilterShortLoci() ? Integer.valueOf(this.settings.getParams().getMinLociLength()) : "false") + "</th>");
            writer.newLine();
            writer.write("\t</tr>");
            writer.newLine();
            writer.write("\t<tr>");
            writer.newLine();
            writer.write("\t\t<th align=\"center\">Near loci filtering</th>");
            writer.newLine();
            if (this.settings.getParams().isLeaveNoNearLoci()) {
                writer.write("\t\t<td align=\"center\">all</th>");
            } else if (this.settings.getParams().isLeaveRandomNearLoci()) {
                writer.write("\t\t<td align=\"center\">random</th>");
            } else if (this.settings.getParams().isLeaveMiddleNearLoci()) {
                writer.write("\t\t<td align=\"center\">single</th>");
            } else {
                writer.write("\t\t<td align=\"center\">false</th>");
            }
            writer.newLine();
            writer.write("\t</tr>");
            writer.newLine();
            if (this.settings.getParams().isLeaveNoNearLoci() || this.settings.getParams().isLeaveRandomNearLoci() || this.settings.getParams().isLeaveMiddleNearLoci()) {
                writer.write("\t<tr>");
                writer.newLine();
                writer.write("\t\t<th align=\"center\">Min loci distance</th>");
                writer.newLine();
                writer.write("\t\t<td align=\"center\">" + this.settings.getParams().getMinLociDistance() + "</th>");
                writer.newLine();
                writer.write("\t</tr>");
                writer.newLine();
            }
            writer.write("\t<tr>");
            writer.newLine();
            writer.write("\t\t<th align=\"center\">Prefilter</th>");
            writer.newLine();
            writer.write("\t\t<td align=\"center\">" + (this.settings.getParams().isPrefilterLoci() ? "len:" + this.settings.getParams().getPrefilterLociLength() + "; off:" + this.settings.getParams().getPrefilterLociOffset() + "; tags:" + this.settings.getParams().getPrefilterLociTags() : "none") + "</th>");
            writer.newLine();
            writer.write("\t</tr>");
            writer.newLine();
            writer.write("\t<tr>");
            writer.newLine();
            writer.write("\t\t<th align=\"center\">Low-tags loci filtering</th>");
            writer.newLine();
            writer.write("\t\t<td align=\"center\">" + (this.settings.getParams().isFilterLowTagLoci() ? Integer.valueOf(this.settings.getParams().getMinLociTagCount()) : "none") + "</th>");
            writer.newLine();
            writer.write("\t</tr>");
            writer.newLine();
            writer.write("\t<tr>");
            writer.newLine();
            writer.write("\t\t<th align=\"center\">Multi-tags loci filtering</th>");
            writer.newLine();
            writer.write("\t\t<td align=\"center\">" + (this.settings.getParams().isFilterMultiTagLoci() ? Integer.valueOf(this.settings.getParams().getMaxLociTagCount()) : "none") + "</th>");
            writer.newLine();
            writer.write("\t</tr>");
            writer.newLine();
            writer.write("\t<tr>");
            writer.newLine();
            writer.write("\t\t<th align=\"center\">Low-tags positions filtering</th>");
            writer.newLine();
            writer.write("\t\t<td align=\"center\">" + (this.settings.getParams().isFilterLowTagPositions() ? Integer.valueOf(this.settings.getParams().getMinPositionTagCount()) : "none") + "</th>");
            writer.newLine();
            writer.write("\t</tr>");
            writer.newLine();
            writer.write("\t<tr>");
            writer.newLine();
            writer.write("\t\t<th align=\"center\">Multi-tags positions filtering</th>");
            writer.newLine();
            writer.write("\t\t<td align=\"center\">" + (this.settings.getParams().isFilterMultiTagPositions() ? Integer.valueOf(this.settings.getParams().getMaxPositionTagCount()) : "none") + "</th>");
            writer.newLine();
            writer.write("\t</tr>");
            writer.newLine();
            writer.write("</table>");
            writer.newLine();
            writer.write("<h2><center>Loci</center></h2>");
            writer.newLine();
            writer.write("<table align=\"center\" border=\"1\">");
            writer.newLine();
            writer.write("\t<tr>");
            writer.newLine();
            writer.write("\t\t<th align=\"center\" bgcolor=\"#DADADA\">Chromosome</th>");
            writer.newLine();
            writer.write("\t\t<th align=\"center\" bgcolor=\"#DADADA\">Downloaded</td>");
            writer.newLine();
            writer.write("\t\t<th align=\"center\" bgcolor=\"#DADADA\">Short Filtered</td>");
            writer.newLine();
            writer.write("\t\t<th align=\"center\" bgcolor=\"#DADADA\">Pre-Filtered Loci</td>");
            writer.newLine();
            writer.write("\t\t<th align=\"center\" bgcolor=\"#DADADA\">Near Filtered</td>");
            writer.newLine();
            writer.write("\t\t<th align=\"center\" bgcolor=\"#DADADA\">Left</td>");
            writer.newLine();
            writer.write("\t</tr>");
            writer.newLine();
            i = 0;
            while (i < this.loci.length) {
                writer.write("\t<tr>");
                writer.newLine();
                if (i == 22) {
                    writer.write("\t\t<th align=\"center\">X</th>");
                } else if (i == 23) {
                    writer.write("\t\t<th align=\"center\">Y</th>");
                } else {
                    writer.write("\t\t<th align=\"center\">" + (i + 1) + "</th>");
                }
                writer.newLine();
                writer.write("\t\t<th align=\"center\">" + this.loci[i] + "</td>");
                writer.newLine();
                writer.write("\t\t<th align=\"center\">" + this.shortLociFiltered[i] + "</td>");
                writer.newLine();
                writer.write("\t\t<th align=\"center\">" + this.prefilteredLoci[i] + "</td>");
                writer.newLine();
                writer.write("\t\t<th align=\"center\">" + this.nearLociFiltered[i] + "</td>");
                writer.newLine();
                writer.write("\t\t<th align=\"center\">" + (this.loci[i] - this.shortLociFiltered[i] - this.prefilteredLoci[i] - this.nearLociFiltered[i]) + "</td>");
                writer.newLine();
                writer.write("\t</tr>");
                writer.newLine();
                ++i;
            }
            writer.write("</table>");
            writer.newLine();
            writer.write("<h2><center>Tags</center></h2>");
            writer.newLine();
            writer.write("<table align=\"center\" border=\"1\">");
            writer.newLine();
            writer.write("\t<tr>");
            writer.newLine();
            writer.write("\t\t<th align=\"center\" bgcolor=\"#DADADA\">Chromosome</th>");
            writer.newLine();
            writer.write("\t\t<th align=\"center\" bgcolor=\"#DADADA\">Read</td>");
            writer.newLine();
            writer.write("\t\t<th align=\"center\" bgcolor=\"#DADADA\">Matched</td>");
            writer.newLine();
            writer.write("\t\t<th align=\"center\" bgcolor=\"#DADADA\">Multiple assigned tags filtered</td>");
            writer.newLine();
            writer.write("\t\t<th align=\"center\" bgcolor=\"#DADADA\">Low-tags positions filtered</td>");
            writer.newLine();
            writer.write("\t\t<th align=\"center\" bgcolor=\"#DADADA\">Low-tags loci filtered</td>");
            writer.newLine();
            writer.write("\t\t<th align=\"center\" bgcolor=\"#DADADA\">Multi-tags positions filtered</td>");
            writer.newLine();
            writer.write("\t\t<th align=\"center\" bgcolor=\"#DADADA\">Multi-tags loci filtered</td>");
            writer.newLine();
            writer.write("\t\t<th align=\"center\" bgcolor=\"#DADADA\">Left</td>");
            writer.newLine();
            writer.write("\t\t<th align=\"center\" bgcolor=\"#DADADA\">Mean Tags For Position</td>");
            writer.newLine();
            writer.write("\t\t<th align=\"center\" bgcolor=\"#DADADA\">Max Tags For Position</td>");
            writer.newLine();
            writer.write("\t\t<th align=\"center\" bgcolor=\"#DADADA\">Positions Matched</td>");
            writer.newLine();
            writer.write("\t\t<th align=\"center\" bgcolor=\"#DADADA\">Mean Tags For Locus</td>");
            writer.newLine();
            writer.write("\t\t<th align=\"center\" bgcolor=\"#DADADA\">Max Tags For Locus</td>");
            writer.newLine();
            writer.write("\t\t<th align=\"center\" bgcolor=\"#DADADA\">Loci Matched</td>");
            writer.newLine();
            writer.write("\t</tr>");
            writer.newLine();
            i = 0;
            while (i < this.tags.length) {
                writer.write("\t<tr>");
                writer.newLine();
                writer.write("\t\t<th align=\"center\">" + SpeciesSettings.getChromosomeName(this.settings.getParams().getSpeciesId(), i) + "</th>");
                writer.newLine();
                writer.write("\t\t<th align=\"center\">" + Math.round(100.0f * this.tags[i]) / 100 + "</td>");
                writer.newLine();
                writer.write("\t\t<th align=\"center\">" + Math.round(100.0f * this.tagsMatched[i]) / 100 + "</td>");
                writer.newLine();
                writer.write("\t\t<th align=\"center\">" + Math.round(100.0f * this.multiAssignmentTagsFiltered[i]) / 100 + "</td>");
                writer.newLine();
                writer.write("\t\t<th align=\"center\">" + Math.round(100.0f * this.lowTagsInPositionsFiltered[i]) / 100 + " (" + Math.round(100.0f * this.lowTagsPositionsFiltered[i]) / 100 + ")</td>");
                writer.newLine();
                writer.write("\t\t<th align=\"center\">" + Math.round(100.0f * this.lowTagsInLociFiltered[i]) / 100 + " (" + Math.round(100.0f * this.lowTagsLociFiltered[i]) / 100 + ")</td>");
                writer.newLine();
                writer.write("\t\t<th align=\"center\">" + Math.round(100.0f * this.multiTagsInPositionsFiltered[i]) / 100 + " (" + Math.round(100.0f * this.multiTagsPositionsFiltered[i]) / 100 + ")</td>");
                writer.newLine();
                writer.write("\t\t<th align=\"center\">" + Math.round(100.0f * this.multiTagsInLociFiltered[i]) / 100 + " (" + Math.round(100.0f * this.multiTagsLociFiltered[i]) / 100 + ")</td>");
                writer.newLine();
                writer.write("\t\t<th align=\"center\">" + Math.round(100.0f * (this.tagsMatched[i] - this.multiAssignmentTagsFiltered[i] - this.lowTagsInPositionsFiltered[i] - this.lowTagsInLociFiltered[i] - this.multiTagsInPositionsFiltered[i] - this.multiTagsInLociFiltered[i])) / 100 + "</td>");
                writer.newLine();
                writer.write("\t\t<th align=\"center\">" + (double)Math.round(100.0 * this.meanTags[i]) / 100.0 + "</td>");
                writer.newLine();
                writer.write("\t\t<th align=\"center\">" + Math.round(100.0f * this.maxTags[i]) / 100 + "</td>");
                writer.newLine();
                writer.write("\t\t<th align=\"center\">" + Math.round(100 * this.positionsMatched[i]) / 100 + "</td>");
                writer.newLine();
                writer.write("\t\t<th align=\"center\">" + (double)Math.round(100.0 * this.meanPos[i]) / 100.0 + "</td>");
                writer.newLine();
                writer.write("\t\t<th align=\"center\">" + Math.round(100.0f * this.maxPos[i]) / 100 + "</td>");
                writer.newLine();
                writer.write("\t\t<th align=\"center\">" + Math.round(100 * this.lociMatched[i]) / 100 + "</td>");
                writer.newLine();
                writer.write("\t</tr>");
                writer.newLine();
                ++i;
            }
            writer.write("\t<tr>");
            writer.newLine();
            writer.write("\t\t<th align=\"center\">SUM</th>");
            writer.newLine();
            writer.write("\t\t<th align=\"center\">" + Math.round(100.0f * MathFun.sum(this.tags)) / 100 + "</td>");
            writer.newLine();
            writer.write("\t\t<th align=\"center\">" + Math.round(100.0f * MathFun.sum(this.tagsMatched)) / 100 + "</td>");
            writer.newLine();
            writer.write("\t\t<th align=\"center\">" + Math.round(100.0f * MathFun.sum(this.multiAssignmentTagsFiltered)) / 100 + "</td>");
            writer.newLine();
            writer.write("\t\t<th align=\"center\">" + Math.round(100.0f * MathFun.sum(this.lowTagsInPositionsFiltered)) / 100 + " (" + Math.round(100.0f * MathFun.sum(this.lowTagsPositionsFiltered)) / 100 + ")</td>");
            writer.newLine();
            writer.write("\t\t<th align=\"center\">" + Math.round(100.0f * MathFun.sum(this.lowTagsInLociFiltered)) / 100 + " (" + Math.round(100.0f * MathFun.sum(this.lowTagsLociFiltered)) / 100 + ")</td>");
            writer.newLine();
            writer.write("\t\t<th align=\"center\">" + Math.round(100.0f * MathFun.sum(this.multiTagsInPositionsFiltered)) / 100 + " (" + Math.round(100.0f * MathFun.sum(this.multiTagsPositionsFiltered)) / 100 + ")</td>");
            writer.newLine();
            writer.write("\t\t<th align=\"center\">" + Math.round(100.0f * MathFun.sum(this.multiTagsInLociFiltered)) / 100 + " (" + Math.round(100.0f * MathFun.sum(this.multiTagsLociFiltered)) / 100 + ")</td>");
            writer.newLine();
            float matched = Math.round(100.0f * (MathFun.sum(this.tagsMatched) - MathFun.sum(this.multiAssignmentTagsFiltered) - MathFun.sum(this.lowTagsInPositionsFiltered) - MathFun.sum(this.lowTagsInLociFiltered) - MathFun.sum(this.multiTagsInPositionsFiltered) - MathFun.sum(this.multiTagsInLociFiltered))) / 100;
            writer.write("\t\t<th align=\"center\">" + matched + "</td>");
            writer.newLine();
            int sum = MathFun.sum(this.positionsMatched);
            writer.write("\t\t<th align=\"center\">" + (sum > 0 ? (double)Math.round(100.0f * matched / (float)sum) / 100.0 : 0.0) + "</td>");
            writer.newLine();
            writer.write("\t\t<th align=\"center\">" + Math.round(100.0f * MathFun.max(this.maxTags)) / 100 + "</td>");
            writer.newLine();
            writer.write("\t\t<th align=\"center\">" + Math.round(100 * MathFun.sum(this.positionsMatched)) / 100 + "</td>");
            writer.newLine();
            writer.write("\t\t<th align=\"center\">" + (sum > 0 ? (double)Math.round(100.0f * matched / (float)MathFun.sum(this.lociMatched)) / 100.0 : 0.0) + "</td>");
            writer.newLine();
            writer.write("\t\t<th align=\"center\">" + Math.round(100.0f * MathFun.max(this.maxPos)) / 100 + "</td>");
            writer.newLine();
            writer.write("\t\t<th align=\"center\">" + Math.round(100 * MathFun.sum(this.lociMatched)) / 100 + "</td>");
            writer.newLine();
            writer.write("\t</tr>");
            writer.newLine();
            writer.write("</table>");
            writer.newLine();
            writer.write("<h2><center>Timing</center></h2>");
            writer.newLine();
            writer.write("<center>Elapsed time: " + this.elapsedTime + " ms</center>");
            writer.newLine();
            writer.write("</body>");
            writer.newLine();
            writer.write("</html>");
            writer.newLine();
            writer.close();
        }
        catch (Exception e) {
            Logger.writeExceptionLog(e);
        }
    }
}

