/*
 * Decompiled with CFR 0.152.
 */
package math;

public class Chi2Test {
    private static final double[] GAMMA_LOGN = new double[]{76.18009173, -86.50532033, 24.01409822, -1.231739516, 0.00120858003, -5.36382E-6};

    public static void main(String[] args) {
        System.out.println("Hello Chi2");
        double[] h_obs = new double[]{1.0, 1.0, 2.0, 4.0, 8.0, 4.0, 2.0, 1.0, 1.0};
        double[] h_exp = new double[]{5.0, 5.0, 5.0, 5.0, 6.0, 5.0, 5.0, 5.0, 5.0};
        System.out.println(Chi2Test.chi2TestWithHistogram(h_exp, h_obs));
    }

    public static final double chi2TestWithHistogram(double[] h_exp, double[] h_obs) {
        double[] p = new double[h_exp.length];
        double H = 0.0;
        int i = 0;
        while (i < h_exp.length) {
            H += h_exp[i];
            ++i;
        }
        i = 0;
        while (i < h_exp.length) {
            p[i] = h_exp[i] / H;
            ++i;
        }
        return Chi2Test.chi2TestWithProbability(p, h_obs);
    }

    public static final double chi2TestWithProbability(double[] p, double[] n) {
        int N = 0;
        double chi2 = 0.0;
        int i = 0;
        while (i < n.length) {
            N = (int)((double)N + n[i]);
            ++i;
        }
        i = 0;
        while (i < n.length) {
            double pn = p[i] * (double)N;
            chi2 += (n[i] - pn) * (n[i] - pn) / pn;
            ++i;
        }
        return 1.0 - Chi2Test.chi2CDF(chi2, n.length - 1);
    }

    private static final double chi2CDF(double x, double v) {
        double p = Chi2Test.gammaInc(x / 2.0, v / 2.0);
        return p;
    }

    private static final double gammaInc(double x, double a) {
        double gaminc = 0.0;
        if (x < 0.0 || a <= 0.0) {
            return gaminc;
        }
        if (x < a + 1.0) {
            gaminc = Chi2Test.gammaSer(x, a);
        } else {
            gaminc = Chi2Test.gammaCf(x, a);
            gaminc = 1.0 - gaminc;
        }
        return gaminc;
    }

    private static final double gammaCf(double x, double a) {
        double d;
        double gln = Chi2Test.gammaLogn(a);
        double b = x + 1.0 - a;
        double c = 1.0E30;
        double h = d = 1.0 / b;
        int i = 1;
        while (i <= 100) {
            double an = (double)(-i) * ((double)i - a);
            if (Math.abs(d = an * d + (b += 2.0)) < 1.0E-30) {
                d = 1.0E-30;
            }
            if (Math.abs(c = b + an / c) < 1.0E-30) {
                c = 1.0E-30;
            }
            d = 1.0 / d;
            double del = d * c;
            h *= del;
            if (Math.abs(del - 1.0) < 3.0E-7) break;
            ++i;
        }
        double gamcf = Math.exp(-x + a * Math.log(x) - gln) * h;
        return gamcf;
    }

    private static final double gammaSer(double x, double a) {
        double sum;
        double gamser = 0.0;
        double gln = Chi2Test.gammaLogn(a);
        if (x <= 0.0) {
            return gamser;
        }
        double ap = a;
        double del = sum = 1.0 / a;
        int n = 0;
        while (n < 100) {
            sum += (del *= x / (ap += 1.0));
            ++n;
        }
        gamser = sum * Math.exp(-x + a * Math.log(x) - gln);
        return gamser;
    }

    private static final double gammaLogn(double xx) {
        double x = xx - 1.0;
        double tmp = x + 5.5;
        tmp -= (x + 0.5) * Math.log(tmp);
        double ser = 1.0;
        int j = 0;
        while (j <= 5) {
            ser += GAMMA_LOGN[j] / (x += 1.0);
            ++j;
        }
        return -tmp + Math.log(2.50662827465 * ser);
    }
}

