/*
 * Decompiled with CFR 0.152.
 */
package io;

import biomart.SpeciesSettings;
import io.TagFileReader;
import io.TagFileReaderListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.zip.GZIPInputStream;
import math.ProfilerData;
import settings.ExperimentSettings;

public class BamFileReader
implements TagFileReader {
    private boolean forceStop = false;
    private ArrayList<TagFileReaderListener> listeners = new ArrayList();

    @Override
    public void readTags(ExperimentSettings settings, ProfilerData data) throws IOException {
        long totalFileLen;
        File tagFile = new File(settings.getBowtieFile());
        long fileLen = totalFileLen = tagFile.length() * 4L;
        GZIPInputStream in = new GZIPInputStream(new FileInputStream(tagFile));
        BufferedInputStream reader = new BufferedInputStream(in);
        String magic = "" + (char)reader.read() + (char)reader.read() + (char)reader.read() + (char)reader.read();
        int headerLength = reader.read() + (reader.read() << 8) + (reader.read() << 16) + (reader.read() << 24);
        int i = 0;
        while (i < headerLength) {
            reader.read();
            ++i;
        }
        int nRef = reader.read() + (reader.read() << 8) + (reader.read() << 16) + (reader.read() << 24);
        int[] chroms = new int[nRef];
        int i2 = 0;
        while (i2 < nRef) {
            int nRefNameLen = reader.read() + (reader.read() << 8) + (reader.read() << 16) + (reader.read() << 24);
            String chromName = "";
            int j = 0;
            while (j < nRefNameLen - 1) {
                chromName = String.valueOf(chromName) + (char)reader.read();
                ++j;
            }
            reader.read();
            chromName = chromName.substring(3);
            chroms[i2] = SpeciesSettings.getChromosomeId(settings.getParams().getSpeciesId(), chromName);
            j = reader.read() + (reader.read() << 8) + (reader.read() << 16) + (reader.read() << 24);
            ++i2;
        }
        int eof = reader.read();
        while (eof != -1) {
            int alignmentRecordSize = eof + (reader.read() << 8) + (reader.read() << 16) + (reader.read() << 24);
            int refID = reader.read() + (reader.read() << 8) + (reader.read() << 16) + (reader.read() << 24);
            int pos = reader.read() + (reader.read() << 8) + (reader.read() << 16) + (reader.read() << 24);
            int i3 = 8;
            while (i3 < alignmentRecordSize) {
                reader.read();
                ++i3;
            }
            eof = reader.read();
            if (refID >= 0 && chroms[refID] != -1) {
                data.addPosition(chroms[refID], pos + 1);
            }
            fileLen -= (long)alignmentRecordSize;
            int l = 0;
            while (l < this.listeners.size()) {
                this.listeners.get(l).lineRead((int)(fileLen * 100L / totalFileLen));
                ++l;
            }
        }
        reader.close();
    }

    @Override
    public void addListener(TagFileReaderListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void forceStopReading() {
        this.forceStop = true;
    }
}

