/*
 * Decompiled with CFR 0.152.
 */
package gui;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import mscanlib.plots.MScanPlotArea;
import mscanlib.plots.MScanPoint;
import mscanlib.plots.MScanScatterPlot;

class XYLociPlot
extends MScanPlotArea {
    private MScanScatterPlot scatterPlot = null;
    private String imageDir = null;

    public XYLociPlot(int width, int height, boolean fixed, String imageDir, HashMap<Point2D, Integer> pointMap, String axisXName, String axisYName, String name, boolean loglog) {
        super(width, height, fixed);
        this.setZoomable(true, true, true);
        this.setImageFile(String.valueOf(name) + "_XY_plot_" + axisXName + "_" + axisYName);
        this.setCursor(new Cursor(1));
        this.setCursorCoordinatesVisible(true);
        if (imageDir == null) {
            this.imageDir = ".";
        } else {
            try {
                this.imageDir = new File(imageDir).getParent();
            }
            catch (Exception e) {
                this.imageDir = imageDir;
            }
        }
        this.setImageDir(this.imageDir);
        this.resetPlottables();
        this.scatterPlot = new MScanScatterPlot(this, this.getScatterPlotType());
        Iterator<Integer> itCount = pointMap.values().iterator();
        int max = 0;
        while (itCount.hasNext()) {
            int i = itCount.next();
            if (i <= max) continue;
            max = i;
        }
        for (Point2D p : pointMap.keySet()) {
            double count = pointMap.get(p).intValue();
            MScanPoint mp = loglog ? new MScanPoint(this.scatterPlot.getPlotArea(), Math.log10(p.getX()), Math.log10(p.getY()), 0) : new MScanPoint(this.scatterPlot.getPlotArea(), p.getX(), p.getY(), 0);
            this.scatterPlot.addPlotElement(mp, true);
            mp.setFaceColor(new Color((int)(count / (double)max * 255.0), 0, 0));
        }
        this.scatterPlot.setSelectable(false);
        this.scatterPlot.setEdgeColor(Color.black);
        this.addPlottable(this.scatterPlot, true);
        this.xAxis.setAutoUpdate(true);
        this.xAxis.setBoxAxes(true);
        this.xAxis.setGrid(true);
        this.xAxis.setLabel(String.valueOf(axisXName) + " #tags");
        this.yAxis.setBoxAxes(true);
        this.yAxis.setAutoUpdate(true);
        this.yAxis.setGrid(true);
        this.yAxis.setLabel(String.valueOf(axisYName) + " #tags");
        this.updatePlot();
        this.resetZoomLevel();
    }

    @Override
    public void plotImage(Graphics2D g2d) {
        this.plotAxes(g2d);
        this.redrawPlottables(g2d);
    }
}

