/*
 * Decompiled with CFR 0.152.
 */
package gui;

import biomart.SpeciesSettings;
import gui.SortMode;
import java.util.Comparator;
import java.util.Vector;
import settings.ExperimentSettings;

class TableSorter
implements Comparator<Vector<String>> {
    private SortMode mode;
    private boolean ascending;
    private ExperimentSettings settings;

    public TableSorter(ExperimentSettings settings, SortMode mode, boolean ascending) {
        this.settings = settings;
        this.mode = mode;
        this.ascending = ascending;
    }

    @Override
    public int compare(Vector<String> o1, Vector<String> o2) {
        String s1 = "";
        String s2 = "";
        if (this.mode == SortMode.POSITIONS) {
            Integer i1 = Integer.parseInt(o1.get(1));
            Integer i2 = Integer.parseInt(o2.get(1));
            if (this.ascending) {
                return i1.compareTo(i2);
            }
            return -1 * i1.compareTo(i2);
        }
        if (this.mode == SortMode.TAGS) {
            Double i1 = Double.parseDouble(o1.get(3));
            Double i2 = Double.parseDouble(o2.get(3));
            if (this.ascending) {
                return i1.compareTo(i2);
            }
            return -1 * i1.compareTo(i2);
        }
        if (this.mode == SortMode.CHROMOSOME) {
            Integer i1 = this.getChromosome(o1.get(0));
            Integer i2 = this.getChromosome(o2.get(0));
            if (this.ascending) {
                return i1.compareTo(i2);
            }
            return -1 * i1.compareTo(i2);
        }
        if (this.mode == SortMode.DESCRIPTION) {
            s1 = o1.get(4);
            s2 = o2.get(4);
            if (this.ascending) {
                return s1.compareToIgnoreCase(s2);
            }
            return -1 * s1.compareToIgnoreCase(s2);
        }
        if (this.mode == SortMode.GENEID) {
            s1 = o1.get(2);
            s2 = o2.get(2);
            if (this.ascending) {
                return s1.compareToIgnoreCase(s2);
            }
            return -1 * s1.compareToIgnoreCase(s2);
        }
        if (this.mode == SortMode.LENGTH) {
            Integer i1 = this.getChromosome(o1.get(5));
            Integer i2 = this.getChromosome(o2.get(5));
            if (this.ascending) {
                return i1.compareTo(i2);
            }
            return -1 * i1.compareTo(i2);
        }
        return 0;
    }

    private int getChromosome(String name) {
        return SpeciesSettings.getChromosomeId(this.settings.getParams().getSpeciesId(), name);
    }
}

