/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.Logger;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class ReportInternalFrame
extends JInternalFrame
implements MouseListener,
ActionListener {
    private JEditorPane editorPane;
    private JPopupMenu popupMenu;
    private String profileName;
    private String filePath;

    public ReportInternalFrame(String name, String filePath) {
        super(name, true, true, true, false);
        this.profileName = name;
        this.filePath = filePath;
        this.editorPane = new JEditorPane();
        this.editorPane.setEditable(false);
        try {
            File f = new File(filePath);
            this.editorPane.setPage(f.toURI().toURL());
            this.editorPane.addMouseListener(this);
        }
        catch (Exception e) {
            Logger.writeExceptionLog(e);
        }
        this.getContentPane().add(new JScrollPane(this.editorPane));
        this.pack();
        this.popupMenu = new JPopupMenu("tableMenu");
        JMenuItem menuItem = new JMenuItem("Export");
        menuItem.addActionListener(this);
        this.popupMenu.add(menuItem);
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (arg0.getActionCommand().equals("Export")) {
            this.exportData();
        }
    }

    public void exportData() {
        JFileChooser chooser = new JFileChooser();
        File f = new File(String.valueOf(new File(this.filePath).getParentFile().getParentFile().getPath()) + File.separator + this.profileName + "_report.html");
        chooser.setSelectedFile(f);
        chooser.setMultiSelectionEnabled(false);
        if (chooser.showDialog(this, "Select") == 0) {
            try {
                String line;
                File dest = chooser.getSelectedFile();
                if (dest.exists()) {
                    dest.createNewFile();
                }
                File source = new File(this.filePath);
                BufferedReader br = new BufferedReader(new FileReader(source));
                BufferedWriter bw = new BufferedWriter(new FileWriter(dest));
                while ((line = br.readLine()) != null) {
                    bw.write(line);
                    bw.newLine();
                }
                br.close();
                bw.close();
            }
            catch (Exception e) {
                Logger.writeExceptionLog(e);
            }
        } else {
            return;
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (SwingUtilities.isRightMouseButton(e)) {
            this.popupMenu.show((JEditorPane)e.getSource(), e.getX(), e.getY());
        }
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
    }
}

