/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.ProgressInternalFrameListener;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JProgressBar;

public class ProgressInternalFrame
extends JInternalFrame {
    private JLabel label;
    private JProgressBar progressBar;
    private JLabel timeLabel;
    private ProgressInternalFrameListener listener;

    public ProgressInternalFrame(String title, String text, int max, boolean withProgressBar, boolean withTime, ProgressInternalFrameListener listener) {
        super(title, false, false, false, false);
        this.listener = listener;
        int row = 0;
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = row++;
        c.gridy = 0;
        this.label = new JLabel(text);
        this.getContentPane().add((Component)this.label, c);
        if (withProgressBar) {
            c.gridx = 0;
            c.gridy = row++;
            c.weightx = 1.0;
            this.progressBar = new JProgressBar();
            this.progressBar.setMinimum(0);
            this.progressBar.setMaximum(max);
            this.progressBar.setValue(this.progressBar.getMinimum());
            this.getContentPane().add((Component)this.progressBar, c);
        }
        if (withTime) {
            c.gridx = 0;
            c.gridy = row++;
            c.weightx = 1.0;
            this.timeLabel = new JLabel("-- minutes left");
            this.getContentPane().add((Component)this.timeLabel, c);
        }
        c.gridx = 0;
        c.gridy = row;
        c.weightx = 0.0;
        JButton close = new JButton("Stop");
        close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ProgressInternalFrame.this.getListener().stopButtonPressed();
            }
        });
        this.getContentPane().add((Component)close, c);
        this.pack();
    }

    public void updateLabel(String newLabel) {
        this.setVisible(false);
        this.label.setText(newLabel);
        this.pack();
        this.setVisible(true);
    }

    public void updateValue(int newVal) {
        if (this.progressBar != null) {
            this.progressBar.setValue(newVal);
        }
    }

    public void updateTime(long msLeft) {
        if (this.timeLabel != null) {
            int minutes = (int)(msLeft / 60000L) + 1;
            if (msLeft == 0L) {
                minutes = 0;
            }
            this.timeLabel.setText(String.valueOf(minutes) + " " + (minutes == 1 ? "minute" : "minutes") + " left");
        }
    }

    private ProgressInternalFrameListener getListener() {
        return this.listener;
    }
}

