/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.Logger;
import gui.PackableScatterPlot;
import gui.ProfileScatterPlotListener;
import io.TableFileWriter;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import math.MathFun;
import mscanlib.plots.MScanLinePlot;
import mscanlib.plots.MScanScatterPlot;
import mscanlib.plots.MScanTextLabel;

public class ProfileScatterPlot
extends PackableScatterPlot {
    private String experimentName;
    private String profileName = null;
    private String imageDir = null;
    private ArrayList<MScanScatterPlot> scatterPlots = null;
    private ArrayList<MScanLinePlot> fitPlots = null;
    private ArrayList<ProfileScatterPlotListener> listeners;
    private String[] labels;
    private boolean scale = false;
    private int globalLength;
    private int globalMin;
    private double[][] points;
    private int[] offset;
    private int[] length;
    private static final Color POINT_COLOR = Color.blue;
    private static final Color OUTLIER_COLOR = Color.red;
    private static final Color SELECTED_COLOR = Color.green;
    private boolean fitPlotVisible = false;
    private int bins = 0;

    public ProfileScatterPlot(ArrayList<Double>[] histogram, int[] offset, String[] labels, String experimentName, String experimentPath, String profileName) {
        super(750, 500, true);
        this.experimentName = experimentName;
        this.profileName = profileName;
        if (experimentPath == null) {
            this.imageDir = ".";
        } else {
            try {
                this.imageDir = new File(experimentPath).getParent();
            }
            catch (Exception e) {
                this.imageDir = experimentPath;
            }
        }
        this.setImageDir(this.imageDir);
        this.scatterPlots = new ArrayList();
        this.fitPlots = new ArrayList();
        this.listeners = new ArrayList();
        this.setZoomable(true, true, true);
        this.setCursor(new Cursor(1));
        this.setCursorCoordinatesVisible(true);
        this.resetPlottables();
        this.xAxis.setAutoUpdate(true);
        this.xAxis.setBoxAxes(true);
        this.xAxis.setGrid(true);
        this.xAxis.setLabel("position");
        this.yAxis.setBoxAxes(true);
        this.yAxis.setAutoUpdate(true);
        this.yAxis.setGrid(true);
        this.yAxis.setLabel("# tags");
        JMenuItem mItem = new JMenuItem("Export");
        mItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ProfileScatterPlot.this.scatterPlots.size() <= 0) {
                    return;
                }
                JFileChooser chooser = new JFileChooser();
                chooser.setSelectedFile(new File(ProfileScatterPlot.this.getFileName(0)));
                chooser.setMultiSelectionEnabled(false);
                chooser.setCurrentDirectory(new File(ProfileScatterPlot.this.imageDir));
                if (chooser.showDialog(ProfileScatterPlot.this, "Select") != 0) {
                    return;
                }
                File f = chooser.getSelectedFile();
                int i = 0;
                while (i < ProfileScatterPlot.this.scatterPlots.size()) {
                    double[][] data = new double[((MScanScatterPlot)ProfileScatterPlot.this.scatterPlots.get(i)).getPlotElements().size()][2];
                    int j = 0;
                    while (j < ((MScanScatterPlot)ProfileScatterPlot.this.scatterPlots.get(i)).getPlotElements().size()) {
                        data[j][0] = ((MScanScatterPlot)ProfileScatterPlot.this.scatterPlots.get(i)).getPlotElements().get(j).getPosX();
                        data[j][1] = ((MScanScatterPlot)ProfileScatterPlot.this.scatterPlots.get(i)).getPlotElements().get(j).getPosY();
                        ++j;
                    }
                    try {
                        TableFileWriter.writeTable(String.valueOf(f.getParent()) + File.separator + ProfileScatterPlot.this.getFileName(i), data);
                    }
                    catch (Exception e1) {
                        Logger.writeExceptionLog(e1);
                    }
                    ++i;
                }
            }
        });
        this.mPopupMenu.add(mItem);
        JCheckBoxMenuItem chMItem = new JCheckBoxMenuItem("Scale");
        chMItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProfileScatterPlot.this.scale = ((JCheckBoxMenuItem)e.getSource()).isSelected();
                ProfileScatterPlot.this.generateHistogram(ProfileScatterPlot.this.bins);
            }
        });
        this.mPopupMenu.add(chMItem);
        this.labels = labels;
        this.offset = new int[histogram.length];
        this.length = new int[histogram.length];
        this.globalMin = offset[0];
        int globalMax = histogram[0].size() + offset[0] - 1;
        int h = 1;
        while (h < histogram.length) {
            this.globalMin = Math.min(this.globalMin, offset[h]);
            globalMax = Math.max(globalMax, histogram[h].size() + offset[h] - 1);
            ++h;
        }
        this.globalLength = globalMax - this.globalMin + 1;
        this.points = new double[histogram.length][this.globalLength];
        h = 0;
        while (h < histogram.length) {
            this.offset[h] = offset[h];
            this.length[h] = histogram[h].size();
            int i = 0;
            while (i < histogram[h].size()) {
                this.points[h][i + offset[h] - this.globalMin] = histogram[h].get(i);
                ++i;
            }
            ++h;
        }
        this.bins = this.globalLength;
        this.generateHistogram(this.bins);
    }

    public String getFileName(int profile) {
        if (this.scatterPlots.size() > 1) {
            return String.valueOf(this.experimentName) + "_" + this.labels[profile] + "_common_profile_bins_" + this.bins;
        }
        return String.valueOf(this.experimentName) + "_" + this.profileName + "_profile_bins_" + this.bins;
    }

    public void addListener(ProfileScatterPlotListener listener) {
        this.listeners.add(listener);
        this.generateHistogram(this.bins);
    }

    private void generateHistogram(int bins) {
        this.removePlots();
        this.setPlotTitle(this.experimentName);
        this.setLabels(this.labels);
        double[][] y = new double[this.points.length][bins];
        double[] x = new double[bins];
        int h = 0;
        while (h < this.points.length) {
            double pointsInBin;
            x = new double[bins];
            double pointsLeft = pointsInBin = 1.0 * (double)this.points[h].length / (double)bins;
            int binIndex = 0;
            int i = 0;
            while (i < this.points[h].length) {
                if (pointsLeft >= 1.0) {
                    double[] dArray = y[h];
                    int n = binIndex;
                    dArray[n] = dArray[n] + this.points[h][i];
                    int n2 = binIndex;
                    x[n2] = x[n2] + (double)i;
                    pointsLeft -= 1.0;
                } else {
                    double[] dArray = y[h];
                    int n = binIndex;
                    dArray[n] = dArray[n] + pointsLeft * this.points[h][i];
                    int n3 = binIndex;
                    x[n3] = x[n3] + pointsLeft * (double)i;
                    int n4 = binIndex;
                    x[n4] = x[n4] / pointsInBin;
                    int n5 = binIndex++;
                    x[n5] = x[n5] + (double)this.globalMin;
                    pointsLeft = 1.0 - pointsLeft;
                    if (binIndex >= bins) break;
                    double[] dArray2 = y[h];
                    int n6 = binIndex;
                    dArray2[n6] = dArray2[n6] + pointsLeft * this.points[h][i];
                    int n7 = binIndex;
                    x[n7] = x[n7] + pointsLeft * (double)i;
                    pointsLeft = pointsInBin - pointsLeft;
                }
                ++i;
            }
            if (binIndex < bins) {
                int n = binIndex;
                x[n] = x[n] / pointsInBin;
                int n8 = binIndex;
                x[n8] = x[n8] + (double)this.globalMin;
            }
            if (this.scale && x.length > 1 && y[h].length > 1) {
                double sum = 0.0;
                int s = 0;
                while (s < x.length - 1) {
                    sum += (y[h][s] + y[h][s + 1]) * (x[s + 1] - x[s]) / 2.0;
                    ++s;
                }
                s = 0;
                while (s < x.length) {
                    double[] dArray = y[h];
                    int n = s++;
                    dArray[n] = dArray[n] / sum;
                }
            }
            ++h;
        }
        int i = 0;
        while (i < this.listeners.size()) {
            this.listeners.get(i).profileChanged(y);
            ++i;
        }
        h = 0;
        while (h < y.length) {
            int nonZeros = 0;
            int j = 0;
            while (j < x.length) {
                if (y[h][j] != 0.0) {
                    ++nonZeros;
                }
                ++j;
            }
            double[] yplot = new double[nonZeros];
            double[] xplot = new double[nonZeros];
            int j2 = 0;
            int i2 = 0;
            while (i2 < x.length) {
                if (y[h][i2] != 0.0) {
                    yplot[j2] = y[h][i2];
                    xplot[j2] = x[i2];
                    ++j2;
                }
                ++i2;
            }
            this.addPlot(xplot, yplot);
            ++h;
        }
    }

    public void addPlot(double[] x, double[] y) {
        MScanScatterPlot scatterPlot = new MScanScatterPlot(this, this.getScatterPlotType());
        scatterPlot.setPoints(x, y);
        scatterPlot.setSelectable(false);
        scatterPlot.setEdgeColor(Color.black);
        this.scatterPlots.add(scatterPlot);
        MScanLinePlot fitPlot = new MScanLinePlot(this);
        fitPlot.setLineWidth(2.0f);
        this.fitPlots.add(fitPlot);
        this.addPlottable(scatterPlot, true);
        this.addPlottable(fitPlot, true);
        fitPlot.setPoints(x, y);
        fitPlot.setVisible(this.fitPlotVisible);
        double min = MathFun.min(x);
        double max = MathFun.max(x);
        this.setRangeX(new double[]{min, max});
        this.updateRanges();
        this.updatePlot();
        this.resetZoomLevel();
        this.setImageFile(this.getFileName(0));
    }

    public void removePlots() {
        this.fitPlots.clear();
        this.scatterPlots.clear();
        this.resetPlottables();
    }

    public void setLabels(String[] labels) {
        if (labels == null) {
            return;
        }
        int yPos = 35;
        int i = 0;
        while (i < labels.length) {
            String labelText = labels[i];
            MScanTextLabel label = new MScanTextLabel(this, labelText, 0.0, 0.0, false, 1);
            label.setAlpha(1.0f);
            label.setTextColor(this.mPlotColors[this.mPlotColorIndex]);
            this.nextPlotColor();
            label.setPosX(15.0);
            label.setPosY(yPos);
            yPos = (int)((double)yPos + (label.getRealHeight() + 5.0));
            this.addPlottable(label, false);
            ++i;
        }
        this.resetPlotColor();
    }

    @Override
    public void setFitPlotVisible(boolean visible) {
        this.fitPlotVisible = visible;
        int i = 0;
        while (i < this.scatterPlots.size()) {
            this.fitPlots.get(i).setVisible(visible);
            ++i;
        }
        this.updatePlot();
    }

    @Override
    public void binsCountChanged(int bins) {
        this.bins = bins;
        this.generateHistogram(bins);
    }

    @Override
    public int getMaxBins() {
        return this.globalLength;
    }
}

