/*
 * Decompiled with CFR 0.152.
 */
package gui;

import biomart.SpeciesSettings;
import gui.LociTableModel;
import gui.Logger;
import gui.SortMode;
import gui.TableSorter;
import io.TableFileWriter;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Vector;
import javax.swing.JDesktopPane;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.table.JTableHeader;
import settings.ExperimentSettings;

public class LociTableInternalFrame
extends JInternalFrame
implements MouseListener,
ActionListener {
    private JPopupMenu popupMenu;
    private JTable lociTable;
    private ExperimentSettings settings;
    private JDesktopPane parent;
    private String profileName;
    private final String[] colNames = new String[]{"Chromosome", "Position", "Gene ID", "#Tags", "Description", "Length"};

    public LociTableInternalFrame(ExperimentSettings settings, String name, ArrayList<String[]> data, JDesktopPane parent) {
        super(name, false, true, false, false);
        this.parent = parent;
        this.settings = settings;
        this.profileName = name;
        this.setBounds(parent.getWidth() * 2 / 3, 0, parent.getWidth() / 3, parent.getHeight());
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        Vector rows = new Vector();
        Vector<String> columnNames = new Vector<String>();
        columnNames.add(this.colNames[0]);
        columnNames.add(this.colNames[1]);
        columnNames.add(this.colNames[2]);
        columnNames.add(this.colNames[3]);
        columnNames.add(this.colNames[4]);
        columnNames.add(this.colNames[5]);
        int i = 0;
        while (i < data.size()) {
            String[] currentData = data.get(i);
            Vector<String> row = new Vector<String>();
            int chromosomeNumber = Integer.parseInt(currentData[4]) - 1;
            row.add(SpeciesSettings.getChromosomeName(settings.getParams().getSpeciesId(), chromosomeNumber));
            row.add(currentData[0]);
            row.add(currentData[2]);
            row.add(currentData[3]);
            if (currentData.length > 5) {
                row.add(currentData[5]);
                row.add(currentData[6]);
            } else {
                row.add("-");
            }
            rows.add(row);
            ++i;
        }
        LociTableModel model = new LociTableModel(rows, (Vector)columnNames);
        this.lociTable = new JTable(model);
        this.lociTable.addMouseListener(this);
        this.lociTable.getTableHeader().addMouseListener(this);
        this.getContentPane().add((Component)new JScrollPane(this.lociTable), c);
        this.popupMenu = new JPopupMenu("tableMenu");
        JMenu sortMenu = new JMenu("Sort by...");
        JMenuItem menuItem = new JMenuItem("Chromosome");
        menuItem.addActionListener(this);
        sortMenu.add(menuItem);
        menuItem = new JMenuItem("Position");
        menuItem.addActionListener(this);
        sortMenu.add(menuItem);
        menuItem = new JMenuItem("Gene ID");
        menuItem.addActionListener(this);
        sortMenu.add(menuItem);
        menuItem = new JMenuItem("#Tags");
        menuItem.addActionListener(this);
        sortMenu.add(menuItem);
        menuItem = new JMenuItem("Length");
        menuItem.addActionListener(this);
        sortMenu.add(menuItem);
        menuItem = new JMenuItem("Description");
        menuItem.addActionListener(this);
        sortMenu.add(menuItem);
        this.popupMenu.add(sortMenu);
        JMenuItem exportMenu = new JMenuItem("Export");
        exportMenu.addActionListener(this);
        this.popupMenu.add(exportMenu);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getSource().getClass().getName().equals(JTableHeader.class.getName())) {
            JTableHeader tableHeader = (JTableHeader)e.getSource();
            int columnIndex = tableHeader.getColumnModel().getColumnIndexAtX(e.getX());
            String columnName = tableHeader.getColumnModel().getColumn(columnIndex).getHeaderValue().toString();
            if (columnName.equals("Chromosome")) {
                this.sortTable(SortMode.CHROMOSOME);
            } else if (columnName.equals("Position")) {
                this.sortTable(SortMode.POSITIONS);
            } else if (columnName.equals("Gene ID")) {
                this.sortTable(SortMode.GENEID);
            } else if (columnName.equals("#Tags")) {
                this.sortTable(SortMode.TAGS);
            } else if (columnName.equals("Description")) {
                this.sortTable(SortMode.DESCRIPTION);
            } else if (columnName.equals("Length")) {
                this.sortTable(SortMode.LENGTH);
            }
            return;
        }
        if (SwingUtilities.isRightMouseButton(e)) {
            int row;
            JTable table = (JTable)e.getSource();
            ListSelectionModel model = table.getSelectionModel();
            if (!model.isSelectedIndex(row = table.rowAtPoint(new Point(e.getX(), e.getY())))) {
                model.setSelectionInterval(row, row);
            }
            this.popupMenu.show((JTable)e.getSource(), e.getX(), e.getY());
            return;
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("Position")) {
            this.sortTable(SortMode.POSITIONS);
        } else if (e.getActionCommand().equals("Chromosome")) {
            this.sortTable(SortMode.CHROMOSOME);
        } else if (e.getActionCommand().equals("Gene ID")) {
            this.sortTable(SortMode.GENEID);
        } else if (e.getActionCommand().equals("#Tags")) {
            this.sortTable(SortMode.TAGS);
        } else if (e.getActionCommand().equals("Descritpion")) {
            this.sortTable(SortMode.DESCRIPTION);
        } else if (e.getActionCommand().equals("Length")) {
            this.sortTable(SortMode.LENGTH);
        } else if (e.getActionCommand().equals("Export")) {
            this.exportData();
        }
    }

    public void exportData() {
        Object[][] data = new Object[this.lociTable.getRowCount() + 1][];
        data[0] = Arrays.copyOf(this.colNames, this.colNames.length);
        int i = 1;
        while (i < data.length) {
            data[i] = new Object[this.lociTable.getColumnCount()];
            int j = 0;
            while (j < data[i].length) {
                data[i][j] = this.lociTable.getValueAt(i - 1, j);
                ++j;
            }
            ++i;
        }
        File f = null;
        JFileChooser chooser = new JFileChooser();
        chooser.setCurrentDirectory(new File(this.settings.getPath()).getParentFile());
        chooser.setSelectedFile(new File(String.valueOf(this.settings.getName()) + "_" + this.profileName + "_lociTable.txt"));
        chooser.setMultiSelectionEnabled(false);
        if (chooser.showDialog(this.parent, "Select") != 0) {
            return;
        }
        f = chooser.getSelectedFile();
        try {
            TableFileWriter.writeTable(f.getPath(), data);
        }
        catch (Exception e) {
            Logger.writeExceptionLog(e);
        }
    }

    public void sortTable(SortMode mode) {
        boolean ascending = true;
        LociTableModel model = (LociTableModel)this.lociTable.getModel();
        if (mode == model.getSortedColumn()) {
            ascending = !model.isAscending();
            model.setAscending(ascending);
        } else {
            model.setSortedColumn(mode);
            model.setAscending(true);
        }
        Vector<Vector> values = model.getDataVector();
        Collections.sort(values, new TableSorter(this.settings, mode, ascending));
        model.fireTableDataChanged();
    }
}

