/*
 * Decompiled with CFR 0.152.
 */
package gui;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.util.ArrayList;
import mscanlib.plots.MScanPlotArea;
import mscanlib.plots.MScanScatterPlot;

class ChromosomeScatterPlot
extends MScanPlotArea {
    private static final Color POINT_COLOR = Color.blue;
    private static final Color OUTLIER_COLOR = Color.red;
    private static final Color SELECTED_COLOR = Color.green;
    private MScanScatterPlot positions = null;
    private MScanScatterPlot genes = null;

    public ChromosomeScatterPlot(int width, int height, boolean fixed, double[] xPosition, double[] yPosition, double[] xGenes, double[] yGenes, ArrayList<String[]> genesId) {
        super(width, height, fixed);
        this.setZoomable(true, true, true);
        this.setCursor(new Cursor(1));
        this.setCursorCoordinatesVisible(true);
        this.setImageDir(".");
        this.resetPlottables();
        int i = 0;
        while (i < genesId.size()) {
            this.xAxis.addLabelValue(Integer.parseInt(genesId.get(i)[0]), String.valueOf(genesId.get(i)[2]) + " : " + Integer.parseInt(genesId.get(i)[0]) / 1000 + "kb");
            ++i;
        }
        this.xAxis.setBoxAxes(true);
        this.xAxis.setGrid(true);
        this.xAxis.setAutoUpdate(true);
        this.xAxis.setLabel("gene");
        this.yAxis.setBoxAxes(true);
        this.yAxis.setAutoUpdate(true);
        this.yAxis.setGrid(true);
        this.yAxis.setLabel("# tags");
        this.positions = new MScanScatterPlot(this);
        this.positions.setId("Positions");
        this.positions.setSelectable(true);
        this.positions.setFaceColor(POINT_COLOR);
        this.positions.setEdgeColor(Color.black);
        this.positions.setOutliersColor(OUTLIER_COLOR);
        this.positions.setSelectedColor(SELECTED_COLOR);
        this.positions.setPoints(xPosition, yPosition, null);
        this.genes = new MScanScatterPlot(this);
        this.genes.setId("Genes");
        this.genes.setSelectable(false);
        this.genes.setFaceColor(Color.red);
        this.genes.setEdgeColor(Color.black);
        this.genes.setPoints(xGenes, yGenes, null);
        this.addPlottable(this.positions, true);
        this.addPlottable(this.genes, true);
        this.resetZoomLevel();
        this.updatePlot();
    }

    @Override
    public void plotImage(Graphics2D g2d) {
        this.plotAxes(g2d);
        this.redrawPlottables(g2d);
    }
}

