/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.ChromosomeScatterPlot;
import gui.SliderListener;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class ChromosomeFigureInternalFrame
extends JInternalFrame {
    private ArrayList<Integer> tagx;
    private ArrayList<Double> tagy;
    private ArrayList<Integer> positions;
    private int positionLen;
    private ChromosomeScatterPlot plot;
    private JSlider horizontalSlider;
    private int horizontalMin;
    private int horizontalMax;
    private SliderListener horizontalSliderListener;
    private JSlider verticalSlider;
    private int verticalMin;
    private int verticalMax;
    private SliderListener verticalSliderListener;
    private JSpinner positionSpinner;
    private JSpinner windowSpinner;

    public ChromosomeFigureInternalFrame(String name, String chromosome, ArrayList<Integer> tagx, ArrayList<Double> tagy, ArrayList<Integer> positions, int positionLen, ArrayList<String[]> genesId) {
        super(String.valueOf(name) + "_" + chromosome, true, true, true, false);
        int maxY;
        int maxX;
        this.tagx = tagx;
        this.tagy = tagy;
        this.positions = positions;
        this.positionLen = positionLen;
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.insets = new Insets(2, 2, 2, 2);
        double[] xPositions = new double[tagx.size()];
        double[] yPositions = new double[tagx.size()];
        double[] xGenes = new double[3 * positions.size()];
        double[] yGenes = new double[3 * positions.size()];
        int i = 0;
        while (i < tagx.size()) {
            xPositions[i] = tagx.get(i).intValue();
            yPositions[i] = tagy.get(i);
            ++i;
        }
        i = 0;
        while (i < positions.size()) {
            xGenes[3 * i] = (double)positions.get(i).intValue() - (double)positionLen;
            xGenes[3 * i + 1] = positions.get(i).intValue();
            xGenes[3 * i + 2] = (double)positions.get(i).intValue() + (double)positionLen;
            yGenes[3 * i] = 0.0;
            yGenes[3 * i + 1] = 0.0;
            yGenes[3 * i + 2] = 0.0;
            ++i;
        }
        this.plot = new ChromosomeScatterPlot(750, 500, true, xPositions, yPositions, xGenes, yGenes, genesId);
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 6;
        this.getContentPane().add((Component)this.plot, c);
        c.gridx = 1;
        c.gridy = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 5;
        c.gridheight = 1;
        int minX = (int)this.plot.getMinX();
        this.horizontalMax = maxX = (int)this.plot.getMaxX();
        this.horizontalMin = minX;
        this.horizontalSlider = new JSlider(0, minX, maxX, minX);
        this.getContentPane().add((Component)this.horizontalSlider, c);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        int minY = (int)this.plot.getMinY();
        this.verticalMax = maxY = (int)this.plot.getMaxY();
        this.verticalMin = minY;
        this.verticalSlider = new JSlider(1, minY, maxY, minY);
        this.getContentPane().add((Component)this.verticalSlider, c);
        this.horizontalSliderListener = new SliderListener(this.horizontalSlider, this.horizontalMax, this.plot, 0);
        this.verticalSliderListener = new SliderListener(this.verticalSlider, this.verticalMax, this.plot, 1);
        this.horizontalSlider.addChangeListener(this.horizontalSliderListener);
        this.verticalSlider.addChangeListener(this.verticalSliderListener);
        this.plot.addPlotListener(this.horizontalSliderListener);
        this.plot.addPlotListener(this.verticalSliderListener);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridx = 2;
        c.gridy = 2;
        this.positionSpinner = new JSpinner(new SpinnerNumberModel((maxX - minX) / 2 + minX, minX, maxX, 100));
        this.getContentPane().add((Component)this.positionSpinner, c);
        c.gridx = 4;
        this.windowSpinner = new JSpinner(new SpinnerNumberModel(maxX - minX, 1, maxX - minX, 100));
        this.getContentPane().add((Component)this.windowSpinner, c);
        c.gridx = 1;
        c.weightx = 0.0;
        JLabel label = new JLabel("Position: ");
        this.getContentPane().add((Component)label, c);
        c.gridx = 3;
        label = new JLabel("Window: ");
        this.getContentPane().add((Component)label, c);
        c.gridx = 5;
        c.weightx = 1.0;
        JButton showButton = new JButton("Show");
        showButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int position = (Integer)ChromosomeFigureInternalFrame.this.positionSpinner.getValue();
                int window = (Integer)ChromosomeFigureInternalFrame.this.windowSpinner.getValue();
                int maxX = position + window / 2;
                int minX = position - window / 2;
                maxX = Math.min(maxX, ChromosomeFigureInternalFrame.this.horizontalMax);
                minX = Math.max(minX, ChromosomeFigureInternalFrame.this.horizontalMin);
                ChromosomeFigureInternalFrame.this.plot.setMinX(minX);
                ChromosomeFigureInternalFrame.this.plot.setMaxX(maxX);
                ChromosomeFigureInternalFrame.this.horizontalSlider.setMaximum(ChromosomeFigureInternalFrame.this.horizontalMax - (maxX - minX));
                ChromosomeFigureInternalFrame.this.horizontalSlider.setValue(minX);
            }
        });
        this.getContentPane().add((Component)showButton, c);
        this.pack();
    }
}

