/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.AttributeSelectionInternalFrameListener;
import gui.ExperimentDesktop;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JList;
import javax.swing.JScrollPane;

public class AttributeSelectionInternalFrame
extends JInternalFrame {
    private JList list;
    private AttributeSelectionInternalFrameListener listener;

    public AttributeSelectionInternalFrame(ExperimentDesktop parent, String title, HashMap<String, String> attributes, AttributeSelectionInternalFrameListener listener) {
        super(title, false, false, false, false);
        this.getContentPane().setLayout(new GridBagLayout());
        this.listener = listener;
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        this.list = new JList();
        this.list.setSelectionMode(0);
        this.list.setLayoutOrientation(0);
        JScrollPane listScroller = new JScrollPane(this.list);
        listScroller.setPreferredSize(new Dimension(500, parent.getHeight() - 200));
        this.getContentPane().add((Component)listScroller, c);
        JButton okButton = new JButton("OK");
        okButton.setPreferredSize(new Dimension(100, 25));
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        this.getContentPane().add((Component)okButton, c);
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AttributeSelectionInternalFrame.this.notifyListeners();
                AttributeSelectionInternalFrame.this.setVisible(false);
            }
        });
        JButton cancelButton = new JButton("Cancel");
        cancelButton.setPreferredSize(new Dimension(100, 25));
        c.gridx = 1;
        c.gridy = 1;
        c.gridwidth = 1;
        this.getContentPane().add((Component)cancelButton, c);
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AttributeSelectionInternalFrame.this.setVisible(false);
            }
        });
        if (attributes != null && attributes.keySet().size() > 0) {
            Object[] attributesArray = attributes.keySet().toArray();
            Object[] entries = new String[attributesArray.length];
            int i = 0;
            while (i < entries.length) {
                entries[i] = String.valueOf(attributes.get(attributesArray[i])) + " [" + attributesArray[i] + "]";
                ++i;
            }
            Arrays.sort(entries);
            this.list.setListData(entries);
        }
        this.pack();
        this.setLocation((parent.getWidth() - this.getWidth()) / 2, (parent.getHeight() - this.getHeight()) / 2);
    }

    public void notifyListeners() {
        String selectedId = (String)this.list.getSelectedValue();
        selectedId = selectedId.substring(selectedId.indexOf(91) + 1, selectedId.length() - 1);
        this.listener.attributeSelected(selectedId);
    }
}

