/*
 * Decompiled with CFR 0.152.
 */
package data;

import data.ByteData;
import data.Coordinate;
import data.Data;
import data.DoubleData;
import data.FloatData;
import data.ShortDataExtended;
import data.Statistic;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.ImageWindow;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.awt.Point;

class ShortData
extends Data {
    private int nx = 0;
    private int ny = 0;
    private int nz = 0;
    private int size = 0;
    private int boundaryCondition = 0;
    private int boundaryConstant = 0;
    private int dimension = 1;
    private int dir = 0;
    private ImageStack istack = null;
    private Object[] stack = null;
    private boolean fast = false;

    public ShortData(int n) {
        if (n < 1) {
            throw new IndexOutOfBoundsException("The nx size (" + n + ") of the image is incorrect.");
        }
        this.dimension = 1;
        this.nx = n;
        this.ny = 1;
        this.nz = 1;
        this.size = n;
        this.boundaryCondition = 0;
        this.dir = 0;
        this.istack = new ImageStack(n, this.ny);
        ShortProcessor shortProcessor = new ShortProcessor(n, this.ny);
        this.istack.addSlice("", (ImageProcessor)shortProcessor);
        this.stack = this.istack.getImageArray();
    }

    public ShortData(int n, int n2) {
        if (n < 1) {
            throw new IndexOutOfBoundsException("The nx size (" + n + ") of the image is incorrect.");
        }
        if (n2 < 1) {
            throw new IndexOutOfBoundsException("The ny size (" + n2 + ") of the image is incorrect.");
        }
        this.dimension = n2 == 1 ? 1 : 2;
        this.nx = n;
        this.ny = n2;
        this.nz = 1;
        this.size = n * n2;
        this.boundaryCondition = 0;
        this.dir = 0;
        this.istack = new ImageStack(n, n2);
        ShortProcessor shortProcessor = new ShortProcessor(n, n2);
        this.istack.addSlice("", (ImageProcessor)shortProcessor);
        this.stack = this.istack.getImageArray();
    }

    public ShortData(int n, int n2, int n3) {
        if (n < 1) {
            throw new IndexOutOfBoundsException("The nx size (" + n + ") of the image is incorrect.");
        }
        if (n2 < 1) {
            throw new IndexOutOfBoundsException("The ny size (" + n2 + ") of the image is incorrect.");
        }
        if (n3 < 1) {
            throw new IndexOutOfBoundsException("The nz size (" + n3 + ") of the image is incorrect.");
        }
        this.dimension = n2 == 1 && n3 == 1 ? 1 : (n3 == 1 ? 2 : 3);
        this.nx = n;
        this.ny = n2;
        this.nz = n3;
        this.size = n * n2 * n3;
        this.boundaryCondition = 0;
        this.dir = 3;
        this.istack = new ImageStack(n, n2);
        int n4 = 0;
        while (n4 < n3) {
            ShortProcessor shortProcessor = new ShortProcessor(n, n2);
            this.istack.addSlice("", (ImageProcessor)shortProcessor);
            ++n4;
        }
        this.stack = this.istack.getImageArray();
    }

    public ShortData(ImageProcessor imageProcessor) {
        this.nx = imageProcessor.getWidth();
        this.ny = imageProcessor.getHeight();
        this.nz = 1;
        this.size = this.nx * this.ny * this.nz;
        this.dimension = this.ny == 1 ? 1 : 2;
        this.boundaryCondition = 0;
        this.dir = 0;
        this.istack = new ImageStack(this.nx, this.ny);
        this.istack.addSlice("", imageProcessor);
        this.stack = this.istack.getImageArray();
    }

    public ShortData(ImagePlus imagePlus) {
        ImageProcessor imageProcessor = imagePlus.getProcessor();
        this.nx = imagePlus.getWidth();
        this.ny = imagePlus.getHeight();
        this.nz = imagePlus.getStackSize();
        this.size = this.nx * this.ny * this.nz;
        if (this.ny == 1 && this.nz == 1) {
            this.dimension = 1;
            this.istack = new ImageStack(this.nx, this.ny);
            this.istack.addSlice("", imageProcessor);
            this.dir = 0;
            this.stack = this.istack.getImageArray();
        } else if (this.nz == 1) {
            this.dimension = 2;
            this.istack = new ImageStack(this.nx, this.ny);
            this.istack.addSlice("", imageProcessor);
            this.dir = 0;
            this.stack = this.istack.getImageArray();
        } else {
            this.dimension = 3;
            this.istack = imagePlus.getStack();
            this.dir = 3;
            this.stack = this.istack.getImageArray();
        }
        this.boundaryCondition = 0;
    }

    public ShortData(ImagePlus imagePlus, int n) {
        throw new ArrayStoreException("Operation denied");
    }

    public ShortData(ImageStack imageStack) {
        this.istack = imageStack;
        this.nx = imageStack.getWidth();
        this.ny = imageStack.getHeight();
        this.nz = imageStack.getSize();
        this.size = this.nx * this.ny * this.nz;
        if (this.ny == 1 && this.nz == 1) {
            this.dimension = 1;
            this.dir = 0;
        } else if (this.nz == 1) {
            this.dimension = 2;
            this.dir = 0;
        } else {
            this.dimension = 3;
            this.dir = 3;
        }
        this.stack = imageStack.getImageArray();
        this.boundaryCondition = 0;
    }

    public double getInterpolatedPixel(double d) {
        return this.getInterpolatedPixel(d, 0.0, 0.0);
    }

    public double getInterpolatedPixel(double d, double d2) {
        return this.getInterpolatedPixel(d, d2, 0.0);
    }

    public double getInterpolatedPixel(double d, double d2, double d3) {
        double d4 = 0.0;
        switch (this.dimension) {
            case 1: {
                double[] dArray = new double[2];
                int n = ShortData.floor(d);
                double d5 = d - (double)n;
                this.getNeighborhood(n, dArray);
                return dArray[1] * d5 - dArray[0] * (d5 - 1.0);
            }
            case 2: {
                double[][] dArray = new double[2][2];
                int n = ShortData.floor(d);
                int n2 = ShortData.floor(d2);
                double d6 = d - (double)n;
                double d7 = d2 - (double)n2;
                this.getNeighborhood(n, n2, dArray);
                return d6 * (dArray[1][1] * d7 - dArray[1][0] * (d7 - 1.0)) - (d6 - 1.0) * (dArray[0][1] * d7 - dArray[0][0] * (d7 - 1.0));
            }
            case 3: {
                double[][][] dArray = new double[2][2][2];
                int n = ShortData.floor(d);
                int n3 = ShortData.floor(d2);
                int n4 = ShortData.floor(d3);
                double d8 = d - (double)n;
                double d9 = d2 - (double)n3;
                double d10 = d3 - (double)n4;
                this.getNeighborhood(n, n3, n4, dArray);
                double d11 = d8 * (dArray[1][1][0] * d9 - dArray[1][0][0] * (d9 - 1.0)) - (d8 - 1.0) * (dArray[0][1][0] * d9 - dArray[0][0][0] * (d9 - 1.0));
                double d12 = d8 * (dArray[1][1][1] * d9 - dArray[1][0][1] * (d9 - 1.0)) - (d8 - 1.0) * (dArray[0][1][1] * d9 - dArray[0][0][0] * (d9 - 1.0));
                return d12 * d10 - d11 * (d10 - 1.0);
            }
        }
        return d4;
    }

    public void get(Object object) {
        Coordinate coordinate = new Coordinate(0, 0, 0);
        this.get(coordinate, object);
    }

    public void put(Object object) {
        Coordinate coordinate = new Coordinate(0, 0, 0);
        this.put(coordinate, object);
    }

    public double get(Coordinate coordinate) {
        double d = 0.0;
        if (this.fast) {
            return ((short[])this.stack[coordinate.z])[coordinate.x + this.nx * coordinate.y] & 0xFFFF;
        }
        try {
            if (coordinate.x < 0) {
                d = ((short[])this.stack[-1])[0];
            }
            if (coordinate.x >= this.nx) {
                d = ((short[])this.stack[-1])[0];
            }
            d = ((short[])this.stack[coordinate.z])[coordinate.x + this.nx * coordinate.y] & 0xFFFF;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            switch (this.dimension) {
                case 3: {
                    if (coordinate.z < 0) {
                        throw new ArrayStoreException("z = " + coordinate.z + " out of bounds z<0");
                    }
                    if (coordinate.z >= this.nz) {
                        throw new ArrayStoreException("z = " + coordinate.z + " out of bounds z >= nz");
                    }
                }
                case 2: {
                    if (coordinate.y < 0) {
                        throw new ArrayStoreException("y = " + coordinate.y + " out of bounds y<0");
                    }
                    if (coordinate.y >= this.ny) {
                        throw new ArrayStoreException("y = " + coordinate.y + " out of bounds y >= ny");
                    }
                }
                case 1: {
                    if (coordinate.x < 0) {
                        throw new ArrayStoreException("x = " + coordinate.x + " out of bounds x<0");
                    }
                    if (coordinate.x < this.nx) break;
                    throw new ArrayStoreException("x = " + coordinate.x + " out of bounds x >= nx");
                }
            }
        }
        return d;
    }

    public void put(Coordinate coordinate, double d) {
        if (this.fast) {
            ((short[])this.stack[coordinate.z])[coordinate.x + this.nx * coordinate.y] = (short)ShortData.round(d);
            return;
        }
        try {
            double d2 = 0.0;
            if (coordinate.x < 0) {
                d2 = ((short[])this.stack[-1])[0];
            }
            if (coordinate.x >= this.nx) {
                d2 = ((short[])this.stack[-1])[0];
            }
            ((short[])this.stack[coordinate.z])[coordinate.x + this.nx * coordinate.y] = (short)ShortData.round(d);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            switch (this.dimension) {
                case 3: {
                    if (coordinate.z < 0) {
                        throw new ArrayStoreException("z = " + coordinate.z + " out of bounds z<0");
                    }
                    if (coordinate.z >= this.nz) {
                        throw new ArrayStoreException("z = " + coordinate.z + " out of bounds z >= nz");
                    }
                }
                case 2: {
                    if (coordinate.y < 0) {
                        throw new ArrayStoreException("y = " + coordinate.y + " out of bounds y<0");
                    }
                    if (coordinate.y >= this.ny) {
                        throw new ArrayStoreException("y = " + coordinate.y + " out of bounds y >= ny");
                    }
                }
                case 1: {
                    if (coordinate.x < 0) {
                        throw new ArrayStoreException("x = " + coordinate.x + " out of bounds x<0");
                    }
                    if (coordinate.x < this.nx) break;
                    throw new ArrayStoreException("x = " + coordinate.x + " out of bounds x >= nx");
                }
            }
        }
    }

    public void get(Coordinate coordinate, Object object) {
        switch (this.dimension) {
            case 2: {
                if (object instanceof double[][]) {
                    this.get(coordinate.x, coordinate.y, (double[][])object);
                    return;
                }
                if (object instanceof double[][][]) {
                    this.get(coordinate.x, coordinate.y, coordinate.z, (double[][][])object);
                    return;
                }
                if (object instanceof double[]) {
                    this.get(coordinate.x, coordinate.y, (double[])object);
                    return;
                }
            }
            case 3: {
                if (object instanceof double[][]) {
                    this.get(coordinate.x, coordinate.y, coordinate.z, (double[][])object);
                    return;
                }
                if (object instanceof double[][][]) {
                    this.get(coordinate.x, coordinate.y, coordinate.z, (double[][][])object);
                    return;
                }
                if (object instanceof double[]) {
                    this.get(coordinate.x, coordinate.y, coordinate.z, (double[])object);
                    return;
                }
            }
            case 1: {
                if (object instanceof double[]) {
                    this.get(coordinate.x, (double[])object);
                    return;
                }
                if (object instanceof double[][]) {
                    this.get(coordinate.x, 0, (double[][])object);
                    return;
                }
                if (!(object instanceof double[][][])) break;
                this.get(coordinate.x, 0, 0, (double[][][])object);
                return;
            }
        }
    }

    public void put(Coordinate coordinate, Object object) {
        switch (this.dimension) {
            case 2: {
                if (object instanceof double[][]) {
                    this.put(coordinate.x, coordinate.y, (double[][])object);
                    return;
                }
                if (object instanceof double[][][]) {
                    this.put(coordinate.x, coordinate.y, coordinate.z, (double[][][])object);
                    return;
                }
                if (object instanceof double[]) {
                    this.put(coordinate.x, coordinate.y, (double[])object);
                    return;
                }
            }
            case 3: {
                if (object instanceof double[][]) {
                    this.put(coordinate.x, coordinate.y, coordinate.z, (double[][])object);
                    return;
                }
                if (object instanceof double[][][]) {
                    this.put(coordinate.x, coordinate.y, coordinate.z, (double[][][])object);
                    return;
                }
                if (object instanceof double[]) {
                    this.put(coordinate.x, coordinate.y, coordinate.z, (double[])object);
                    return;
                }
            }
            case 1: {
                if (object instanceof double[]) {
                    this.put(coordinate.x, (double[])object);
                    return;
                }
                if (object instanceof double[][]) {
                    this.put(coordinate.x, 0, (double[][])object);
                    return;
                }
                if (!(object instanceof double[][][])) break;
                this.put(coordinate.x, 0, 0, (double[][][])object);
                return;
            }
        }
    }

    public void get(int n, int n2, int n3, double[][][] dArray) {
        int n4;
        int n5;
        int n6 = dArray.length;
        int n7 = dArray[0].length;
        int n8 = dArray[0][0].length;
        double d = 0.0;
        if (this.fast) {
            int n9 = 0;
            int n10 = n + n2 * this.nx;
            int n11 = this.nx - n6;
            int n12 = 0;
            while (n12 < n8) {
                n9 = n10;
                int n13 = 0;
                while (n13 < n7) {
                    int n14 = 0;
                    while (n14 < n6) {
                        dArray[n14][n13][n12] = ((short[])this.stack[n3])[n9++] & 0xFFFF;
                        ++n14;
                    }
                    n9 += n11;
                    ++n13;
                }
                ++n3;
                ++n12;
            }
            return;
        }
        try {
            if (n < 0) {
                d = ((short[])this.stack[-1])[0];
            }
            if (n >= this.nx) {
                d = ((short[])this.stack[-1])[0];
            }
            d = ((short[])this.stack[n3])[n + n2 * this.nx];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.MessageOutofBounds(n, n2, n3, this.nx, this.ny, this.nz);
            return;
        }
        catch (NullPointerException nullPointerException) {
            this.MessageOutofBounds(n, n2, n3, this.nx, this.ny, this.nz);
            return;
        }
        try {
            if (n + n6 >= this.nx) {
                d = ((short[])this.stack[-1])[0];
            }
            d = ((short[])this.stack[n3 + n8 - 1])[n + n6 - 1 + (n2 + n7 - 1) * this.nx];
            int n15 = n3;
            int n16 = 0;
            int n17 = n + n2 * this.nx;
            int n18 = this.nx - n6;
            int n19 = 0;
            while (n19 < n8) {
                n16 = n17;
                int n20 = 0;
                while (n20 < n7) {
                    int n21 = 0;
                    while (n21 < n6) {
                        dArray[n21][n20][n19] = ((short[])this.stack[n15])[n16++] & 0xFFFF;
                        ++n21;
                    }
                    n16 += n18;
                    ++n20;
                }
                ++n15;
                ++n19;
            }
            return;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
        }
        catch (NullPointerException nullPointerException) {}
        int[] nArray = new int[n6];
        int[] nArray2 = new int[n7];
        int[] nArray3 = new int[n8];
        int n22 = 0;
        int n23 = 0;
        int n24 = 0;
        int n25 = 0;
        switch (this.boundaryCondition) {
            case 0: {
                n23 = this.nx <= 1 ? 1 : 2 * this.nx - 2;
                n24 = this.ny <= 1 ? 1 : 2 * this.ny - 2;
                n25 = this.nz <= 1 ? 1 : 2 * this.nz - 2;
                n5 = 0;
                while (n5 < n6) {
                    n4 = n + n5;
                    while (n4 < 0) {
                        n4 += n23;
                    }
                    while (n4 >= this.nx) {
                        if ((n4 = n23 - n4) >= 0) continue;
                        n4 = -n4;
                    }
                    nArray[n5] = n4;
                    ++n5;
                }
                n5 = 0;
                while (n5 < n7) {
                    n4 = n2 + n5;
                    while (n4 < 0) {
                        n4 += n24;
                    }
                    while (n4 >= this.ny) {
                        if ((n4 = n24 - n4) >= 0) continue;
                        n4 = -n4;
                    }
                    nArray2[n5] = n4;
                    ++n5;
                }
                n5 = 0;
                while (n5 < n8) {
                    n4 = n3 + n5;
                    while (n4 < 0) {
                        n4 += n25;
                    }
                    while (n4 >= this.nz) {
                        if ((n4 = n25 - n4) >= 0) continue;
                        n4 = -n4;
                    }
                    nArray3[n5] = n4;
                    ++n5;
                }
                break;
            }
            case 1: {
                n23 = this.nx;
                n24 = this.ny;
                n25 = this.nz;
                n5 = 0;
                while (n5 < n6) {
                    n4 = n + n5;
                    while (n4 < 0) {
                        n4 += n23;
                    }
                    while (n4 >= this.nx) {
                        if ((n4 = n23 - n4) >= 0) continue;
                        n4 = -n4;
                    }
                    nArray[n5] = n4;
                    ++n5;
                }
                n5 = 0;
                while (n5 < n7) {
                    n4 = n2 + n5;
                    while (n4 < 0) {
                        n4 += n24;
                    }
                    while (n4 >= this.ny) {
                        if ((n4 = n24 - n4) >= 0) continue;
                        n4 = -n4;
                    }
                    nArray2[n5] = n4;
                    ++n5;
                }
                n5 = 0;
                while (n5 < n8) {
                    n4 = n3 + n5;
                    while (n4 < 0) {
                        n4 += n25;
                    }
                    while (n4 >= this.nz) {
                        if ((n4 = n25 - n4) >= 0) continue;
                        n4 = -n4;
                    }
                    nArray3[n5] = n4;
                    ++n5;
                }
                break;
            }
            case 2: {
                int n26;
                int n27;
                int n28 = 0;
                while (n28 < n8) {
                    n27 = 0;
                    while (n27 < n7) {
                        n26 = 0;
                        while (n26 < n6) {
                            dArray[n26][n27][n28] = (short)ShortData.round(this.boundaryConstant);
                            ++n26;
                        }
                        ++n27;
                    }
                    ++n28;
                }
                if (n + n6 > this.nx) {
                    n6 = this.nx - n;
                }
                if (n2 + n7 > this.ny) {
                    n7 = this.ny - n2;
                }
                if (n3 + n8 > this.nz) {
                    n8 = this.nz - n3;
                }
                n28 = n3;
                n27 = 0;
                n26 = n + n2 * this.nx;
                int n29 = this.nx - n6;
                int n30 = 0;
                while (n30 < n8) {
                    n27 = n26;
                    int n31 = 0;
                    while (n31 < n7) {
                        int n32 = 0;
                        while (n32 < n6) {
                            dArray[n32][n31][n30] = ((short[])this.stack[n28])[n27++] & 0xFFFF;
                            ++n32;
                        }
                        n27 += n29;
                        ++n31;
                    }
                    ++n28;
                    ++n30;
                }
                return;
            }
            default: {
                throw new ArrayStoreException("Unexpected boundary condition");
            }
        }
        n5 = 0;
        while (n5 < n8) {
            n4 = 0;
            while (n4 < n7) {
                int n33 = nArray2[n4] * this.nx;
                int n34 = 0;
                while (n34 < n6) {
                    n22 = n33 + nArray[n34];
                    dArray[n34][n4][n5] = ((short[])this.stack[nArray3[n5]])[n22] & 0xFFFF;
                    ++n34;
                }
                ++n4;
            }
            ++n5;
        }
    }

    public void get(int n, int n2, int n3, double[][] dArray) {
        ShortData shortData = null;
        Object[] objectArray = null;
        switch (this.dir) {
            case 3: {
                if (this.fast) {
                    int n4 = dArray.length;
                    int n5 = dArray[0].length;
                    int n6 = n2 * this.nx + n;
                    int n7 = this.nx - n4;
                    int n8 = 0;
                    while (n8 < n5) {
                        int n9 = 0;
                        while (n9 < n4) {
                            dArray[n9][n8] = ((short[])this.stack[n3])[n6++] & 0xFFFF;
                            ++n9;
                        }
                        n6 += n7;
                        ++n8;
                    }
                    return;
                }
                shortData = new ShortData(this.nx, this.ny);
                objectArray = ((Data)shortData).getReferencePixels();
                try {
                    int n10 = this.nx * this.ny;
                    int n11 = 0;
                    int n12 = 0;
                    while (n12 < n10) {
                        ((short[])objectArray[0])[n11] = ((short[])this.stack[n3])[n11];
                        ++n11;
                        ++n12;
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    this.MessageOutofBounds(0, 0, n3, this.nx, this.ny, this.nz);
                    return;
                }
                catch (NullPointerException nullPointerException) {
                    this.MessageOutofBounds(0, 0, n3, this.nx, this.ny, this.nz);
                    return;
                }
                ((Data)shortData).get(n, n2, dArray);
                return;
            }
            case 5: {
                if (this.fast) {
                    int n13 = dArray.length;
                    int n14 = dArray[0].length;
                    int n15 = n2 * this.nx + n;
                    int n16 = 0;
                    while (n16 < n14) {
                        int n17 = 0;
                        while (n17 < n13) {
                            dArray[n17][n16] = ((short[])this.stack[n3])[n17 + n15] & 0xFFFF;
                            ++n17;
                        }
                        ++n3;
                        ++n16;
                    }
                    return;
                }
                shortData = new ShortData(this.nx, this.nz);
                objectArray = ((Data)shortData).getReferencePixels();
                try {
                    int n18 = n2 * this.nx;
                    int n19 = 0;
                    int n20 = 0;
                    while (n20 < this.nz) {
                        int n21 = 0;
                        while (n21 < this.nx) {
                            ((short[])objectArray[0])[n19++] = ((short[])this.stack[n20])[n21 + n18];
                            ++n21;
                        }
                        ++n20;
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    this.MessageOutofBounds(0, n2, 0, this.nx, this.ny, this.nz);
                    return;
                }
                ((Data)shortData).get(n, n3, dArray);
                return;
            }
            case 4: {
                if (this.fast) {
                    int n22 = dArray.length;
                    int n23 = dArray[0].length;
                    int n24 = n2 * this.nx + n;
                    int n25 = n3;
                    int n26 = 0;
                    while (n26 < n23) {
                        n25 = n3;
                        int n27 = 0;
                        while (n27 < n22) {
                            dArray[n27][n26] = ((short[])this.stack[n25])[n24] & 0xFFFF;
                            ++n25;
                            ++n27;
                        }
                        n24 += this.nx;
                        ++n26;
                    }
                    return;
                }
                shortData = new ShortData(this.nz, this.ny);
                objectArray = ((Data)shortData).getReferencePixels();
                try {
                    int n28 = n;
                    int n29 = 0;
                    int n30 = 0;
                    while (n30 < this.ny) {
                        int n31 = 0;
                        while (n31 < this.nz) {
                            ((short[])objectArray[0])[n29++] = ((short[])this.stack[n31])[n28];
                            ++n31;
                        }
                        n28 += this.nx;
                        ++n30;
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    this.MessageOutofBounds(n, 0, 0, this.nx, this.ny, this.nz);
                    return;
                }
                ((Data)shortData).get(n3, n2, dArray);
                return;
            }
        }
        throw new ArrayStoreException("Unexpected direction" + this.dir);
    }

    public void get(int n, int n2, int n3, double[] dArray) {
        ShortData shortData = null;
        short[] sArray = null;
        switch (this.dir) {
            case 0: {
                if (this.fast) {
                    int n4 = dArray.length;
                    int n5 = n2 * this.nx + n;
                    int n6 = 0;
                    while (n6 < n4) {
                        dArray[n6] = ((short[])this.stack[n3])[n5++] & 0xFFFF;
                        ++n6;
                    }
                    return;
                }
                shortData = new ShortData(this.nx, this.ny);
                sArray = (short[])((Data)shortData).getReferencePixels()[0];
                try {
                    int n7 = 0;
                    int n8 = this.nx * this.ny;
                    int n9 = 0;
                    while (n9 < n8) {
                        sArray[n7] = ((short[])this.stack[n3])[n7];
                        ++n7;
                        ++n9;
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    this.MessageOutofBounds(0, 0, n3, this.nx, this.ny, this.nz);
                    return;
                }
                catch (NullPointerException nullPointerException) {
                    this.MessageOutofBounds(0, 0, n3, this.nx, this.ny, this.nz);
                    return;
                }
                ((Data)shortData).setDirection(0);
                ((Data)shortData).get(n, n2, dArray);
                return;
            }
            case 1: {
                if (this.fast) {
                    int n10 = dArray.length;
                    int n11 = n2 * this.nx + n;
                    int n12 = 0;
                    while (n12 < n10) {
                        dArray[n12] = ((short[])this.stack[n3])[n11] & 0xFFFF;
                        n11 += this.nx;
                        ++n12;
                    }
                    return;
                }
                shortData = new ShortData(this.nx, this.ny);
                sArray = (short[])((Data)shortData).getReferencePixels()[0];
                try {
                    int n13 = 0;
                    int n14 = this.nx * this.ny;
                    int n15 = 0;
                    while (n15 < n14) {
                        sArray[n13] = ((short[])this.stack[n3])[n13];
                        ++n13;
                        ++n15;
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    this.MessageOutofBounds(0, 0, n3, this.nx, this.ny, this.nz);
                    return;
                }
                catch (NullPointerException nullPointerException) {
                    this.MessageOutofBounds(0, 0, n3, this.nx, this.ny, this.nz);
                    return;
                }
                ((Data)shortData).setDirection(1);
                ((Data)shortData).get(n, n2, dArray);
                return;
            }
            case 2: {
                if (this.fast) {
                    int n16 = dArray.length;
                    int n17 = n2 * this.nx + n;
                    int n18 = 0;
                    while (n18 < n16) {
                        dArray[n18] = ((short[])this.stack[n3++])[n17] & 0xFFFF;
                        ++n18;
                    }
                    return;
                }
                shortData = new ShortData(this.nz, this.ny);
                sArray = (short[])((Data)shortData).getReferencePixels()[0];
                try {
                    int n19 = 0;
                    int n20 = n;
                    int n21 = 0;
                    while (n21 < this.ny) {
                        int n22 = 0;
                        while (n22 < this.nz) {
                            sArray[n19++] = ((short[])this.stack[n22])[n20];
                            ++n22;
                        }
                        n20 += this.nx;
                        ++n21;
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    this.MessageOutofBounds(n, 0, 0, this.nx, this.ny, this.nz);
                    return;
                }
                ((Data)shortData).setDirection(0);
                ((Data)shortData).get(n3, n2, dArray);
                return;
            }
        }
        throw new ArrayStoreException("Unexpected direction" + this.dir);
    }

    /*
     * Exception decompiling
     */
    public void get(int var1_1, int var2_2, double[][] var3_3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[CATCHBLOCK]], but top level block is 3[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void get(int var1_1, int var2_2, double[] var3_3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [19[CATCHBLOCK]], but top level block is 9[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void get(int var1_1, double[] var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[CATCHBLOCK]], but top level block is 3[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void put(int n, int n2, int n3, double[][][] dArray) {
        int n4;
        double d = 0.0;
        int n5 = dArray.length;
        int n6 = dArray[0].length;
        int n7 = dArray[0][0].length;
        if (this.fast) {
            int n8;
            int n9 = n8 = n2 * this.nx + n;
            int n10 = 0;
            while (n10 < n7) {
                n8 = n9;
                int n11 = 0;
                while (n11 < n6) {
                    int n12 = 0;
                    while (n12 < n5) {
                        ((short[])this.stack[n3])[n12 + n8] = (short)ShortData.round(dArray[n12][n11][n10]);
                        ++n12;
                    }
                    n8 += this.nx;
                    ++n11;
                }
                ++n3;
                ++n10;
            }
            return;
        }
        try {
            if (n < 0) {
                d = ((short[])this.stack[-1])[0];
            }
            if (n >= this.nx) {
                d = ((short[])this.stack[-1])[0];
            }
            d = ((short[])this.stack[n3])[n + n2 * this.nx];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.MessageOutofBounds(n, n2, n3, this.nx, this.ny, this.nz);
            return;
        }
        catch (NullPointerException nullPointerException) {
            this.MessageOutofBounds(n, n2, n3, this.nx, this.ny, this.nz);
            return;
        }
        int n13 = n4 = n2 * this.nx + n;
        int n14 = n3;
        try {
            if (n + n5 > this.nx) {
                d = ((short[])this.stack[-1])[0];
            }
            d = ((short[])this.stack[n3 + n7 - 1])[n + n5 - 1 + (n2 + n6 - 1) * this.nx];
            int n15 = 0;
            while (n15 < n7) {
                n4 = n13;
                int n16 = 0;
                while (n16 < n6) {
                    int n17 = 0;
                    while (n17 < n5) {
                        ((short[])this.stack[n14])[n17 + n4] = (short)ShortData.round(dArray[n17][n16][n15]);
                        ++n17;
                    }
                    n4 += this.nx;
                    ++n16;
                }
                ++n14;
                ++n15;
            }
            return;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
        }
        catch (NullPointerException nullPointerException) {}
        if (n + n5 > this.nx) {
            n5 = this.nx - n;
        }
        if (n2 + n6 > this.ny) {
            n6 = this.ny - n2;
        }
        if (n3 + n7 > this.nz) {
            n7 = this.nz - n3;
        }
        int n18 = 0;
        while (n18 < n7) {
            n4 = n13;
            int n19 = 0;
            while (n19 < n6) {
                int n20 = 0;
                while (n20 < n5) {
                    ((short[])this.stack[n14])[n20 + n4] = (short)ShortData.round(dArray[n20][n19][n18]);
                    ++n20;
                }
                n4 += this.nx;
                ++n19;
            }
            ++n14;
            ++n18;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void put(int var1_1, int var2_2, int var3_3, double[][] var4_4) {
        if (this.fast) {
            var5_5 = var4_4.length;
            var6_7 = var4_4[0].length;
            var7_8 = 0.0;
            switch (this.dir) {
                case 3: {
                    var9_10 = var2_2 * this.nx + var1_1;
                    var10_16 = 0;
                    while (var10_16 < var6_7) {
                        var11_23 = 0;
                        while (var11_23 < var5_5) {
                            ((short[])this.stack[var3_3])[var11_23 + var9_10] = (short)ShortData.round(var4_4[var11_23][var10_16]);
                            ++var11_23;
                        }
                        var9_10 += this.nx;
                        ++var10_16;
                    }
                    return;
                }
                case 5: {
                    var9_11 = var2_2 * this.nx + var1_1;
                    var10_17 = 0;
                    while (var10_17 < var6_7) {
                        var11_24 = 0;
                        while (var11_24 < var5_5) {
                            ((short[])this.stack[var3_3])[var9_11 + var11_24] = (short)ShortData.round(var4_4[var11_24][var10_17]);
                            ++var11_24;
                        }
                        ++var3_3;
                        ++var10_17;
                    }
                    return;
                }
                case 4: {
                    var9_12 = var2_2 * this.nx + var1_1;
                    var10_18 = 0;
                    while (var10_18 < var6_7) {
                        var11_25 = 0;
                        while (var11_25 < var5_5) {
                            ((short[])this.stack[var3_3 + var11_25])[var9_12] = (short)ShortData.round(var4_4[var11_25][var10_18]);
                            ++var11_25;
                        }
                        var9_12 += this.nx;
                        ++var10_18;
                    }
                    return;
                }
            }
            throw new ArrayStoreException("Unexpected direction" + this.dir);
        }
        var5_6 = 0.0;
        try {
            if (var1_1 < 0) {
                var5_6 = ((short[])this.stack[-1])[0];
            }
            if (var1_1 >= this.nx) {
                var5_6 = ((short[])this.stack[-1])[0];
            }
            var5_6 = ((short[])this.stack[var3_3])[var1_1 + var2_2 * this.nx];
        }
        catch (ArrayIndexOutOfBoundsException v0) {
            this.MessageOutofBounds(var1_1, var2_2, var3_3, this.nx, this.ny, this.nz);
            return;
        }
        catch (NullPointerException v1) {
            this.MessageOutofBounds(var1_1, var2_2, var3_3, this.nx, this.ny, this.nz);
            return;
        }
        var7_9 = var4_4.length;
        var8_32 = var4_4[0].length;
        switch (this.dir) {
            case 3: {
                try {
                    if (var1_1 + var7_9 > this.nx) {
                        var5_6 = ((short[])this.stack[-1])[0];
                    }
                    var5_6 = ((short[])this.stack[var3_3])[var1_1 + var7_9 - 1 + (var2_2 + var8_32 - 1) * this.nx];
                    var9_13 = var2_2 * this.nx + var1_1;
                    var10_19 = 0;
                    while (var10_19 < var8_32) {
                        var11_26 = 0;
                        while (var11_26 < var7_9) {
                            ((short[])this.stack[var3_3])[var11_26 + var9_13] = (short)ShortData.round(var4_4[var11_26][var10_19]);
                            ++var11_26;
                        }
                        var9_13 += this.nx;
                        ++var10_19;
                    }
                    return;
                }
                catch (ArrayIndexOutOfBoundsException v2) {
                    if (var1_1 + var7_9 > this.nx) {
                        var7_9 = this.nx - var1_1;
                    }
                    if (var2_2 + var8_32 > this.ny) {
                        var8_32 = this.ny - var2_2;
                    }
                    var9_14 = var2_2 * this.nx + var1_1;
                    var10_20 = 0;
                    ** while (var10_20 < var8_32)
                }
lbl-1000:
                // 1 sources

                {
                    var11_27 = 0;
                    while (var11_27 < var7_9) {
                        ((short[])this.stack[var3_3])[var11_27 + var9_14] = (short)ShortData.round(var4_4[var11_27][var10_20]);
                        ++var11_27;
                    }
                    var9_14 += this.nx;
                    ++var10_20;
                    continue;
                }
lbl96:
                // 1 sources

                return;
            }
            case 5: {
                var9_15 = var3_3;
                try {
                    if (var1_1 + var7_9 > this.nx) {
                        var5_6 = ((short[])this.stack[-1])[0];
                    }
                    var5_6 = ((short[])this.stack[var3_3 + var8_32 - 1])[var1_1 + var7_9 - 1 + var2_2 * this.nx];
                    var10_21 = var2_2 * this.nx + var1_1;
                    var11_28 = 0;
                    while (var11_28 < var8_32) {
                        var12_33 = 0;
                        while (var12_33 < var7_9) {
                            ((short[])this.stack[var9_15])[var10_21 + var12_33] = (short)ShortData.round(var4_4[var12_33][var11_28]);
                            ++var12_33;
                        }
                        ++var9_15;
                        ++var11_28;
                    }
                    return;
                }
                catch (ArrayIndexOutOfBoundsException v3) {
                }
                catch (NullPointerException v4) {}
                if (var1_1 + var7_9 > this.nx) {
                    var7_9 = this.nx - var1_1;
                }
                if (var3_3 + var8_32 > this.nz) {
                    var8_32 = this.nz - var3_3;
                }
                var10_22 = var2_2 * this.nx + var1_1;
                var11_29 = 0;
                while (var11_29 < var8_32) {
                    var12_34 = 0;
                    while (var12_34 < var7_9) {
                        ((short[])this.stack[var9_15])[var10_22 + var12_34] = (short)ShortData.round(var4_4[var12_34][var11_29]);
                        ++var12_34;
                    }
                    ++var9_15;
                    ++var11_29;
                }
                return;
            }
            case 4: {
                try {
                    if (var1_1 + var7_9 > this.nx) {
                        var5_6 = ((short[])this.stack[-1])[0];
                    }
                    var5_6 = ((short[])this.stack[var3_3 + var7_9 - 1])[var1_1 + (var2_2 + var8_32 - 1) * this.nx];
                    var11_30 = var2_2 * this.nx + var1_1;
                    var12_35 = 0;
                    while (var12_35 < var8_32) {
                        var13_37 = 0;
                        while (var13_37 < var7_9) {
                            ((short[])this.stack[var3_3 + var13_37])[var11_30] = (short)ShortData.round(var4_4[var13_37][var12_35]);
                            ++var13_37;
                        }
                        var11_30 += this.nx;
                        ++var12_35;
                    }
                    return;
                }
                catch (ArrayIndexOutOfBoundsException v5) {
                }
                catch (NullPointerException v6) {}
                if (var2_2 + var8_32 > this.ny) {
                    var8_32 = this.ny - var2_2;
                }
                if (var3_3 + var7_9 > this.nz) {
                    var7_9 = this.nz - var3_3;
                }
                var11_31 = var2_2 * this.nx + var1_1;
                var12_36 = 0;
                while (var12_36 < var8_32) {
                    var13_38 = 0;
                    while (var13_38 < var7_9) {
                        ((short[])this.stack[var3_3 + var13_38])[var11_31] = (short)ShortData.round(var4_4[var13_38][var12_36]);
                        ++var13_38;
                    }
                    var11_31 += this.nx;
                    ++var12_36;
                }
                return;
            }
        }
        throw new ArrayStoreException("Unexpected direction" + this.dir);
    }

    /*
     * Unable to fully structure code
     */
    public void put(int var1_1, int var2_2, int var3_3, double[] var4_4) {
        if (this.fast) {
            var5_5 = var4_4.length;
            var6_7 = 0.0;
            switch (this.dir) {
                case 0: {
                    var8_9 = var1_1 + var2_2 * this.nx;
                    var9_13 = 0;
                    while (var9_13 < var5_5) {
                        ((short[])this.stack[var3_3])[var8_9++] = (short)ShortData.round(var4_4[var9_13]);
                        ++var9_13;
                    }
                    return;
                }
                case 1: {
                    var8_10 = var1_1 + var2_2 * this.nx;
                    var9_14 = 0;
                    while (var9_14 < var5_5) {
                        ((short[])this.stack[var3_3])[var8_10] = (short)ShortData.round(var4_4[var9_14]);
                        var8_10 += this.nx;
                        ++var9_14;
                    }
                    return;
                }
                case 2: {
                    var8_11 = var1_1 + var2_2 * this.nx;
                    var9_15 = 0;
                    while (var9_15 < var5_5) {
                        ((short[])this.stack[var3_3++])[var8_11] = (short)ShortData.round(var4_4[var9_15]);
                        ++var9_15;
                    }
                    return;
                }
            }
            throw new ArrayStoreException("Unexpected direction" + this.dir);
        }
        var5_6 = var1_1 + var2_2 * this.nx;
        var6_8 = 0.0;
        try {
            if (var1_1 < 0) {
                var6_8 = ((short[])this.stack[-1])[0];
            }
            if (var1_1 >= this.nx) {
                var6_8 = ((short[])this.stack[-1])[0];
            }
            var6_8 = ((short[])this.stack[var3_3])[var5_6];
        }
        catch (ArrayIndexOutOfBoundsException v0) {
            this.MessageOutofBounds(var1_1, var2_2, var3_3, this.nx, this.ny, this.nz);
            return;
        }
        catch (NullPointerException v1) {
            this.MessageOutofBounds(var1_1, var2_2, var3_3, this.nx, this.ny, this.nz);
            return;
        }
        var8_12 = var4_4.length;
        switch (this.dir) {
            case 0: {
                try {
                    if (var1_1 + var8_12 > this.nx) {
                        var6_8 = ((short[])this.stack[-1])[0];
                    }
                    var9_16 = 0;
                    while (var9_16 < var8_12) {
                        ((short[])this.stack[var3_3])[var5_6++] = (short)ShortData.round(var4_4[var9_16]);
                        ++var9_16;
                    }
                    return;
                }
                catch (ArrayIndexOutOfBoundsException v2) {
                    var5_6 = var1_1 + var2_2 * this.nx;
                    var8_12 = this.nx - var1_1;
                    var9_17 = 0;
                    ** while (var9_17 < var8_12)
                }
lbl-1000:
                // 1 sources

                {
                    ((short[])this.stack[var3_3])[var5_6++] = (short)ShortData.round(var4_4[var9_17]);
                    ++var9_17;
                    continue;
                }
lbl66:
                // 1 sources

                return;
            }
            case 1: {
                try {
                    var6_8 = ((short[])this.stack[var3_3])[var1_1 + (var2_2 + var8_12 - 1) * this.nx];
                    var9_18 = 0;
                    while (var9_18 < var8_12) {
                        ((short[])this.stack[var3_3])[var5_6] = (short)ShortData.round(var4_4[var9_18]);
                        var5_6 += this.nx;
                        ++var9_18;
                    }
                    return;
                }
                catch (ArrayIndexOutOfBoundsException v3) {
                    var8_12 = this.ny - var2_2;
                    var5_6 = var1_1 + var2_2 * this.nx;
                    var9_19 = 0;
                    ** while (var9_19 < var8_12)
                }
lbl-1000:
                // 1 sources

                {
                    ((short[])this.stack[var3_3])[var5_6] = (short)ShortData.round(var4_4[var9_19]);
                    var5_6 += this.nx;
                    ++var9_19;
                    continue;
                }
lbl86:
                // 1 sources

                return;
            }
            case 2: {
                var9_20 = var3_3;
                try {
                    var6_8 = ((short[])this.stack[var3_3 + var8_12 - 1])[var1_1 + var2_2 * this.nx];
                    var10_21 = 0;
                    while (var10_21 < var8_12) {
                        ((short[])this.stack[var9_20++])[var5_6] = (short)ShortData.round(var4_4[var10_21]);
                        ++var10_21;
                    }
                    return;
                }
                catch (ArrayIndexOutOfBoundsException v4) {
                }
                catch (NullPointerException v5) {}
                var8_12 = this.nz - var3_3;
                var10_22 = 0;
                while (var10_22 < var8_12) {
                    ((short[])this.stack[var3_3++])[var5_6] = (short)ShortData.round(var4_4[var10_22]);
                    ++var10_22;
                }
                return;
            }
        }
        throw new ArrayStoreException("Unexpected direction" + this.dir);
    }

    /*
     * Unable to fully structure code
     */
    public void put(int var1_1, int var2_2, double[][] var3_3) {
        var4_4 = 0.0;
        var6_5 = var3_3.length;
        var7_6 = var3_3[0].length;
        if (this.fast) {
            var8_7 = var2_2 * this.nx + var1_1;
            var9_9 = 0;
            while (var9_9 < var7_6) {
                var10_12 = 0;
                while (var10_12 < var6_5) {
                    ((short[])this.stack[0])[var10_12 + var8_7] = (short)ShortData.round(var3_3[var10_12][var9_9]);
                    ++var10_12;
                }
                var8_7 += this.nx;
                ++var9_9;
            }
            return;
        }
        try {
            if (var1_1 < 0) {
                var4_4 = ((short[])this.stack[-1])[0];
            }
            if (var1_1 >= this.nx) {
                var4_4 = ((short[])this.stack[-1])[0];
            }
            var4_4 = ((short[])this.stack[0])[var1_1 + var2_2 * this.nx];
        }
        catch (ArrayIndexOutOfBoundsException v0) {
            this.MessageOutofBounds(var1_1, var2_2, 0, this.nx, this.ny, this.nz);
            return;
        }
        var8_8 = var2_2 * this.nx + var1_1;
        try {
            if (var1_1 + var6_5 > this.nx) {
                var4_4 = ((short[])this.stack[-1])[0];
            }
            var4_4 = ((short[])this.stack[0])[var1_1 + var6_5 - 1 + (var2_2 + var7_6 - 1) * this.nx];
            var9_10 = 0;
            while (var9_10 < var7_6) {
                var10_13 = 0;
                while (var10_13 < var6_5) {
                    ((short[])this.stack[0])[var10_13 + var8_8] = (short)ShortData.round(var3_3[var10_13][var9_10]);
                    ++var10_13;
                }
                var8_8 += this.nx;
                ++var9_10;
            }
            return;
        }
        catch (ArrayIndexOutOfBoundsException v1) {
            if (var1_1 + var6_5 > this.nx) {
                var6_5 = this.nx - var1_1;
            }
            if (var2_2 + var7_6 > this.ny) {
                var7_6 = this.ny - var2_2;
            }
            var8_8 = var2_2 * this.nx + var1_1;
            var9_11 = 0;
            ** while (var9_11 < var7_6)
        }
lbl-1000:
        // 1 sources

        {
            var10_14 = 0;
            while (var10_14 < var6_5) {
                ((short[])this.stack[0])[var10_14 + var8_8] = (short)ShortData.round(var3_3[var10_14][var9_11]);
                ++var10_14;
            }
            var8_8 += this.nx;
            ++var9_11;
            continue;
        }
lbl59:
        // 1 sources

    }

    public void put(int n, int n2, double[] dArray) {
        if (this.fast) {
            int n3 = 0;
            switch (this.dir) {
                case 0: {
                    int n4 = dArray.length;
                    n3 = n2 * this.nx + n;
                    int n5 = 0;
                    int n6 = 0;
                    if (n >= 0) {
                        n6 = n <= this.nx - n4 ? n4 : -n + this.nx;
                        int n7 = n5;
                        while (n7 < n6) {
                            ((short[])this.stack[0])[n3++] = (short)ShortData.round(dArray[n7]);
                            ++n7;
                        }
                        return;
                    }
                    n3 = n2 * this.nx;
                    n5 = -n;
                    n6 = n <= this.nx - n4 ? n4 : -n + this.nx;
                    int n8 = n5;
                    while (n8 < n6) {
                        ((short[])this.stack[0])[n3++] = (short)ShortData.round(dArray[n8]);
                        ++n8;
                    }
                    return;
                }
                case 1: {
                    int n9 = dArray.length;
                    n3 = n2 * this.nx + n;
                    int n10 = 0;
                    int n11 = 0;
                    if (n2 >= 0) {
                        n11 = n2 <= this.ny - n9 ? n9 : -n2 + this.ny;
                        int n12 = n10;
                        while (n12 < n11) {
                            ((short[])this.stack[0])[n3] = (short)ShortData.round(dArray[n12]);
                            n3 += this.nx;
                            ++n12;
                        }
                        return;
                    }
                    n3 = n;
                    n10 = -n2;
                    n11 = n2 <= this.ny - n9 ? n9 : -n2 + this.ny;
                    int n13 = n10;
                    while (n13 < n11) {
                        ((short[])this.stack[0])[n3] = (short)ShortData.round(dArray[n13]);
                        n3 += this.nx;
                        ++n13;
                    }
                    return;
                }
            }
            throw new ArrayStoreException("Unexpected direction" + this.dir);
        }
        int n14 = 0;
        switch (this.dir) {
            case 0: {
                int n15 = dArray.length;
                double d = 0.0;
                try {
                    if (n >= this.nx) {
                        d = ((short[])this.stack[-1])[0];
                    }
                    d = ((short[])this.stack[0])[n2 * this.nx];
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    this.MessageOutofBounds(n, n2, 0, this.nx, this.ny, this.nz);
                    return;
                }
                n14 = n2 * this.nx + n;
                int n16 = 0;
                int n17 = 0;
                if (n >= 0) {
                    n17 = n <= this.nx - n15 ? n15 : -n + this.nx;
                    int n18 = n16;
                    while (n18 < n17) {
                        ((short[])this.stack[0])[n14++] = (short)ShortData.round(dArray[n18]);
                        ++n18;
                    }
                    return;
                }
                n14 = n2 * this.nx;
                n16 = -n;
                n17 = n <= this.nx - n15 ? n15 : -n + this.nx;
                int n19 = n16;
                while (n19 < n17) {
                    ((short[])this.stack[0])[n14++] = (short)ShortData.round(dArray[n19]);
                    ++n19;
                }
                return;
            }
            case 1: {
                int n20 = dArray.length;
                try {
                    double d;
                    if (n < 0) {
                        d = ((short[])this.stack[-1])[0];
                    }
                    if (n >= this.nx) {
                        d = ((short[])this.stack[-1])[0];
                    }
                    if (n2 >= this.ny) {
                        d = ((short[])this.stack[-1])[0];
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    this.MessageOutofBounds(n, 0, 0, this.nx, this.ny, this.nz);
                    return;
                }
                n14 = n2 * this.nx + n;
                int n21 = 0;
                int n22 = 0;
                if (n2 >= 0) {
                    n22 = n2 <= this.ny - n20 ? n20 : -n2 + this.ny;
                    int n23 = n21;
                    while (n23 < n22) {
                        ((short[])this.stack[0])[n14] = (short)ShortData.round(dArray[n23]);
                        n14 += this.nx;
                        ++n23;
                    }
                    return;
                }
                n14 = n;
                n21 = -n2;
                n22 = n2 <= this.ny - n20 ? n20 : -n2 + this.ny;
                int n24 = n21;
                while (n24 < n22) {
                    ((short[])this.stack[0])[n14] = (short)ShortData.round(dArray[n24]);
                    n14 += this.nx;
                    ++n24;
                }
                return;
            }
        }
        throw new ArrayStoreException("Unexpected direction" + this.dir);
    }

    /*
     * Unable to fully structure code
     */
    public void put(int var1_1, double[] var2_2) {
        if (this.fast) {
            var3_3 = var2_2.length;
            var4_5 = 0;
            while (var4_5 < var3_3) {
                ((short[])this.stack[0])[var1_1 + var4_5] = (short)ShortData.round(var2_2[var4_5]);
                ++var4_5;
            }
            return;
        }
        var3_4 = 0.0;
        try {
            if (var1_1 < 0) {
                var3_4 = ((short[])this.stack[-1])[0];
            }
            if (var1_1 >= this.nx) {
                var3_4 = ((short[])this.stack[-1])[0];
            }
        }
        catch (ArrayIndexOutOfBoundsException v0) {
            this.MessageOutofBounds(var1_1, 0, 0, this.nx, this.ny, this.nz);
            return;
        }
        var5_6 = var2_2.length;
        try {
            if (var1_1 + var5_6 > this.nx) {
                var3_4 = ((short[])this.stack[-1])[0];
            }
            var6_7 = 0;
            while (var6_7 < var5_6) {
                ((short[])this.stack[0])[var1_1 + var6_7] = (short)ShortData.round(var2_2[var6_7]);
                ++var6_7;
            }
            return;
        }
        catch (ArrayIndexOutOfBoundsException v1) {
            var5_6 = this.nx - var1_1;
            var6_8 = 0;
            ** while (var6_8 < var5_6)
        }
lbl-1000:
        // 1 sources

        {
            ((short[])this.stack[0])[var1_1++] = (short)ShortData.round(var2_2[var6_8]);
            ++var6_8;
            continue;
        }
lbl36:
        // 1 sources

    }

    public void getNeighborhood(Coordinate coordinate, Object object) {
        switch (this.dimension) {
            case 2: {
                if (object instanceof double[][]) {
                    this.getNeighborhood(coordinate.x, coordinate.y, (double[][])object);
                    return;
                }
                if (object instanceof double[][][]) {
                    this.getNeighborhood(coordinate.x, coordinate.y, coordinate.z, (double[][][])object);
                    return;
                }
                if (object instanceof double[]) {
                    this.getNeighborhood(coordinate.x, coordinate.y, (double[])object);
                    return;
                }
            }
            case 3: {
                if (object instanceof double[][]) {
                    this.getNeighborhood(coordinate.x, coordinate.y, coordinate.z, (double[][])object);
                    return;
                }
                if (object instanceof double[][][]) {
                    this.getNeighborhood(coordinate.x, coordinate.y, coordinate.z, (double[][][])object);
                    return;
                }
                if (object instanceof double[]) {
                    this.getNeighborhood(coordinate.x, coordinate.y, coordinate.z, (double[])object);
                    return;
                }
            }
            case 1: {
                if (object instanceof double[]) {
                    this.getNeighborhood(coordinate.x, (double[])object);
                    return;
                }
                if (object instanceof double[][]) {
                    this.getNeighborhood(coordinate.x, 0, (double[][])object);
                    return;
                }
                if (!(object instanceof double[][][])) break;
                this.getNeighborhood(coordinate.x, 0, 0, (double[][][])object);
                return;
            }
        }
    }

    public void getNeighborhood(int n, int n2, int n3, double[][][] dArray) {
        int n4;
        int n5;
        double d = 0.0;
        int n6 = dArray.length;
        int n7 = dArray[0].length;
        int n8 = dArray[0][0].length;
        int n9 = (n6 - 1) / 2;
        int n10 = (n7 - 1) / 2;
        int n11 = (n8 - 1) / 2;
        int n12 = n - n9;
        int n13 = n2 - n10;
        int n14 = n3 - n11;
        if (this.fast) {
            int n15 = 0;
            int n16 = n12 + n13 * this.nx;
            int n17 = this.nx - n6;
            int n18 = n14;
            int n19 = 0;
            while (n19 < n8) {
                n15 = n16;
                int n20 = 0;
                while (n20 < n7) {
                    int n21 = 0;
                    while (n21 < n6) {
                        dArray[n21][n20][n19] = ((short[])this.stack[n18])[n15++] & 0xFFFF;
                        ++n21;
                    }
                    n15 += n17;
                    ++n20;
                }
                ++n18;
                ++n19;
            }
            return;
        }
        try {
            if (n < 0) {
                d = ((short[])this.stack[-1])[0];
            }
            if (n >= this.nx) {
                d = ((short[])this.stack[-1])[0];
            }
            d = ((short[])this.stack[n3])[n + n2 * this.nx];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.MessageOutofBounds(n, n2, n3, this.nx, this.ny, this.nz);
            return;
        }
        catch (NullPointerException nullPointerException) {
            this.MessageOutofBounds(n, n2, n3, this.nx, this.ny, this.nz);
            return;
        }
        try {
            if (n <= n9) {
                d = ((short[])this.stack[-1])[0];
            }
            if (n > this.nx - n9 - 1) {
                d = ((short[])this.stack[-1])[0];
            }
            d = ((short[])this.stack[n3 + n11 - 1])[n + n9 - 1 + (n2 + n10 - 1) * this.nx];
            int n22 = 0;
            int n23 = n12 + n13 * this.nx;
            int n24 = this.nx - n6;
            int n25 = n14;
            int n26 = 0;
            while (n26 < n8) {
                n22 = n23;
                int n27 = 0;
                while (n27 < n7) {
                    int n28 = 0;
                    while (n28 < n6) {
                        dArray[n28][n27][n26] = ((short[])this.stack[n25])[n22++] & 0xFFFF;
                        ++n28;
                    }
                    n22 += n24;
                    ++n27;
                }
                ++n25;
                ++n26;
            }
            return;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
        }
        catch (NullPointerException nullPointerException) {}
        int[] nArray = new int[n6];
        int[] nArray2 = new int[n7];
        int[] nArray3 = new int[n8];
        int n29 = 0;
        int n30 = 0;
        int n31 = 0;
        int n32 = 0;
        switch (this.boundaryCondition) {
            case 0: {
                n30 = this.nx <= 1 ? 1 : 2 * this.nx - 2;
                n31 = this.ny <= 1 ? 1 : 2 * this.ny - 2;
                n32 = this.nz <= 1 ? 1 : 2 * this.nz - 2;
                n5 = 0;
                while (n5 < n6) {
                    n4 = n12 + n5;
                    while (n4 < 0) {
                        n4 += n30;
                    }
                    while (n4 >= this.nx) {
                        if ((n4 = n30 - n4) >= 0) continue;
                        n4 = -n4;
                    }
                    nArray[n5] = n4;
                    ++n5;
                }
                n5 = 0;
                while (n5 < n7) {
                    n4 = n13 + n5;
                    while (n4 < 0) {
                        n4 += n31;
                    }
                    while (n4 >= this.ny) {
                        if ((n4 = n31 - n4) >= 0) continue;
                        n4 = -n4;
                    }
                    nArray2[n5] = n4;
                    ++n5;
                }
                n5 = 0;
                while (n5 < n8) {
                    n4 = n14 + n5;
                    while (n4 < 0) {
                        n4 += n32;
                    }
                    while (n4 >= this.nz) {
                        if ((n4 = n32 - n4) >= 0) continue;
                        n4 = -n4;
                    }
                    nArray3[n5] = n4;
                    ++n5;
                }
                break;
            }
            case 1: {
                n30 = this.nx;
                n31 = this.ny;
                n32 = this.nz;
                n5 = 0;
                while (n5 < n6) {
                    n4 = n12 + n5;
                    while (n4 < 0) {
                        n4 += n30;
                    }
                    while (n4 >= this.nx) {
                        if ((n4 = n30 - n4) >= 0) continue;
                        n4 = -n4;
                    }
                    nArray[n5] = n4;
                    ++n5;
                }
                n5 = 0;
                while (n5 < n7) {
                    n4 = n13 + n5;
                    while (n4 < 0) {
                        n4 += n31;
                    }
                    while (n4 >= this.ny) {
                        if ((n4 = n31 - n4) >= 0) continue;
                        n4 = -n4;
                    }
                    nArray2[n5] = n4;
                    ++n5;
                }
                n5 = 0;
                while (n5 < n8) {
                    n4 = n14 + n5;
                    while (n4 < 0) {
                        n4 += n32;
                    }
                    while (n4 >= this.nz) {
                        if ((n4 = n32 - n4) >= 0) continue;
                        n4 = -n4;
                    }
                    nArray3[n5] = n4;
                    ++n5;
                }
                break;
            }
            default: {
                throw new ArrayStoreException("Unexpected boundary condition");
            }
        }
        n5 = 0;
        while (n5 < n8) {
            n4 = 0;
            while (n4 < n7) {
                int n33 = nArray2[n4] * this.nx;
                int n34 = 0;
                while (n34 < n6) {
                    n29 = n33 + nArray[n34];
                    dArray[n34][n4][n5] = ((short[])this.stack[nArray3[n5]])[n29] & 0xFFFF;
                    ++n34;
                }
                ++n4;
            }
            ++n5;
        }
    }

    public void getNeighborhood(int n, int n2, int n3, double[][] dArray) {
        int n4 = dArray.length;
        int n5 = dArray[0].length;
        ShortData shortData = null;
        Object[] objectArray = null;
        switch (this.dir) {
            case 3: {
                if (this.fast) {
                    int n6 = dArray.length;
                    int n7 = dArray[0].length;
                    int n8 = (n6 - 1) / 2;
                    int n9 = (n7 - 1) / 2;
                    int n10 = (n2 - n9) * this.nx + n - n8;
                    int n11 = this.nx - n6;
                    int n12 = 0;
                    while (n12 < n7) {
                        int n13 = 0;
                        while (n13 < n6) {
                            dArray[n13][n12] = ((short[])this.stack[n3])[n10++] & 0xFFFF;
                            ++n13;
                        }
                        n10 += n11;
                        ++n12;
                    }
                    return;
                }
                shortData = new ShortData(this.nx, this.ny);
                objectArray = ((Data)shortData).getReferencePixels();
                try {
                    int n14 = this.nx * this.ny;
                    int n15 = 0;
                    int n16 = 0;
                    while (n16 < n14) {
                        ((short[])objectArray[0])[n15] = ((short[])this.stack[n3])[n15];
                        ++n15;
                        ++n16;
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    this.MessageOutofBounds(0, 0, n3, this.nx, this.ny, this.nz);
                    return;
                }
                catch (NullPointerException nullPointerException) {
                    this.MessageOutofBounds(0, 0, n3, this.nx, this.ny, this.nz);
                    return;
                }
                ((Data)shortData).getNeighborhood(n, n2, dArray);
                return;
            }
            case 5: {
                if (this.fast) {
                    int n17 = dArray.length;
                    int n18 = dArray[0].length;
                    int n19 = (n17 - 1) / 2;
                    int n20 = (n18 - 1) / 2;
                    int n21 = n - n19;
                    int n22 = n3 - n20;
                    int n23 = n2 * this.nx + n21;
                    int n24 = 0;
                    while (n24 < n18) {
                        int n25 = 0;
                        while (n25 < n17) {
                            dArray[n25][n24] = ((short[])this.stack[n22])[n23 + n25] & 0xFFFF;
                            ++n25;
                        }
                        ++n22;
                        ++n24;
                    }
                    return;
                }
                shortData = new ShortData(this.nx, this.nz);
                objectArray = ((Data)shortData).getReferencePixels();
                try {
                    int n26 = n2 * this.nx;
                    int n27 = 0;
                    int n28 = 0;
                    while (n28 < this.nz) {
                        int n29 = 0;
                        while (n29 < this.nx) {
                            ((short[])objectArray[0])[n27++] = ((short[])this.stack[n28])[n29 + n26];
                            ++n29;
                        }
                        ++n28;
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    this.MessageOutofBounds(0, n2, 0, this.nx, this.ny, this.nz);
                    return;
                }
                ((Data)shortData).getNeighborhood(n, n3, dArray);
                return;
            }
            case 4: {
                if (this.fast) {
                    int n30 = dArray.length;
                    int n31 = dArray[0].length;
                    int n32 = (n30 - 1) / 2;
                    int n33 = (n31 - 1) / 2;
                    int n34 = n3 - n32;
                    int n35 = n2 - n33;
                    int n36 = n35 * this.nx + n;
                    int n37 = n34;
                    int n38 = 0;
                    while (n38 < n31) {
                        n37 = n3;
                        int n39 = 0;
                        while (n39 < n30) {
                            dArray[n39][n38] = ((short[])this.stack[n37])[n36] & 0xFFFF;
                            ++n37;
                            ++n39;
                        }
                        n36 += this.nx;
                        ++n38;
                    }
                    return;
                }
                shortData = new ShortData(this.nz, this.ny);
                objectArray = ((Data)shortData).getReferencePixels();
                try {
                    int n40 = n;
                    int n41 = 0;
                    int n42 = 0;
                    while (n42 < this.ny) {
                        int n43 = 0;
                        while (n43 < this.nz) {
                            ((short[])objectArray[0])[n41++] = ((short[])this.stack[n43])[n40];
                            ++n43;
                        }
                        n40 += this.nx;
                        ++n42;
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    this.MessageOutofBounds(n, 0, 0, this.nx, this.ny, this.nz);
                    return;
                }
                ((Data)shortData).getNeighborhood(n3, n2, dArray);
                return;
            }
        }
        throw new ArrayStoreException("Unexpected direction" + this.dir);
    }

    public void getNeighborhood(int n, int n2, int n3, double[] dArray) {
        ShortData shortData = null;
        short[] sArray = null;
        switch (this.dir) {
            case 0: {
                if (this.fast) {
                    int n4 = dArray.length;
                    int n5 = (n4 - 1) / 2;
                    int n6 = n2 * this.nx + n - n5;
                    int n7 = 0;
                    while (n7 < n4) {
                        dArray[n7] = ((short[])this.stack[n3])[n6++] & 0xFFFF;
                        ++n7;
                    }
                    return;
                }
                shortData = new ShortData(this.nx, this.ny);
                sArray = (short[])((Data)shortData).getReferencePixels()[0];
                try {
                    int n8 = 0;
                    int n9 = this.nx * this.ny;
                    int n10 = 0;
                    while (n10 < n9) {
                        sArray[n8] = ((short[])this.stack[n3])[n8];
                        ++n8;
                        ++n10;
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    this.MessageOutofBounds(0, 0, n3, this.nx, this.ny, this.nz);
                    return;
                }
                catch (NullPointerException nullPointerException) {
                    this.MessageOutofBounds(0, 0, n3, this.nx, this.ny, this.nz);
                    return;
                }
                ((Data)shortData).setDirection(0);
                ((Data)shortData).getNeighborhood(n, n2, dArray);
                return;
            }
            case 1: {
                if (this.fast) {
                    int n11 = dArray.length;
                    int n12 = (n11 - 1) / 2;
                    int n13 = n2 - n12 * this.nx + n;
                    int n14 = 0;
                    while (n14 < n11) {
                        dArray[n14] = ((short[])this.stack[n3])[n13++] & 0xFFFF;
                        n13 += this.nx;
                        ++n14;
                    }
                    return;
                }
                shortData = new ShortData(this.nx, this.ny);
                sArray = (short[])((Data)shortData).getReferencePixels()[0];
                try {
                    int n15 = 0;
                    int n16 = this.nx * this.ny;
                    int n17 = 0;
                    while (n17 < n16) {
                        sArray[n15] = ((short[])this.stack[n3])[n15];
                        ++n15;
                        ++n17;
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    this.MessageOutofBounds(0, 0, n3, this.nx, this.ny, this.nz);
                    return;
                }
                catch (NullPointerException nullPointerException) {
                    this.MessageOutofBounds(0, 0, n3, this.nx, this.ny, this.nz);
                    return;
                }
                ((Data)shortData).setDirection(1);
                ((Data)shortData).getNeighborhood(n, n2, dArray);
                return;
            }
            case 2: {
                if (this.fast) {
                    int n18 = dArray.length;
                    int n19 = (n18 - 1) / 2;
                    int n20 = n3 - n19;
                    int n21 = n2 * this.nx + n;
                    int n22 = 0;
                    while (n22 < n18) {
                        dArray[n22] = ((short[])this.stack[n20++])[n21] & 0xFFFF;
                        ++n22;
                    }
                    return;
                }
                shortData = new ShortData(this.nz, this.ny);
                sArray = (short[])((Data)shortData).getReferencePixels()[0];
                try {
                    int n23 = 0;
                    int n24 = n;
                    int n25 = 0;
                    while (n25 < this.ny) {
                        int n26 = 0;
                        while (n26 < this.nz) {
                            sArray[n23++] = ((short[])this.stack[n26])[n24];
                            ++n26;
                        }
                        n24 += this.nx;
                        ++n25;
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    this.MessageOutofBounds(n, 0, 0, this.nx, this.ny, this.nz);
                    return;
                }
                ((Data)shortData).setDirection(0);
                ((Data)shortData).getNeighborhood(n3, n2, dArray);
                return;
            }
        }
        throw new ArrayStoreException("Unexpected direction" + this.dir);
    }

    /*
     * Exception decompiling
     */
    public void getNeighborhood(int var1_1, int var2_2, double[][] var3_3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[CATCHBLOCK]], but top level block is 3[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void getNeighborhood(int var1_1, int var2_2, double[] var3_3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [19[CATCHBLOCK]], but top level block is 9[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void getNeighborhood(int var1_1, double[] var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[CATCHBLOCK]], but top level block is 3[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void get(Coordinate coordinate, Data data) {
        if (!data.isExtended()) {
            this.dir = this.dir;
            switch (data.getDimension()) {
                case 1: {
                    switch (this.dimension) {
                        case 3: {
                            this.get(coordinate.x, coordinate.y, coordinate.z, data, this.dir);
                            return;
                        }
                        case 2: {
                            this.get(coordinate.x, coordinate.y, data, this.dir);
                            return;
                        }
                        case 1: {
                            this.get(coordinate.x, data);
                            return;
                        }
                    }
                }
                case 2: {
                    switch (this.dimension) {
                        case 3: {
                            this.get(coordinate.x, coordinate.y, coordinate.z, data, this.dir);
                            return;
                        }
                        case 2: {
                            this.get(coordinate.x, coordinate.y, data);
                            return;
                        }
                        case 1: {
                            this.get(coordinate.x, 0, data);
                            return;
                        }
                    }
                }
                case 3: {
                    switch (this.dimension) {
                        case 3: {
                            this.get(coordinate.x, coordinate.y, coordinate.z, data);
                            return;
                        }
                        case 2: {
                            this.get(coordinate.x, coordinate.y, coordinate.z, data);
                            return;
                        }
                        case 1: {
                            this.get(coordinate.x, coordinate.y, coordinate.z, data);
                            return;
                        }
                        default: {
                            return;
                        }
                    }
                }
                default: {
                    return;
                }
            }
        }
        throw new IndexOutOfBoundsException("Extended image");
    }

    public void put(Coordinate coordinate, Data data) {
        if (!data.isExtended()) {
            this.dir = this.dir;
            switch (data.getDimension()) {
                case 1: {
                    switch (this.dimension) {
                        case 3: {
                            this.put(coordinate.x, coordinate.y, coordinate.z, data, this.dir);
                            return;
                        }
                        case 2: {
                            this.put(coordinate.x, coordinate.y, data, this.dir);
                            return;
                        }
                        case 1: {
                            this.put(coordinate.x, data);
                            return;
                        }
                    }
                }
                case 2: {
                    switch (this.dimension) {
                        case 3: {
                            this.put(coordinate.x, coordinate.y, coordinate.z, data, this.dir);
                            return;
                        }
                        case 2: {
                            this.put(coordinate.x, coordinate.y, data);
                            return;
                        }
                        case 1: {
                            this.put(coordinate.x, 0, data);
                            return;
                        }
                    }
                }
                case 3: {
                    switch (this.dimension) {
                        case 3: {
                            this.put(coordinate.x, coordinate.y, coordinate.z, data);
                            return;
                        }
                        case 2: {
                            this.put(coordinate.x, coordinate.y, coordinate.z, data);
                            return;
                        }
                        case 1: {
                            this.put(coordinate.x, coordinate.y, coordinate.z, data);
                            return;
                        }
                        default: {
                            return;
                        }
                    }
                }
                default: {
                    return;
                }
            }
        }
        throw new IndexOutOfBoundsException("Extended image");
    }

    public void get(int n, int n2, int n3, Data data) {
        int n4 = data.getXSize();
        int n5 = data.getYSize();
        int n6 = data.getZSize();
        double[][][] dArray = new double[n4][n5][n6];
        this.get(n, n2, n3, dArray);
        data.put(0, 0, 0, dArray);
    }

    public void get(int n, int n2, int n3, Data data, int n4) {
        this.dir = n4;
        if (data.getDimension() == 3 && n4 == 6) {
            int n5 = data.getXSize();
            int n6 = data.getYSize();
            int n7 = data.getZSize();
            double[][][] dArray = new double[n5][n6][n7];
            this.get(n, n2, n3, dArray);
            data.put(0, 0, 0, dArray);
        } else if (data.getDimension() == 1) {
            int n8 = data.getXSize();
            double[] dArray = new double[n8];
            this.get(n, n2, n3, dArray);
            data.put(0, dArray);
        } else if (data.getDimension() == 2) {
            int n9 = data.getXSize();
            int n10 = data.getYSize();
            double[][] dArray = new double[n9][n10];
            this.dir = n4;
            this.get(n, n2, n3, dArray);
            data.put(0, 0, dArray);
        }
    }

    public void get(int n, int n2, Data data, int n3) {
        this.dir = n3;
        if (data.getDimension() == 2 && n3 == 3) {
            int n4 = data.getXSize();
            int n5 = data.getYSize();
            double[][] dArray = new double[n4][n5];
            this.get(n, n2, dArray);
            data.put(0, 0, dArray);
        } else if (data.getDimension() == 1) {
            int n6 = data.getXSize();
            double[] dArray = new double[n6];
            this.get(n, n2, dArray);
            data.put(0, dArray);
        } else {
            throw new IndexOutOfBoundsException("Bad dimension");
        }
    }

    public void get(int n, int n2, Data data) {
        int n3 = data.getXSize();
        int n4 = data.getYSize();
        double[][] dArray = new double[n3][n4];
        this.get(n, n2, dArray);
        data.put(0, 0, dArray);
    }

    public void get(int n, Data data) {
        int n2 = data.getXSize();
        double[] dArray = new double[n2];
        this.get(n, dArray);
        data.put(0, dArray);
    }

    public void put(int n, int n2, int n3, Data data) {
        if (data.isExtended()) {
            throw new IndexOutOfBoundsException("Extended input image");
        }
        int n4 = data.getWidth();
        int n5 = data.getHeight();
        int n6 = data.getZSize();
        double[][][] dArray = new double[n4][n5][n6];
        data.get(0, 0, 0, dArray);
        this.put(n, n2, n3, dArray);
    }

    public void put(int n, int n2, int n3, Data data, int n4) {
        this.dir = n4;
        if (!data.isExtended()) {
            if (data.getDimension() == 3 && n4 == 6) {
                int n5 = data.getWidth();
                int n6 = data.getHeight();
                int n7 = data.getZSize();
                double[][][] dArray = new double[n5][n6][n7];
                data.get(0, 0, 0, dArray);
                this.put(n, n2, n3, dArray);
            } else if (data.getDimension() == 2) {
                int n8 = data.getWidth();
                int n9 = data.getHeight();
                double[][] dArray = new double[n8][n9];
                data.get(0, 0, dArray);
                this.put(n, n2, n3, dArray);
            } else if (data.getDimension() == 1) {
                int n10 = data.getWidth();
                double[] dArray = new double[n10];
                data.get(0, dArray);
                this.put(n, n2, n3, dArray);
            }
        } else {
            throw new IndexOutOfBoundsException("Extended input image");
        }
    }

    public void put(int n, int n2, Data data) {
        if (!data.isExtended()) {
            if (data.getDimension() != 2) {
                throw new IndexOutOfBoundsException("Bad dimension");
            }
        } else {
            throw new IndexOutOfBoundsException("Extended input image");
        }
        int n3 = data.getWidth();
        int n4 = data.getHeight();
        double[][] dArray = new double[n3][n4];
        data.get(0, 0, dArray);
        this.put(n, n2, dArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void put(int n, int n2, Data data, int n3) {
        this.dir = n3;
        if (data.isExtended()) throw new IndexOutOfBoundsException("Extended input image");
        if (data.getDimension() == 2 && n3 == 3) {
            int n4 = data.getWidth();
            int n5 = data.getHeight();
            double[][] dArray = new double[n4][n5];
            data.get(0, 0, dArray);
            this.put(n, n2, dArray);
            return;
        } else {
            if (data.getDimension() != 1) throw new IndexOutOfBoundsException("Bad dimension");
            int n6 = data.getWidth();
            double[] dArray = new double[n6];
            data.get(0, dArray);
            this.put(n, n2, dArray);
        }
    }

    public void put(int n, Data data) {
        if (!data.isExtended()) {
            if (data.getDimension() != 1) {
                throw new IndexOutOfBoundsException("Bad dimension");
            }
        } else {
            throw new IndexOutOfBoundsException("Extended input image");
        }
        int n2 = data.getWidth();
        double[] dArray = new double[n2];
        data.get(0, dArray);
        this.put(n, dArray);
    }

    public Data extendBorder(int n) {
        Data data = this.extendBorder(this.boundaryCondition, n, 0);
        return data;
    }

    public Data extendBorder(int n, int n2) {
        Data data = this.extendBorder(n, n2, 0);
        return data;
    }

    public Data extendBorder(int n, int n2, int n3) {
        int n4 = this.nx + 2 * n2;
        int n5 = this.ny + 2 * n2;
        int n6 = this.nz + 2 * n2;
        if (this.dimension == 1) {
            ShortDataExtended shortDataExtended = new ShortDataExtended(n4);
            double[] dArray = null;
            this.boundaryCondition = n;
            ((Data)shortDataExtended).setBoundaryCondition(n, n2);
            ((Data)shortDataExtended).enableFast();
            switch (n) {
                case 0: {
                    dArray = new double[n4];
                    this.getNeighborhood((this.nx - 1) / 2, dArray);
                    ((Data)shortDataExtended).put(-n2, dArray);
                    break;
                }
                case 1: {
                    dArray = new double[n4];
                    this.getNeighborhood((this.nx - 1) / 2, dArray);
                    ((Data)shortDataExtended).put(-n2, dArray);
                    break;
                }
                case 2: {
                    ((Data)shortDataExtended).setConstant(n3);
                    dArray = new double[this.nx];
                    this.get(0, dArray);
                    ((Data)shortDataExtended).put(0, dArray);
                    break;
                }
                default: {
                    throw new ArrayStoreException("Unexpected boundary condition");
                }
            }
            this.boundaryCondition = 0;
            ((Data)shortDataExtended).disableFast();
            return shortDataExtended;
        }
        if (this.dimension == 2) {
            ShortDataExtended shortDataExtended = new ShortDataExtended(n4, n5);
            double[][] dArray = null;
            this.boundaryCondition = n;
            ((Data)shortDataExtended).setBoundaryCondition(n, n2);
            ((Data)shortDataExtended).enableFast();
            switch (n) {
                case 0: {
                    dArray = new double[n4][n5];
                    this.getNeighborhood((this.nx - 1) / 2, (this.ny - 1) / 2, dArray);
                    ((Data)shortDataExtended).put(-n2, -n2, dArray);
                    break;
                }
                case 1: {
                    dArray = new double[n4][n5];
                    this.getNeighborhood((this.nx - 1) / 2, (this.ny - 1) / 2, dArray);
                    ((Data)shortDataExtended).put(-n2, -n2, dArray);
                    break;
                }
                case 2: {
                    ((Data)shortDataExtended).setConstant(n3);
                    dArray = new double[this.nx][this.ny];
                    this.get(0, 0, dArray);
                    ((Data)shortDataExtended).put(0, 0, dArray);
                    break;
                }
                default: {
                    throw new ArrayStoreException("Unexpected boundary condition");
                }
            }
            this.boundaryCondition = 0;
            ((Data)shortDataExtended).disableFast();
            return shortDataExtended;
        }
        if (this.dimension == 3) {
            ShortDataExtended shortDataExtended = new ShortDataExtended(n4, n5, n6);
            double[][][] dArray = null;
            this.boundaryCondition = n;
            ((Data)shortDataExtended).setBoundaryCondition(n, n2);
            ((Data)shortDataExtended).enableFast();
            switch (n) {
                case 0: {
                    dArray = new double[n4][n5][n6];
                    this.getNeighborhood((this.nx - 1) / 2, (this.ny - 1) / 2, (this.nz - 1) / 2, dArray);
                    ((Data)shortDataExtended).put(-n2, -n2, -n2, dArray);
                    break;
                }
                case 1: {
                    dArray = new double[n4][n5][n6];
                    this.getNeighborhood((this.nx - 1) / 2, (this.ny - 1) / 2, (this.nz - 1) / 2, dArray);
                    ((Data)shortDataExtended).put(-n2, -n2, -n2, dArray);
                    break;
                }
                case 2: {
                    ((Data)shortDataExtended).setConstant(n3);
                    dArray = new double[this.nx][this.ny][this.nz];
                    this.get(0, 0, 0, dArray);
                    ((Data)shortDataExtended).put(0, 0, 0, dArray);
                    break;
                }
                default: {
                    throw new ArrayStoreException("Unexpected boundary condition");
                }
            }
            this.boundaryCondition = 0;
            ((Data)shortDataExtended).disableFast();
            return shortDataExtended;
        }
        throw new ArrayStoreException("Bad dimension");
    }

    public void updateBorder() {
        throw new ArrayStoreException("Operation denied");
    }

    public Data removeBorder() {
        throw new ArrayStoreException("Operation denied");
    }

    public Object[] getReferencePixels() {
        return this.stack;
    }

    public ImageProcessor getImageProcessor(int n) {
        return this.istack.getProcessor(n + 1);
    }

    public ImageStack getImageStack() {
        return this.istack;
    }

    public boolean isExtended() {
        return false;
    }

    public int getType() {
        return 1;
    }

    public int getWidth() {
        return this.nx;
    }

    public int getHeight() {
        return this.ny;
    }

    public int getXSize() {
        return this.nx;
    }

    public int getYSize() {
        return this.ny;
    }

    public int getZSize() {
        return this.nz;
    }

    public int getTotalSize() {
        return this.size;
    }

    public int[] getSize() {
        int[] nArray = null;
        if (this.dimension == 1) {
            nArray = new int[]{this.nx};
        } else if (this.dimension == 2) {
            nArray = new int[]{this.nx, this.ny};
        } else if (this.dimension == 3) {
            nArray = new int[]{this.nx, this.ny, this.nz};
        }
        return nArray;
    }

    public int getDimension() {
        return this.dimension;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void copy(Data data) {
        if (!(data instanceof ShortData)) throw new IndexOutOfBoundsException("Input not a ShortData");
        if (this.nx != data.getWidth() || this.ny != data.getHeight() || this.nz != data.getZSize()) throw new IndexOutOfBoundsException("Bad dimensions");
        short[] sArray = null;
        short[] sArray2 = null;
        int n = this.nx * this.ny;
        int n2 = 0;
        while (n2 < this.nz) {
            sArray = (short[])data.getReferencePixels()[n2];
            sArray2 = (short[])this.stack[n2];
            System.arraycopy(sArray, 0, sArray2, 0, n);
            ++n2;
        }
    }

    public Data duplicate() {
        ShortData shortData = new ShortData(this.nx, this.ny, this.nz);
        ((Data)shortData).setBoundaryCondition(this.boundaryCondition, 0);
        short[] sArray = null;
        short[] sArray2 = null;
        int n = this.nx * this.ny;
        int n2 = 0;
        while (n2 < this.nz) {
            sArray2 = (short[])((Data)shortData).getReferencePixels()[n2];
            sArray = (short[])this.stack[n2];
            System.arraycopy(sArray, 0, sArray2, 0, n);
            ++n2;
        }
        return shortData;
    }

    public Data duplicate(int n) {
        Data data = null;
        switch (n) {
            case 2: {
                data = new FloatData(this.nx, this.ny, this.nz);
                data.setBoundaryCondition(this.boundaryCondition, 0);
                short[] sArray = null;
                float[] fArray = null;
                int n2 = this.nx * this.ny;
                int n3 = 0;
                while (n3 < this.nz) {
                    fArray = (float[])data.getReferencePixels()[n3];
                    sArray = (short[])this.stack[n3];
                    int n4 = 0;
                    while (n4 < n2) {
                        fArray[n4] = sArray[n4] & 0xFFFF;
                        ++n4;
                    }
                    ++n3;
                }
                break;
            }
            case 6: {
                data = new DoubleData(this.nx, this.ny, this.nz);
                data.setBoundaryCondition(this.boundaryCondition, 0);
                short[] sArray = null;
                double[] dArray = null;
                int n5 = this.nx * this.ny;
                int n6 = 0;
                while (n6 < this.nz) {
                    dArray = (double[])data.getReferencePixels()[n6];
                    sArray = (short[])this.stack[n6];
                    int n7 = 0;
                    while (n7 < n5) {
                        dArray[n7] = sArray[n7] & 0xFFFF;
                        ++n7;
                    }
                    ++n6;
                }
                break;
            }
            case 0: {
                data = new ByteData(this.nx, this.ny, this.nz);
                data.setBoundaryCondition(this.boundaryCondition, 0);
                short[] sArray = null;
                byte[] byArray = null;
                int n8 = this.nx * this.ny;
                int n9 = 0;
                while (n9 < this.nz) {
                    byArray = (byte[])data.getReferencePixels()[n9];
                    sArray = (short[])this.stack[n9];
                    int n10 = 0;
                    while (n10 < n8) {
                        byArray[n10] = (byte)ShortData.round(sArray[n10] & 0xFFFF);
                        ++n10;
                    }
                    ++n9;
                }
                break;
            }
            case 1: {
                data = new ShortData(this.nx, this.ny, this.nz);
                data.setBoundaryCondition(this.boundaryCondition, 0);
                short[] sArray = null;
                short[] sArray2 = null;
                int n11 = this.nx * this.ny;
                int n12 = 0;
                while (n12 < this.nz) {
                    sArray2 = (short[])data.getReferencePixels()[n12];
                    sArray = (short[])this.stack[n12];
                    System.arraycopy(sArray, 0, sArray2, 0, n11);
                    ++n12;
                }
                break;
            }
        }
        return data;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setPixels(Object object) {
        if (object instanceof short[]) {
            int n = ((short[])object).length;
            if (this.dimension != 1 || this.nx != n) throw new IndexOutOfBoundsException("Invalid nx = " + n + " size");
            int n2 = 0;
            while (n2 < this.nx) {
                ((short[])this.stack[0])[n2] = ((short[])object)[n2];
                ++n2;
            }
            return;
        } else if (object instanceof short[][]) {
            int n = ((short[][])object).length;
            int n3 = ((short[][])object)[0].length;
            if (this.dimension != 2 || this.nx != n || this.ny != n3) throw new IllegalArgumentException("");
            boolean bl = false;
            int n4 = 0;
            while (n4 < n3) {
                int n5 = 0;
                while (n5 < n) {
                    ((short[])this.stack[0])[n5 + this.nx * n4] = ((short[][])object)[n5][n4];
                    ++n5;
                }
                ++n4;
            }
            return;
        } else {
            if (!(object instanceof short[][][])) throw new ArrayStoreException("Unexpected object");
            int n = ((short[][][])object).length;
            int n6 = ((short[][][])object)[0].length;
            int n7 = ((short[][][])object)[0][0].length;
            if (this.dimension != 3 || this.nx != n || this.ny != n6 || this.nz != n7) throw new IllegalArgumentException("");
            int n8 = 0;
            while (n8 < n7) {
                int n9 = 0;
                while (n9 < n6) {
                    int n10 = 0;
                    while (n10 < n) {
                        ((short[])this.stack[n8])[n10 + this.nx * n9] = ((short[][][])object)[n10][n9][n8];
                        ++n10;
                    }
                    ++n9;
                }
                ++n8;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void getPixels(Object object) {
        if (object instanceof short[]) {
            if (this.dimension != 1 || this.nx != ((short[])object).length) throw new IllegalArgumentException("");
            int n = 0;
            while (n < this.nx) {
                ((short[])object)[n] = ((short[])this.stack[0])[n];
                ++n;
            }
            return;
        } else if (object instanceof short[][]) {
            int n = ((short[][])object).length;
            int n2 = ((short[][])object)[0].length;
            if (this.dimension != 2 || this.nx != n || this.ny != n2) throw new IllegalArgumentException("");
            int n3 = 0;
            while (n3 < n2) {
                int n4 = 0;
                while (n4 < n) {
                    ((short[][])object)[n4][n3] = ((short[])this.stack[0])[n4 + this.nx * n3];
                    ++n4;
                }
                ++n3;
            }
            return;
        } else {
            if (!(object instanceof short[][][])) return;
            int n = ((short[][][])object).length;
            int n5 = ((short[][][])object)[0].length;
            int n6 = ((short[][][])object)[0][0].length;
            if (this.dimension != 3 || this.nx != n || this.ny != n5 || this.nz != n6) throw new IllegalArgumentException("");
            int n7 = 0;
            while (n7 < n6) {
                int n8 = 0;
                while (n8 < n5) {
                    int n9 = 0;
                    while (n9 < n) {
                        ((short[][][])object)[n9][n8][n7] = ((short[])this.stack[n7])[n9 + this.nx * n8];
                        ++n9;
                    }
                    ++n8;
                }
                ++n7;
            }
        }
    }

    public void setBoundaryCondition(int n, int n2) {
        this.boundaryCondition = n;
    }

    public void setBoundaryCondition(int n) {
    }

    public void setConstant(double d) {
        int n = 0;
        while (n < this.nz) {
            int n2 = 0;
            while (n2 < this.ny) {
                int n3 = 0;
                while (n3 < this.nx) {
                    ((short[])this.stack[n])[n3 + this.nx * n2] = (short)ShortData.round(d);
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
    }

    public void normalizeContrast() {
        double d;
        double d2;
        double d3 = 0.0;
        double d4 = 255.0;
        double d5 = Statistic.getMinimum(this);
        if (d5 - (d2 = Statistic.getMaximum(this)) == 0.0) {
            d = 1.0;
            d5 = (d4 - d3) / 2.0;
        } else {
            d = (d4 - d3) / (d2 - d5);
        }
        int n = 0;
        int n2 = 0;
        while (n2 < this.ny) {
            int n3 = 0;
            while (n3 < this.nx) {
                n = n3 + this.nx * n2;
                int n4 = 0;
                while (n4 < this.nz) {
                    ((short[])this.stack[n4])[n] = (short)ShortData.round(d * ((double)(((short[])this.stack[n4])[n] & 0xFFFF) - d5) + d3);
                    ++n4;
                }
                ++n3;
            }
            ++n2;
        }
    }

    public void setDirection(int n) {
        this.dir = n;
    }

    public int getDirection() {
        return this.dir;
    }

    public ImagePlus show(String string) {
        ImageProcessor imageProcessor = this.istack.getProcessor(1);
        imageProcessor.resetMinAndMax();
        ImagePlus imagePlus = null;
        imagePlus = this.istack.getSize() == 1 ? new ImagePlus(string, imageProcessor) : new ImagePlus(string, this.istack);
        imagePlus.show();
        return imagePlus;
    }

    public ImagePlus show(String string, Point point) {
        ImageProcessor imageProcessor = this.istack.getProcessor(1);
        imageProcessor.resetMinAndMax();
        ImagePlus imagePlus = null;
        imagePlus = this.istack.getSize() == 1 ? new ImagePlus(string, imageProcessor) : new ImagePlus(string, this.istack);
        imagePlus.show();
        ImageWindow imageWindow = imagePlus.getWindow();
        imageWindow.setLocation(point.x, point.y);
        return imagePlus;
    }

    public void updateDisplay(ImagePlus imagePlus) {
        imagePlus.updateAndDraw();
    }

    public void disableFast() {
        this.fast = false;
    }

    public void enableFast() {
        this.fast = true;
    }

    private static int floor(double d) {
        if (d >= 0.0) {
            return (int)d;
        }
        int n = (int)d - 1;
        return (int)(d - (double)n) + n;
    }

    private static int ceil(double d) {
        return -ShortData.floor(-d);
    }

    private static int round(double d) {
        return ShortData.floor(d + 0.5);
    }

    public void add(double d) {
        short s = (short)Math.round(d);
        double d2 = this.nx * this.ny;
        int n = 0;
        while (n < this.nz) {
            int n2 = 0;
            while ((double)n2 < d2) {
                short[] sArray = (short[])this.stack[n];
                int n3 = n2++;
                sArray[n3] = (short)(sArray[n3] + s);
            }
            ++n;
        }
    }

    public void subtract(double d) {
        short s = (short)Math.round(d);
        double d2 = this.nx * this.ny;
        int n = 0;
        while (n < this.nz) {
            int n2 = 0;
            while ((double)n2 < d2) {
                short[] sArray = (short[])this.stack[n];
                int n3 = n2++;
                sArray[n3] = (short)(sArray[n3] - s);
            }
            ++n;
        }
    }

    public void multiply(double d) {
        short s = (short)Math.round(d);
        double d2 = this.nx * this.ny;
        int n = 0;
        while (n < this.nz) {
            int n2 = 0;
            while ((double)n2 < d2) {
                short[] sArray = (short[])this.stack[n];
                int n3 = n2++;
                sArray[n3] = (short)(sArray[n3] * s);
            }
            ++n;
        }
    }

    public void divide(double d) {
        short s = (short)Math.round(d);
        double d2 = this.nx * this.ny;
        int n = 0;
        while (n < this.nz) {
            int n2 = 0;
            while ((double)n2 < d2) {
                short[] sArray = (short[])this.stack[n];
                int n3 = n2++;
                sArray[n3] = (short)(sArray[n3] / s);
            }
            ++n;
        }
    }

    public void pow(double d) {
        double d2 = this.nx * this.ny;
        int n = 0;
        while (n < this.nz) {
            int n2 = 0;
            while ((double)n2 < d2) {
                ((short[])this.stack[n])[n2] = (short)ShortData.round(Math.pow(((short[])this.stack[n])[n2], d));
                ++n2;
            }
            ++n;
        }
    }

    public void sqrt() {
        double d = this.nx * this.ny;
        int n = 0;
        while (n < this.nz) {
            int n2 = 0;
            while ((double)n2 < d) {
                ((short[])this.stack[n])[n2] = (short)ShortData.round(Math.sqrt(((short[])this.stack[n])[n2]));
                ++n2;
            }
            ++n;
        }
    }

    public void abs() {
        double d = this.nx * this.ny;
        int n = 0;
        while (n < this.nz) {
            int n2 = 0;
            while ((double)n2 < d) {
                ((short[])this.stack[n])[n2] = (short)ShortData.round(Math.abs(((short[])this.stack[n])[n2]));
                ++n2;
            }
            ++n;
        }
    }

    public void add(Data data) {
        int n = data.getType();
        int n2 = data.getDimension();
        if (!data.isExtended() && n == 1 && n2 == this.dimension) {
            if (data.getWidth() != this.nx) {
                throw new ArrayStoreException("Unexpected operand image size");
            }
            if (data.getHeight() != this.ny) {
                throw new ArrayStoreException("Unexpected operand image size");
            }
            if (data.getZSize() != this.nz) {
                throw new ArrayStoreException("Unexpected operand image size");
            }
            Object[] objectArray = data.getReferencePixels();
            double d = this.nx * this.ny;
            int n3 = 0;
            while (n3 < this.nz) {
                int n4 = 0;
                while ((double)n4 < d) {
                    short[] sArray = (short[])this.stack[n3];
                    int n5 = n4;
                    sArray[n5] = (short)(sArray[n5] + ((short[])objectArray[n3])[n4]);
                    ++n4;
                }
                ++n3;
            }
        }
    }

    public void subtract(Data data) {
        int n = data.getType();
        int n2 = data.getDimension();
        if (!data.isExtended() && n == 1 && n2 == this.dimension) {
            if (data.getWidth() != this.nx) {
                throw new ArrayStoreException("Unexpected operand image size");
            }
            if (data.getHeight() != this.ny) {
                throw new ArrayStoreException("Unexpected operand image size");
            }
            if (data.getZSize() != this.nz) {
                throw new ArrayStoreException("Unexpected operand image size");
            }
            Object[] objectArray = data.getReferencePixels();
            double d = this.nx * this.ny;
            int n3 = 0;
            while (n3 < this.nz) {
                int n4 = 0;
                while ((double)n4 < d) {
                    short[] sArray = (short[])this.stack[n3];
                    int n5 = n4;
                    sArray[n5] = (short)(sArray[n5] - ((short[])objectArray[n3])[n4]);
                    ++n4;
                }
                ++n3;
            }
        }
    }

    public void multiply(Data data) {
        int n = data.getType();
        int n2 = data.getDimension();
        if (!data.isExtended() && n == 1 && n2 == this.dimension) {
            if (data.getWidth() != this.nx) {
                throw new ArrayStoreException("Unexpected operand image size");
            }
            if (data.getHeight() != this.ny) {
                throw new ArrayStoreException("Unexpected operand image size");
            }
            if (data.getZSize() != this.nz) {
                throw new ArrayStoreException("Unexpected operand image size");
            }
            Object[] objectArray = data.getReferencePixels();
            double d = this.nx * this.ny;
            int n3 = 0;
            while (n3 < this.nz) {
                int n4 = 0;
                while ((double)n4 < d) {
                    short[] sArray = (short[])this.stack[n3];
                    int n5 = n4;
                    sArray[n5] = (short)(sArray[n5] * ((short[])objectArray[n3])[n4]);
                    ++n4;
                }
                ++n3;
            }
        }
    }

    public void divide(Data data) {
        int n = data.getType();
        int n2 = data.getDimension();
        if (!data.isExtended() && n == 1 && n2 == this.dimension) {
            if (data.getWidth() != this.nx) {
                throw new ArrayStoreException("Unexpected operand image size");
            }
            if (data.getHeight() != this.ny) {
                throw new ArrayStoreException("Unexpected operand image size");
            }
            if (data.getZSize() != this.nz) {
                throw new ArrayStoreException("Unexpected operand image size");
            }
            Object[] objectArray = data.getReferencePixels();
            double d = this.nx * this.ny;
            int n3 = 0;
            while (n3 < this.nz) {
                int n4 = 0;
                while ((double)n4 < d) {
                    short[] sArray = (short[])this.stack[n3];
                    int n5 = n4;
                    sArray[n5] = (short)(sArray[n5] / ((short[])objectArray[n3])[n4]);
                    ++n4;
                }
                ++n3;
            }
        }
    }

    public void MessageOutofBounds(int n, int n2, int n3, int n4, int n5, int n6) {
        if (n3 < 0) {
            throw new ArrayStoreException("z = " + n3 + " out of bounds z<0");
        }
        if (n3 >= n6) {
            throw new ArrayStoreException("z = " + n3 + " out of bounds z >= nz");
        }
        if (n2 < 0) {
            throw new ArrayStoreException("y = " + n2 + " out of bounds y<0");
        }
        if (n2 >= n5) {
            throw new ArrayStoreException("y = " + n2 + " out of bounds y >= ny");
        }
        if (n < 0) {
            throw new ArrayStoreException("x = " + n + " out of bounds x<0");
        }
        if (n >= n4) {
            throw new ArrayStoreException("x = " + n + " out of bounds x >= nx");
        }
    }
}

