/*
 * Decompiled with CFR 0.152.
 */
package data;

import data.ByteDataExtended;
import data.Coordinate;
import data.Data;
import data.DoubleData;
import data.DoubleDataExtended;
import data.FloatData;
import data.ShortDataExtended;
import data.Statistic;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.ImageWindow;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.awt.Image;
import java.awt.Point;

class FloatDataExtended
extends Data {
    public static final int NOTDEFINED = -1;
    public static final int CONNECTIVITY_4 = 0;
    public static final int CONNECTIVITY_8 = 1;
    private int nx = 0;
    private int ny = 0;
    private int nz = 0;
    private int size = 0;
    private int type;
    private int boundaryCondition;
    private int boundaryConstant;
    private int border;
    private int dimension;
    private int dir;
    private ImageStack istack = null;
    private Object[] stack = null;
    private boolean fast = false;

    public FloatDataExtended(int n) {
        if (n < 1) {
            throw new IndexOutOfBoundsException("The size of the image is incorrect");
        }
        this.dimension = 1;
        this.nx = n;
        this.ny = 1;
        this.nz = 1;
        this.size = n;
        this.border = 0;
        this.boundaryCondition = 0;
        this.istack = new ImageStack(n, this.ny);
        FloatProcessor floatProcessor = new FloatProcessor(n, this.ny);
        this.istack.addSlice("", (ImageProcessor)floatProcessor);
        this.stack = this.istack.getImageArray();
    }

    public FloatDataExtended(int n, int n2) {
        if (n < 1 || n2 < 1) {
            throw new IndexOutOfBoundsException("The size of the image is incorrect");
        }
        this.dimension = n2 == 1 ? 1 : 2;
        this.nx = n;
        this.ny = n2;
        this.nz = 1;
        this.size = n * n2;
        this.border = 0;
        this.boundaryCondition = 0;
        this.istack = new ImageStack(n, n2);
        FloatProcessor floatProcessor = new FloatProcessor(n, n2);
        this.istack.addSlice("", (ImageProcessor)floatProcessor);
        this.stack = this.istack.getImageArray();
    }

    public FloatDataExtended(int n, int n2, int n3) {
        if (n < 1 || n2 < 1 || n3 < 1) {
            throw new IndexOutOfBoundsException("The size of the image is incorrect");
        }
        this.dimension = n2 == 1 && n3 == 1 ? 1 : (n3 == 1 ? 2 : 3);
        this.nx = n;
        this.ny = n2;
        this.nz = n3;
        this.size = n * n2 * n3;
        this.border = 0;
        this.boundaryCondition = 0;
        this.istack = new ImageStack(n, n2);
        int n4 = 0;
        while (n4 < n3) {
            FloatProcessor floatProcessor = new FloatProcessor(n, n2);
            this.istack.addSlice("", (ImageProcessor)floatProcessor);
            ++n4;
        }
        this.stack = this.istack.getImageArray();
    }

    public FloatDataExtended(ImageProcessor imageProcessor) {
        this.dimension = this.ny == 1 ? 1 : 2;
        this.nx = imageProcessor.getWidth();
        this.ny = imageProcessor.getHeight();
        this.nz = 1;
        this.size = this.nx * this.ny * this.nz;
        this.border = 0;
        this.dimension = this.ny == 1 ? 1 : 2;
        this.boundaryCondition = 0;
        this.istack = new ImageStack(this.nx, this.ny);
        this.istack.addSlice("", imageProcessor);
        this.stack = this.istack.getImageArray();
    }

    public FloatDataExtended(ImagePlus imagePlus) {
        ImageProcessor imageProcessor = imagePlus.getProcessor();
        this.nx = imagePlus.getWidth();
        this.ny = imagePlus.getHeight();
        this.nz = imagePlus.getStackSize();
        this.size = this.nx * this.ny * this.nz;
        if (this.ny == 1 && this.nz == 1) {
            this.dimension = 1;
            this.istack = new ImageStack(this.nx, this.ny);
            this.istack.addSlice("", imageProcessor);
            this.stack = this.istack.getImageArray();
        } else if (this.nz == 1) {
            this.dimension = 2;
            this.istack = new ImageStack(this.nx, this.ny);
            this.istack.addSlice("", imageProcessor);
            this.stack = this.istack.getImageArray();
        } else {
            this.dimension = 3;
            this.istack = imagePlus.getStack();
            this.stack = this.istack.getImageArray();
        }
        this.border = 0;
        this.boundaryCondition = 0;
    }

    public FloatDataExtended(ImagePlus imagePlus, int n) {
        throw new IndexOutOfBoundsException("operation denied");
    }

    public FloatDataExtended(ImageStack imageStack) {
        this.istack = imageStack;
        this.dimension = 3;
        this.nx = imageStack.getWidth();
        this.ny = imageStack.getHeight();
        this.nz = imageStack.getSize();
        this.size = this.nx * this.ny * this.nz;
        this.dimension = this.ny == 1 && this.nz == 1 ? 1 : (this.nz == 1 ? 2 : 3);
        this.border = 0;
        this.boundaryCondition = 0;
        this.stack = imageStack.getImageArray();
    }

    public FloatDataExtended(Image image) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void copy(Data data) {
        if (!(data instanceof FloatDataExtended)) throw new IndexOutOfBoundsException("Input not a FloatDataExtended");
        if (this.nx != data.getWidth() || this.ny != data.getHeight() || this.nz != data.getZSize()) throw new IndexOutOfBoundsException("Bad dimensions");
        float[] fArray = null;
        float[] fArray2 = null;
        int n = this.nx * this.ny;
        int n2 = 0;
        while (n2 < this.nz) {
            fArray = (float[])data.getReferencePixels()[n2];
            fArray2 = (float[])this.stack[n2];
            System.arraycopy(fArray, 0, fArray2, 0, n);
            ++n2;
        }
    }

    public Data duplicate() {
        FloatDataExtended floatDataExtended = new FloatDataExtended(this.nx, this.ny, this.nz);
        ((Data)floatDataExtended).setBoundaryCondition(this.boundaryCondition, 0);
        float[] fArray = null;
        float[] fArray2 = null;
        int n = this.nx * this.ny;
        int n2 = 0;
        while (n2 < this.nz) {
            fArray2 = (float[])((Data)floatDataExtended).getReferencePixels()[n2];
            fArray = (float[])this.stack[n2];
            System.arraycopy(fArray, 0, fArray2, 0, n);
            ++n2;
        }
        return floatDataExtended;
    }

    public Data duplicate(int n) {
        Data data = null;
        switch (n) {
            case 2: {
                data = new FloatDataExtended(this.nx, this.ny, this.nz);
                data.setBoundaryCondition(this.boundaryCondition, 0);
                float[] fArray = null;
                float[] fArray2 = null;
                int n2 = this.nx * this.ny;
                int n3 = 0;
                while (n3 < this.nz) {
                    fArray2 = (float[])data.getReferencePixels()[n3];
                    fArray = (float[])this.stack[n3];
                    System.arraycopy(fArray, 0, fArray2, 0, n2);
                    ++n3;
                }
                break;
            }
            case 6: {
                data = new DoubleDataExtended(this.nx, this.ny, this.nz);
                data.setBoundaryCondition(this.boundaryCondition, 0);
                float[] fArray = null;
                double[] dArray = null;
                int n4 = this.nx * this.ny;
                int n5 = 0;
                while (n5 < this.nz) {
                    dArray = (double[])data.getReferencePixels()[n5];
                    fArray = (float[])this.stack[n5];
                    int n6 = 0;
                    while (n6 < n4) {
                        dArray[n6] = fArray[n6];
                        ++n6;
                    }
                    ++n5;
                }
                break;
            }
            case 0: {
                data = new ByteDataExtended(this.nx, this.ny, this.nz);
                data.setBoundaryCondition(this.boundaryCondition, 0);
                float[] fArray = null;
                byte[] byArray = null;
                int n7 = this.nx * this.ny;
                int n8 = 0;
                while (n8 < this.nz) {
                    byArray = (byte[])data.getReferencePixels()[n8];
                    fArray = (float[])this.stack[n8];
                    int n9 = 0;
                    while (n9 < n7) {
                        byArray[n9] = (byte)FloatDataExtended.round(fArray[n9]);
                        ++n9;
                    }
                    ++n8;
                }
                break;
            }
            case 1: {
                data = new ShortDataExtended(this.nx, this.ny, this.nz);
                data.setBoundaryCondition(this.boundaryCondition, 0);
                float[] fArray = null;
                short[] sArray = null;
                int n10 = this.nx * this.ny;
                int n11 = 0;
                while (n11 < this.nz) {
                    sArray = (short[])data.getReferencePixels()[n11];
                    fArray = (float[])this.stack[n11];
                    int n12 = 0;
                    while (n12 < n10) {
                        sArray[n12] = (short)FloatDataExtended.round(fArray[n12]);
                        ++n12;
                    }
                    ++n11;
                }
                break;
            }
        }
        return data;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setPixels(Object object) {
        if (object instanceof float[]) {
            if (this.dimension != 1 || this.nx != ((float[])object).length) throw new IllegalArgumentException("");
            int n = 0;
            while (n < this.nx) {
                ((float[])this.stack[0])[n] = ((float[])object)[n];
                ++n;
            }
            return;
        } else if (object instanceof float[][]) {
            int n = ((float[][])object).length;
            int n2 = ((float[][])object)[0].length;
            if (this.dimension != 2 || this.nx != n || this.ny != n2) throw new IllegalArgumentException("");
            int n3 = 0;
            while (n3 < n2) {
                int n4 = 0;
                while (n4 < n) {
                    ((float[])this.stack[0])[n4 + this.nx * n3] = ((float[][])object)[n4][n3];
                    ++n4;
                }
                ++n3;
            }
            return;
        } else {
            if (!(object instanceof float[][][])) return;
            int n = ((float[][][])object).length;
            int n5 = ((float[][][])object)[0].length;
            int n6 = ((float[][][])object)[0][0].length;
            if (this.dimension != 3 || this.nx != n || this.ny != n5 || this.nz != n6) throw new IllegalArgumentException("");
            int n7 = 0;
            while (n7 < n6) {
                int n8 = 0;
                while (n8 < n5) {
                    int n9 = 0;
                    while (n9 < n) {
                        ((float[])this.stack[n7])[n9 + this.nx * n8] = ((float[][][])object)[n9][n8][n7];
                        ++n9;
                    }
                    ++n8;
                }
                ++n7;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void getPixels(Object object) {
        if (object instanceof float[]) {
            if (this.dimension != 1 || this.nx != ((float[])object).length) throw new IllegalArgumentException("");
            int n = 0;
            while (n < this.nx) {
                ((float[])object)[n] = ((float[])this.stack[0])[n];
                ++n;
            }
            return;
        } else if (object instanceof float[][]) {
            int n = ((float[][])object).length;
            int n2 = ((float[][])object)[0].length;
            if (this.dimension != 2 || this.nx != n || this.ny != n2) throw new IllegalArgumentException("");
            boolean bl = false;
            int n3 = 0;
            while (n3 < n2) {
                int n4 = 0;
                while (n4 < n) {
                    ((float[][])object)[n4][n3] = ((float[])this.stack[0])[n4 + this.nx * n3];
                    ++n4;
                }
                ++n3;
            }
            return;
        } else {
            if (!(object instanceof float[][][])) return;
            int n = ((float[][][])object).length;
            int n5 = ((float[][][])object)[0].length;
            int n6 = ((float[][][])object)[0][0].length;
            if (this.dimension != 3 || this.nx != n || this.ny != n5 || this.nz != n6) throw new IllegalArgumentException("");
            int n7 = 0;
            while (n7 < n6) {
                int n8 = 0;
                while (n8 < n5) {
                    int n9 = 0;
                    while (n9 < n) {
                        ((float[][][])object)[n9][n8][n7] = ((float[])this.stack[n7])[n9 + this.nx * n8];
                        ++n9;
                    }
                    ++n8;
                }
                ++n7;
            }
        }
    }

    public double getInterpolatedPixel(double d) {
        return this.getInterpolatedPixel(d, 0.0, 0.0);
    }

    public double getInterpolatedPixel(double d, double d2) {
        return this.getInterpolatedPixel(d, d2, 0.0);
    }

    public double getInterpolatedPixel(double d, double d2, double d3) {
        double d4 = 0.0;
        switch (this.dimension) {
            case 1: {
                double[] dArray = new double[2];
                int n = FloatDataExtended.floor(d);
                double d5 = d - (double)n;
                this.getNeighborhood(n, dArray);
                return dArray[1] * d5 - dArray[0] * (d5 - 1.0);
            }
            case 2: {
                double[][] dArray = new double[2][2];
                int n = FloatDataExtended.floor(d);
                int n2 = FloatDataExtended.floor(d2);
                double d6 = d - (double)n;
                double d7 = d2 - (double)n2;
                this.getNeighborhood(n, n2, dArray);
                return d6 * (dArray[1][1] * d7 - dArray[1][0] * (d7 - 1.0)) - (d6 - 1.0) * (dArray[0][1] * d7 - dArray[0][0] * (d7 - 1.0));
            }
            case 3: {
                double[][][] dArray = new double[2][2][2];
                int n = FloatDataExtended.floor(d);
                int n3 = FloatDataExtended.floor(d2);
                int n4 = FloatDataExtended.floor(d3);
                double d8 = d - (double)n;
                double d9 = d2 - (double)n3;
                double d10 = d3 - (double)n4;
                this.getNeighborhood(n, n3, n4, dArray);
                double d11 = d8 * (dArray[1][1][0] * d9 - dArray[1][0][0] * (d9 - 1.0)) - (d8 - 1.0) * (dArray[0][1][0] * d9 - dArray[0][0][0] * (d9 - 1.0));
                double d12 = d8 * (dArray[1][1][1] * d9 - dArray[1][0][1] * (d9 - 1.0)) - (d8 - 1.0) * (dArray[0][1][1] * d9 - dArray[0][0][0] * (d9 - 1.0));
                return d12 * d10 - d11 * (d10 - 1.0);
            }
        }
        return d4;
    }

    public void get(Object object) {
        Coordinate coordinate = new Coordinate(0, 0, 0);
        this.get(coordinate, object);
    }

    public void put(Object object) {
        Coordinate coordinate = new Coordinate(0, 0, 0);
        this.put(coordinate, object);
    }

    public double get(Coordinate coordinate) {
        coordinate.add(this.border);
        double d = 0.0;
        if (this.fast) {
            d = ((float[])this.stack[coordinate.z])[coordinate.x + this.nx * coordinate.y];
            return d;
        }
        try {
            d = ((float[])this.stack[coordinate.z])[coordinate.x + this.nx * coordinate.y];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            switch (this.dimension) {
                case 3: {
                    if (coordinate.z < 0) {
                        throw new ArrayStoreException("z = " + coordinate.z + " out of bounds z<0");
                    }
                    if (coordinate.z >= this.nz) {
                        throw new ArrayStoreException("z = " + coordinate.z + " out of bounds z >= nz");
                    }
                }
                case 2: {
                    if (coordinate.y < 0) {
                        throw new ArrayStoreException("y = " + coordinate.y + " out of bounds y<0");
                    }
                    if (coordinate.y >= this.ny) {
                        throw new ArrayStoreException("y = " + coordinate.y + " out of bounds y >= ny");
                    }
                }
                case 1: {
                    if (coordinate.x < 0) {
                        throw new ArrayStoreException("x = " + coordinate.x + " out of bounds x<0");
                    }
                    if (coordinate.x < this.nx) break;
                    throw new ArrayStoreException("x = " + coordinate.x + " out of bounds x >= nx");
                }
            }
        }
        return d;
    }

    public void put(Coordinate coordinate, double d) {
        coordinate.add(this.border);
        if (this.fast) {
            ((float[])this.stack[coordinate.z])[coordinate.x + this.nx * coordinate.y] = (float)d;
            return;
        }
        try {
            ((float[])this.stack[coordinate.z])[coordinate.x + this.nx * coordinate.y] = (float)d;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            switch (this.dimension) {
                case 3: {
                    if (coordinate.z < 0) {
                        throw new ArrayStoreException("z = " + coordinate.z + " out of bounds z<0");
                    }
                    if (coordinate.z >= this.nz) {
                        throw new ArrayStoreException("z = " + coordinate.z + " out of bounds z >= nz");
                    }
                }
                case 2: {
                    if (coordinate.y < 0) {
                        throw new ArrayStoreException("y = " + coordinate.y + " out of bounds y<0");
                    }
                    if (coordinate.y >= this.ny) {
                        throw new ArrayStoreException("y = " + coordinate.y + " out of bounds y >= ny");
                    }
                }
                case 1: {
                    if (coordinate.x < 0) {
                        throw new ArrayStoreException("x = " + coordinate.x + " out of bounds x<0");
                    }
                    if (coordinate.x < this.nx) break;
                    throw new ArrayStoreException("x = " + coordinate.x + " out of bounds x >= nx");
                }
            }
        }
    }

    public void get(Coordinate coordinate, Object object) {
        switch (this.dimension) {
            case 2: {
                if (object instanceof double[][]) {
                    this.get(coordinate.x, coordinate.y, (double[][])object);
                    return;
                }
                if (object instanceof double[][][]) {
                    this.get(coordinate.x, coordinate.y, coordinate.z, (double[][][])object);
                    return;
                }
                if (object instanceof double[]) {
                    this.get(coordinate.x, coordinate.y, (double[])object);
                    return;
                }
            }
            case 3: {
                if (object instanceof double[][]) {
                    this.get(coordinate.x, coordinate.y, coordinate.z, (double[][])object);
                    return;
                }
                if (object instanceof double[][][]) {
                    this.get(coordinate.x, coordinate.y, coordinate.z, (double[][][])object);
                    return;
                }
                if (object instanceof double[]) {
                    this.get(coordinate.x, coordinate.y, coordinate.z, (double[])object);
                    return;
                }
            }
            case 1: {
                if (object instanceof double[]) {
                    this.get(coordinate.x, (double[])object);
                    return;
                }
                if (object instanceof double[][]) {
                    this.get(coordinate.x, 0, (double[][])object);
                    return;
                }
                if (!(object instanceof double[][][])) break;
                this.get(coordinate.x, 0, 0, (double[][][])object);
                return;
            }
        }
    }

    public void put(Coordinate coordinate, Object object) {
        switch (this.dimension) {
            case 2: {
                if (object instanceof double[][]) {
                    this.put(coordinate.x, coordinate.y, (double[][])object);
                    return;
                }
                if (object instanceof double[][][]) {
                    this.put(coordinate.x, coordinate.y, coordinate.z, (double[][][])object);
                    return;
                }
                if (object instanceof double[]) {
                    this.put(coordinate.x, coordinate.y, (double[])object);
                    return;
                }
            }
            case 3: {
                if (object instanceof double[][]) {
                    this.put(coordinate.x, coordinate.y, coordinate.z, (double[][])object);
                    return;
                }
                if (object instanceof double[][][]) {
                    this.put(coordinate.x, coordinate.y, coordinate.z, (double[][][])object);
                    return;
                }
                if (object instanceof double[]) {
                    this.put(coordinate.x, coordinate.y, coordinate.z, (double[])object);
                    return;
                }
            }
            case 1: {
                if (object instanceof double[]) {
                    this.put(coordinate.x, (double[])object);
                    return;
                }
                if (object instanceof double[][]) {
                    this.put(coordinate.x, 0, (double[][])object);
                    return;
                }
                if (!(object instanceof double[][][])) break;
                this.put(coordinate.x, 0, 0, (double[][][])object);
                return;
            }
        }
    }

    public void get(int n, int n2, int n3, double[][][] dArray) {
        n += this.border;
        n2 += this.border;
        n3 += this.border;
        double d = 0.0;
        int n4 = dArray.length;
        int n5 = dArray[0].length;
        int n6 = dArray[0][0].length;
        if (this.fast) {
            int n7 = 0;
            int n8 = n + n2 * this.nx;
            int n9 = this.nx - n4;
            int n10 = 0;
            while (n10 < n6) {
                n7 = n8;
                int n11 = 0;
                while (n11 < n5) {
                    int n12 = 0;
                    while (n12 < n4) {
                        dArray[n12][n11][n10] = ((float[])this.stack[n3])[n7++];
                        ++n12;
                    }
                    n7 += n9;
                    ++n11;
                }
                ++n3;
                ++n10;
            }
            return;
        }
        try {
            if (n < 0) {
                d = ((float[])this.stack[-1])[0];
            }
            if (n >= this.nx) {
                d = ((float[])this.stack[-1])[0];
            }
            d = ((float[])this.stack[n3])[n + n2 * this.nx];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.MessageOutofBounds(n, n2, n3, this.nx, this.ny, this.nz);
            return;
        }
        catch (NullPointerException nullPointerException) {
            this.MessageOutofBounds(n, n2, n3, this.nx, this.ny, this.nz);
            return;
        }
        try {
            if (n + n4 > this.nx) {
                d = ((float[])this.stack[-1])[0];
            }
            d = ((float[])this.stack[n3 + n6 - 1])[n + n4 - 1 + (n2 + n5 - 1) * this.nx];
            int n13 = n3;
            int n14 = 0;
            int n15 = n + n2 * this.nx;
            int n16 = this.nx - n4;
            int n17 = 0;
            while (n17 < n6) {
                n14 = n15;
                int n18 = 0;
                while (n18 < n5) {
                    int n19 = 0;
                    while (n19 < n4) {
                        dArray[n19][n18][n17] = ((float[])this.stack[n13])[n14++];
                        ++n19;
                    }
                    n14 += n16;
                    ++n18;
                }
                ++n13;
                ++n17;
            }
            return;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayStoreException(String.valueOf(String.valueOf(arrayIndexOutOfBoundsException)) + "Out the image");
        }
        catch (NullPointerException nullPointerException) {
            throw new ArrayStoreException(String.valueOf(String.valueOf(nullPointerException)) + "Out the image");
        }
    }

    public void get(int n, int n2, int n3, double[][] dArray) {
        FloatDataExtended floatDataExtended = null;
        Object[] objectArray = null;
        switch (this.dir) {
            case 3: {
                if (this.fast) {
                    n3 += this.border;
                    int n4 = dArray.length;
                    int n5 = dArray[0].length;
                    double d = 0.0;
                    int n6 = (n2 += this.border) * this.nx + (n += this.border);
                    int n7 = this.nx - n4;
                    int n8 = 0;
                    while (n8 < n5) {
                        int n9 = 0;
                        while (n9 < n4) {
                            d = ((float[])this.stack[n3])[n6++];
                            dArray[n9][n8] = d < 0.0 ? d + 256.0 : d;
                            ++n9;
                        }
                        n6 += n7;
                        ++n8;
                    }
                    return;
                }
                floatDataExtended = new FloatDataExtended(this.nx, this.ny);
                objectArray = ((Data)floatDataExtended).getReferencePixels();
                n3 += this.border;
                try {
                    int n10 = this.nx * this.ny;
                    int n11 = 0;
                    int n12 = 0;
                    while (n12 < n10) {
                        ((float[])objectArray[0])[n11] = ((float[])this.stack[n3])[n11];
                        ++n11;
                        ++n12;
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    this.MessageOutofBounds(0, 0, n3, this.nx, this.ny, this.nz);
                    return;
                }
                catch (NullPointerException nullPointerException) {
                    this.MessageOutofBounds(0, 0, n3, this.nx, this.ny, this.nz);
                    return;
                }
                ((Data)floatDataExtended).get(n, n2, dArray);
                return;
            }
            case 5: {
                if (this.fast) {
                    n3 += this.border;
                    int n13 = dArray.length;
                    int n14 = dArray[0].length;
                    double d = 0.0;
                    int n15 = (n2 += this.border) * this.nx + (n += this.border);
                    int n16 = 0;
                    while (n16 < n14) {
                        int n17 = 0;
                        while (n17 < n13) {
                            d = ((float[])this.stack[n3])[n17 + n15];
                            dArray[n17][n16] = d < 0.0 ? d + 256.0 : d;
                            ++n17;
                        }
                        ++n3;
                        ++n16;
                    }
                    return;
                }
                floatDataExtended = new FloatDataExtended(this.nx, this.nz);
                objectArray = ((Data)floatDataExtended).getReferencePixels();
                n2 += this.border;
                try {
                    int n18 = n2 * this.nx;
                    int n19 = 0;
                    int n20 = 0;
                    while (n20 < this.nz) {
                        int n21 = 0;
                        while (n21 < this.nx) {
                            ((float[])objectArray[0])[n19++] = ((float[])this.stack[n20])[n21 + n18];
                            ++n21;
                        }
                        ++n20;
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    this.MessageOutofBounds(0, n2, 0, this.nx, this.ny, this.nz);
                    return;
                }
                ((Data)floatDataExtended).get(n, n3, dArray);
                return;
            }
            case 4: {
                if (this.fast) {
                    int n22 = dArray.length;
                    int n23 = dArray[0].length;
                    double d = 0.0;
                    int n24 = (n2 += this.border) * this.nx + (n += this.border);
                    int n25 = n3 += this.border;
                    int n26 = 0;
                    while (n26 < n23) {
                        n25 = n3;
                        int n27 = 0;
                        while (n27 < n22) {
                            d = ((float[])this.stack[n25])[n24];
                            dArray[n27][n26] = d < 0.0 ? d + 256.0 : d;
                            ++n25;
                            ++n27;
                        }
                        n24 += this.nx;
                        ++n26;
                    }
                    return;
                }
                floatDataExtended = new FloatDataExtended(this.nz, this.ny);
                objectArray = ((Data)floatDataExtended).getReferencePixels();
                n += this.border;
                try {
                    int n28 = n;
                    int n29 = 0;
                    int n30 = 0;
                    while (n30 < this.ny) {
                        int n31 = 0;
                        while (n31 < this.nz) {
                            ((float[])objectArray[0])[n29++] = ((float[])this.stack[n31])[n28];
                            ++n31;
                        }
                        n28 += this.nx;
                        ++n30;
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    this.MessageOutofBounds(n, 0, 0, this.nx, this.ny, this.nz);
                    return;
                }
                ((Data)floatDataExtended).get(n3, n2, dArray);
                return;
            }
        }
        throw new ArrayStoreException("Unexpected direction" + this.dir);
    }

    public void get(int n, int n2, int n3, double[] dArray) {
        FloatDataExtended floatDataExtended = null;
        float[] fArray = null;
        switch (this.dir) {
            case 0: {
                if (this.fast) {
                    n3 += this.border;
                    int n4 = dArray.length;
                    double d = 0.0;
                    int n5 = (n2 += this.border) * this.nx + (n += this.border);
                    int n6 = 0;
                    while (n6 < n4) {
                        dArray[n6] = (d = (double)((float[])this.stack[n3])[n5++]) < 0.0 ? d + 256.0 : d;
                        ++n6;
                    }
                    return;
                }
                floatDataExtended = new FloatDataExtended(this.nx, this.ny);
                fArray = (float[])((Data)floatDataExtended).getReferencePixels()[0];
                n3 += this.border;
                try {
                    int n7 = 0;
                    int n8 = this.nx * this.ny;
                    int n9 = 0;
                    while (n9 < n8) {
                        fArray[n7] = ((float[])this.stack[n3])[n7];
                        ++n7;
                        ++n9;
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    this.MessageOutofBounds(0, 0, n3, this.nx, this.ny, this.nz);
                    return;
                }
                catch (NullPointerException nullPointerException) {
                    this.MessageOutofBounds(0, 0, n3, this.nx, this.ny, this.nz);
                    return;
                }
                ((Data)floatDataExtended).setDirection(0);
                ((Data)floatDataExtended).get(n, n2, dArray);
                return;
            }
            case 1: {
                if (this.fast) {
                    n3 += this.border;
                    double d = 0.0;
                    int n10 = dArray.length;
                    int n11 = (n2 += this.border) * this.nx + (n += this.border);
                    int n12 = 0;
                    while (n12 < n10) {
                        dArray[n12] = (d = (double)((float[])this.stack[n3])[n11++]) < 0.0 ? d + 256.0 : d;
                        n11 += this.nx;
                        ++n12;
                    }
                    return;
                }
                floatDataExtended = new FloatDataExtended(this.nx, this.ny);
                fArray = (float[])((Data)floatDataExtended).getReferencePixels()[0];
                n3 += this.border;
                try {
                    int n13 = 0;
                    int n14 = this.nx * this.ny;
                    int n15 = 0;
                    while (n15 < n14) {
                        fArray[n13] = ((float[])this.stack[n3])[n13];
                        ++n13;
                        ++n15;
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    this.MessageOutofBounds(0, 0, n3, this.nx, this.ny, this.nz);
                    return;
                }
                catch (NullPointerException nullPointerException) {
                    this.MessageOutofBounds(0, 0, n3, this.nx, this.ny, this.nz);
                    return;
                }
                ((Data)floatDataExtended).setDirection(1);
                ((Data)floatDataExtended).get(n, n2, dArray);
                return;
            }
            case 2: {
                if (this.fast) {
                    n3 += this.border;
                    double d = 0.0;
                    int n16 = dArray.length;
                    int n17 = (n2 += this.border) * this.nx + (n += this.border);
                    int n18 = 0;
                    while (n18 < n16) {
                        dArray[n18] = (d = (double)((float[])this.stack[n3++])[n17]) < 0.0 ? d + 256.0 : d;
                        ++n18;
                    }
                    return;
                }
                floatDataExtended = new FloatDataExtended(this.nz, this.ny);
                fArray = (float[])((Data)floatDataExtended).getReferencePixels()[0];
                n += this.border;
                try {
                    int n19 = 0;
                    int n20 = n;
                    int n21 = 0;
                    while (n21 < this.ny) {
                        int n22 = 0;
                        while (n22 < this.nz) {
                            fArray[n19++] = ((float[])this.stack[n22])[n20];
                            ++n22;
                        }
                        n20 += this.nx;
                        ++n21;
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    this.MessageOutofBounds(n, 0, 0, this.nx, this.ny, this.nz);
                    return;
                }
                catch (NullPointerException nullPointerException) {
                    this.MessageOutofBounds(n, 0, 0, this.nx, this.ny, this.nz);
                    return;
                }
                ((Data)floatDataExtended).setDirection(0);
                ((Data)floatDataExtended).get(n3, n2, dArray);
                return;
            }
        }
        throw new ArrayStoreException("Unexpected direction" + this.dir);
    }

    public void get(int n, int n2, double[][] dArray) {
        n += this.border;
        n2 += this.border;
        double d = 0.0;
        int n3 = dArray.length;
        int n4 = dArray[0].length;
        if (this.fast) {
            int n5 = n2 * this.nx + n;
            int n6 = this.nx - n3;
            int n7 = 0;
            while (n7 < n4) {
                int n8 = 0;
                while (n8 < n3) {
                    dArray[n8][n7] = ((float[])this.stack[0])[n5++];
                    ++n8;
                }
                n5 += n6;
                ++n7;
            }
            return;
        }
        try {
            if (n < 0) {
                d = ((float[])this.stack[-1])[0];
            }
            if (n >= this.nx) {
                d = ((float[])this.stack[-1])[0];
            }
            d = ((float[])this.stack[0])[n + n2 * this.nx];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.MessageOutofBounds(n, n2, 0, this.nx, this.ny, this.nz);
            return;
        }
        try {
            if (n + n3 > this.nx) {
                d = ((float[])this.stack[-1])[0];
            }
            d = ((float[])this.stack[0])[n + n3 - 1 + (n2 + n4 - 1) * this.nx];
            int n9 = n2 * this.nx + n;
            int n10 = this.nx - n3;
            int n11 = 0;
            while (n11 < n4) {
                int n12 = 0;
                while (n12 < n3) {
                    dArray[n12][n11] = ((float[])this.stack[0])[n9++];
                    ++n12;
                }
                n9 += n10;
                ++n11;
            }
            return;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayStoreException(String.valueOf(String.valueOf(arrayIndexOutOfBoundsException)) + " Out of the image");
        }
    }

    public void get(int n, int n2, double[] dArray) {
        n += this.border;
        n2 += this.border;
        double d = 0.0;
        switch (this.dir) {
            case 0: {
                int n3 = dArray.length;
                if (this.fast) {
                    int n4 = n2 * this.nx + n;
                    int n5 = 0;
                    while (n5 < n3) {
                        dArray[n5] = ((float[])this.stack[0])[n4++];
                        ++n5;
                    }
                    return;
                }
                try {
                    if (n >= this.nx) {
                        d = ((float[])this.stack[-1])[0];
                    }
                    d = ((float[])this.stack[0])[n2 * this.nx];
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    this.MessageOutofBounds(n, n2, 0, this.nx, this.ny, this.nz);
                    return;
                }
                try {
                    if (n < 0) {
                        d = ((float[])this.stack[-1])[0];
                    }
                    if (n + n3 > this.nx) {
                        d = ((float[])this.stack[-1])[0];
                    }
                    int n6 = n2 * this.nx + n;
                    int n7 = 0;
                    while (n7 < n3) {
                        dArray[n7] = ((float[])this.stack[0])[n6++];
                        ++n7;
                    }
                    return;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    throw new ArrayStoreException(String.valueOf(String.valueOf(arrayIndexOutOfBoundsException)) + " Out of the image");
                }
            }
            case 1: {
                int n8 = dArray.length;
                if (this.fast) {
                    int n9 = n2 * this.nx + n;
                    int n10 = 0;
                    while (n10 < n8) {
                        dArray[n10] = ((float[])this.stack[0])[n9++];
                        n9 += this.nx;
                        ++n10;
                    }
                    return;
                }
                try {
                    if (n < 0) {
                        d = ((float[])this.stack[-1])[0];
                    }
                    if (n >= this.nx) {
                        d = ((float[])this.stack[-1])[0];
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    this.MessageOutofBounds(n, 0, 0, this.nx, this.ny, this.nz);
                    return;
                }
                try {
                    d = ((float[])this.stack[0])[n + (n2 + n8 - 1) * this.nx];
                    int n11 = n2 * this.nx + n;
                    int n12 = 0;
                    while (n12 < n8) {
                        dArray[n12] = ((float[])this.stack[0])[n11++];
                        n11 += this.nx;
                        ++n12;
                    }
                    return;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    throw new ArrayStoreException(String.valueOf(String.valueOf(arrayIndexOutOfBoundsException)) + " Out of the image");
                }
            }
        }
        throw new ArrayStoreException("Unexpected direction" + this.dir);
    }

    public void get(int n, double[] dArray) {
        n += this.border;
        int n2 = dArray.length;
        double d = 0.0;
        if (this.fast) {
            int n3 = n;
            int n4 = 0;
            while (n4 < n2) {
                dArray[n4] = ((float[])this.stack[0])[n3++];
                ++n4;
            }
            return;
        }
        try {
            if (n < 0) {
                d = ((float[])this.stack[-1])[0];
            }
            if (n >= this.nx) {
                d = ((float[])this.stack[-1])[0];
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.MessageOutofBounds(n, 0, 0, this.nx, this.ny, this.nz);
            return;
        }
        try {
            if (n + n2 > this.nx) {
                d = ((float[])this.stack[-1])[0];
            }
            int n5 = n;
            int n6 = 0;
            while (n6 < n2) {
                dArray[n6] = ((float[])this.stack[0])[n5++];
                ++n6;
            }
            return;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayStoreException(String.valueOf(String.valueOf(arrayIndexOutOfBoundsException)) + " Out of the image");
        }
    }

    public void put(int n, int n2, int n3, double[][][] dArray) {
        int n4;
        n += this.border;
        n2 += this.border;
        n3 += this.border;
        int n5 = dArray.length;
        int n6 = dArray[0].length;
        int n7 = dArray[0][0].length;
        double d = 0.0;
        if (this.fast) {
            int n8;
            int n9 = n8 = n2 * this.nx + n;
            int n10 = 0;
            while (n10 < n7) {
                n8 = n9;
                int n11 = 0;
                while (n11 < n6) {
                    int n12 = 0;
                    while (n12 < n5) {
                        ((float[])this.stack[n3])[n12 + n8] = (float)dArray[n12][n11][n10];
                        ++n12;
                    }
                    n8 += this.nx;
                    ++n11;
                }
                ++n3;
                ++n10;
            }
            return;
        }
        try {
            if (n < 0) {
                d = ((float[])this.stack[-1])[0];
            }
            if (n >= this.nx) {
                d = ((float[])this.stack[-1])[0];
            }
            d = ((float[])this.stack[n3])[n + n2 * this.nx];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.MessageOutofBounds(n, n2, n3, this.nx, this.ny, this.nz);
            return;
        }
        catch (NullPointerException nullPointerException) {
            this.MessageOutofBounds(n, n2, n3, this.nx, this.ny, this.nz);
            return;
        }
        int n13 = n4 = n2 * this.nx + n;
        int n14 = n3;
        try {
            if (n + n5 > this.nx) {
                d = ((float[])this.stack[-1])[0];
            }
            d = ((float[])this.stack[n3 + n7 - 1])[n + n5 - 1 + (n2 + n6 - 1) * this.nx];
            int n15 = 0;
            while (n15 < n7) {
                n4 = n13;
                int n16 = 0;
                while (n16 < n6) {
                    int n17 = 0;
                    while (n17 < n5) {
                        ((float[])this.stack[n14])[n17 + n4] = (float)dArray[n17][n16][n15];
                        ++n17;
                    }
                    n4 += this.nx;
                    ++n16;
                }
                ++n14;
                ++n15;
            }
            return;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
        }
        catch (NullPointerException nullPointerException) {}
        if (n + n5 > this.nx) {
            n5 = this.nx - n;
        }
        if (n2 + n6 > this.ny) {
            n6 = this.ny - n2;
        }
        if (n3 + n7 > this.nz) {
            n7 = this.nz - n3;
        }
        int n18 = 0;
        while (n18 < n7) {
            n4 = n13;
            int n19 = 0;
            while (n19 < n6) {
                int n20 = 0;
                while (n20 < n5) {
                    ((float[])this.stack[n14])[n20 + n4] = (float)dArray[n20][n19][n18];
                    ++n20;
                }
                n4 += this.nx;
                ++n19;
            }
            ++n14;
            ++n18;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void put(int var1_1, int var2_2, int var3_3, double[][] var4_4) {
        var1_1 += this.border;
        var2_2 += this.border;
        var3_3 += this.border;
        if (this.fast) {
            var5_5 = var4_4.length;
            var6_7 = var4_4[0].length;
            var7_8 = 0.0;
            switch (this.dir) {
                case 3: {
                    var9_10 = var2_2 * this.nx + var1_1;
                    var10_14 = 0;
                    while (var10_14 < var6_7) {
                        var11_22 = 0;
                        while (var11_22 < var5_5) {
                            ((float[])this.stack[var3_3])[var11_22 + var9_10] = (float)var4_4[var11_22][var10_14];
                            ++var11_22;
                        }
                        var9_10 += this.nx;
                        ++var10_14;
                    }
                    return;
                }
                case 5: {
                    var9_11 = var2_2 * this.nx + var1_1;
                    var10_15 = 0;
                    while (var10_15 < var6_7) {
                        var11_23 = 0;
                        while (var11_23 < var5_5) {
                            ((float[])this.stack[var3_3])[var9_11 + var11_23] = (float)var4_4[var11_23][var10_15];
                            ++var11_23;
                        }
                        ++var3_3;
                        ++var10_15;
                    }
                    return;
                }
                case 4: {
                    var9_12 = var2_2 * this.nx + var1_1;
                    var10_16 = 0;
                    while (var10_16 < var6_7) {
                        var11_24 = 0;
                        while (var11_24 < var5_5) {
                            ((float[])this.stack[var3_3 + var11_24])[var9_12] = (float)var4_4[var11_24][var10_16];
                            ++var11_24;
                        }
                        var9_12 += this.nx;
                        ++var10_16;
                    }
                    return;
                }
            }
            throw new ArrayStoreException("Unexpected direction" + this.dir);
        }
        var5_6 = 0.0;
        try {
            if (var1_1 < 0) {
                var5_6 = ((float[])this.stack[-1])[0];
            }
            if (var1_1 >= this.nx) {
                var5_6 = ((float[])this.stack[-1])[0];
            }
            var5_6 = ((float[])this.stack[var3_3])[var1_1 + var2_2 * this.nx];
        }
        catch (ArrayIndexOutOfBoundsException v0) {
            this.MessageOutofBounds(var1_1, var2_2, var3_3, this.nx, this.ny, this.nz);
            return;
        }
        catch (NullPointerException v1) {
            this.MessageOutofBounds(var1_1, var2_2, var3_3, this.nx, this.ny, this.nz);
            return;
        }
        var7_9 = var4_4.length;
        var8_31 = var4_4[0].length;
        var9_13 = 0;
        switch (this.dir) {
            case 3: {
                try {
                    if (var1_1 + var7_9 > this.nx) {
                        var5_6 = ((float[])this.stack[-1])[0];
                    }
                    var5_6 = ((float[])this.stack[var3_3])[var1_1 + var7_9 - 1 + (var2_2 + var8_31 - 1) * this.nx];
                    var10_17 = var2_2 * this.nx + var1_1;
                    var11_25 = 0;
                    while (var11_25 < var8_31) {
                        var12_32 = 0;
                        while (var12_32 < var7_9) {
                            ((float[])this.stack[var3_3])[var12_32 + var10_17] = (float)var4_4[var12_32][var11_25];
                            ++var12_32;
                        }
                        var10_17 += this.nx;
                        ++var11_25;
                    }
                    return;
                }
                catch (ArrayIndexOutOfBoundsException v2) {
                    if (var1_1 + var7_9 > this.nx) {
                        var7_9 = this.nx - var1_1;
                    }
                    if (var2_2 + var8_31 > this.ny) {
                        var8_31 = this.ny - var2_2;
                    }
                    var10_18 = var2_2 * this.nx + var1_1;
                    var11_26 = 0;
                    ** while (var11_26 < var8_31)
                }
lbl-1000:
                // 1 sources

                {
                    var12_33 = 0;
                    while (var12_33 < var7_9) {
                        ((float[])this.stack[var3_3])[var12_33 + var10_18] = (float)var4_4[var12_33][var11_26];
                        ++var12_33;
                    }
                    var10_18 += this.nx;
                    ++var11_26;
                    continue;
                }
lbl100:
                // 1 sources

                return;
            }
            case 5: {
                var10_19 = var3_3;
                try {
                    if (var1_1 + var7_9 > this.nx) {
                        var5_6 = ((float[])this.stack[-1])[0];
                    }
                    var5_6 = ((float[])this.stack[var3_3 + var8_31 - 1])[var1_1 + var7_9 - 1 + var2_2 * this.nx];
                    var9_13 = var2_2 * this.nx + var1_1;
                    var11_27 = 0;
                    while (var11_27 < var8_31) {
                        var12_34 = 0;
                        while (var12_34 < var7_9) {
                            ((float[])this.stack[var10_19])[var9_13 + var12_34] = (float)var4_4[var12_34][var11_27];
                            ++var12_34;
                        }
                        ++var10_19;
                        ++var11_27;
                    }
                    return;
                }
                catch (ArrayIndexOutOfBoundsException v3) {
                }
                catch (NullPointerException v4) {}
                if (var1_1 + var7_9 > this.nx) {
                    var7_9 = this.nx - var1_1;
                }
                if (var3_3 + var8_31 > this.nz) {
                    var8_31 = this.nz - var3_3;
                }
                var9_13 = var2_2 * this.nx + var1_1;
                var11_28 = 0;
                while (var11_28 < var8_31) {
                    var12_35 = 0;
                    while (var12_35 < var7_9) {
                        ((float[])this.stack[var10_19])[var9_13 + var12_35] = (float)var4_4[var12_35][var11_28];
                        ++var12_35;
                    }
                    ++var10_19;
                    ++var11_28;
                }
                return;
            }
            case 4: {
                try {
                    if (var1_1 + var7_9 > this.nx) {
                        var5_6 = ((float[])this.stack[-1])[0];
                    }
                    var5_6 = ((float[])this.stack[var3_3 + var7_9 - 1])[var1_1 + (var2_2 + var8_31 - 1) * this.nx];
                    var10_20 = var2_2 * this.nx + var1_1;
                    var11_29 = 0;
                    while (var11_29 < var8_31) {
                        var12_36 = 0;
                        while (var12_36 < var7_9) {
                            ((float[])this.stack[var3_3 + var12_36])[var10_20] = (float)var4_4[var12_36][var11_29];
                            ++var12_36;
                        }
                        var10_20 += this.nx;
                        ++var11_29;
                    }
                    return;
                }
                catch (ArrayIndexOutOfBoundsException v5) {
                }
                catch (NullPointerException v6) {}
                if (var2_2 + var8_31 > this.ny) {
                    var8_31 = this.ny - var2_2;
                }
                if (var3_3 + var7_9 > this.nz) {
                    var7_9 = this.nz - var3_3;
                }
                var10_21 = var2_2 * this.nx + var1_1;
                var11_30 = 0;
                while (var11_30 < var8_31) {
                    var12_37 = 0;
                    while (var12_37 < var7_9) {
                        ((float[])this.stack[var3_3 + var12_37])[var10_21] = (float)var4_4[var12_37][var11_30];
                        ++var12_37;
                    }
                    var10_21 += this.nx;
                    ++var11_30;
                }
                return;
            }
        }
        throw new ArrayStoreException("Unexpected direction" + this.dir);
    }

    /*
     * Unable to fully structure code
     */
    public void put(int var1_1, int var2_2, int var3_3, double[] var4_4) {
        var1_1 += this.border;
        var2_2 += this.border;
        var3_3 += this.border;
        if (this.fast) {
            var5_5 = var4_4.length;
            var6_7 = 0.0;
            switch (this.dir) {
                case 0: {
                    var8_9 = var1_1 + var2_2 * this.nx;
                    var9_13 = 0;
                    while (var9_13 < var5_5) {
                        ((float[])this.stack[var3_3])[var8_9++] = (float)var4_4[var9_13];
                        ++var9_13;
                    }
                    return;
                }
                case 1: {
                    var8_10 = var1_1 + var2_2 * this.nx;
                    var9_14 = 0;
                    while (var9_14 < var5_5) {
                        ((float[])this.stack[var3_3])[var8_10] = (float)var4_4[var9_14];
                        var8_10 += this.nx;
                        ++var9_14;
                    }
                    return;
                }
                case 2: {
                    var8_11 = var1_1 + var2_2 * this.nx;
                    var9_15 = 0;
                    while (var9_15 < var5_5) {
                        ((float[])this.stack[var3_3++])[var8_11] = (float)var4_4[var9_15];
                        ++var9_15;
                    }
                    return;
                }
            }
            throw new ArrayStoreException("Unexpected direction" + this.dir);
        }
        var5_6 = var1_1 + var2_2 * this.nx;
        var6_8 = 0.0;
        try {
            if (var1_1 < 0) {
                var6_8 = ((float[])this.stack[-1])[0];
            }
            if (var1_1 >= this.nx) {
                var6_8 = ((float[])this.stack[-1])[0];
            }
            var6_8 = ((float[])this.stack[var3_3])[var1_1 + var2_2 * this.nx];
        }
        catch (ArrayIndexOutOfBoundsException v0) {
            this.MessageOutofBounds(var1_1, var2_2, var3_3, this.nx, this.ny, this.nz);
            return;
        }
        catch (NullPointerException v1) {
            this.MessageOutofBounds(var1_1, var2_2, var3_3, this.nx, this.ny, this.nz);
            return;
        }
        var8_12 = var4_4.length;
        switch (this.dir) {
            case 0: {
                try {
                    if (var1_1 + var8_12 > this.nx) {
                        var6_8 = ((float[])this.stack[-1])[0];
                    }
                    var9_16 = 0;
                    while (var9_16 < var8_12) {
                        ((float[])this.stack[var3_3])[var5_6++] = (float)var4_4[var9_16];
                        ++var9_16;
                    }
                    return;
                }
                catch (ArrayIndexOutOfBoundsException v2) {
                    var5_6 = var1_1 + var2_2 * this.nx;
                    var8_12 = this.nx - var1_1;
                    var9_17 = 0;
                    ** while (var9_17 < var8_12)
                }
lbl-1000:
                // 1 sources

                {
                    ((float[])this.stack[var3_3])[var5_6++] = (float)var4_4[var9_17];
                    ++var9_17;
                    continue;
                }
lbl69:
                // 1 sources

                return;
            }
            case 1: {
                try {
                    var6_8 = ((float[])this.stack[var3_3])[var1_1 + (var2_2 + var8_12 - 1) * this.nx];
                    var9_18 = 0;
                    while (var9_18 < var8_12) {
                        ((float[])this.stack[var3_3])[var5_6] = (float)var4_4[var9_18];
                        var5_6 += this.nx;
                        ++var9_18;
                    }
                    return;
                }
                catch (ArrayIndexOutOfBoundsException v3) {
                    var8_12 = this.ny - var2_2;
                    var5_6 = var1_1 + var2_2 * this.nx;
                    var9_19 = 0;
                    ** while (var9_19 < var8_12)
                }
lbl-1000:
                // 1 sources

                {
                    ((float[])this.stack[var3_3])[var5_6] = (float)var4_4[var9_19];
                    var5_6 += this.nx;
                    ++var9_19;
                    continue;
                }
lbl89:
                // 1 sources

                return;
            }
            case 2: {
                var9_20 = var3_3;
                try {
                    var6_8 = ((float[])this.stack[var3_3 + var8_12 - 1])[var1_1 + var2_2 * this.nx];
                    var10_21 = 0;
                    while (var10_21 < var8_12) {
                        ((float[])this.stack[var9_20++])[var5_6] = (float)var4_4[var10_21];
                        ++var10_21;
                    }
                    return;
                }
                catch (ArrayIndexOutOfBoundsException v4) {
                }
                catch (NullPointerException v5) {}
                var8_12 = this.nz - var3_3;
                var10_22 = 0;
                while (var10_22 < var8_12) {
                    ((float[])this.stack[var3_3++])[var5_6] = (float)var4_4[var10_22];
                    ++var10_22;
                }
                return;
            }
        }
        throw new ArrayStoreException("Unexpected direction" + this.dir);
    }

    /*
     * Unable to fully structure code
     */
    public void put(int var1_1, int var2_2, double[][] var3_3) {
        var1_1 += this.border;
        var2_2 += this.border;
        var4_4 = var3_3.length;
        var5_5 = var3_3[0].length;
        var6_6 = 0.0;
        if (this.fast) {
            var8_7 = var2_2 * this.nx + var1_1;
            var9_9 = 0;
            while (var9_9 < var5_5) {
                var10_12 = 0;
                while (var10_12 < var4_4) {
                    ((float[])this.stack[0])[var10_12 + var8_7] = (float)var3_3[var10_12][var9_9];
                    ++var10_12;
                }
                var8_7 += this.nx;
                ++var9_9;
            }
            return;
        }
        try {
            if (var1_1 < 0) {
                var6_6 = ((float[])this.stack[-1])[0];
            }
            if (var1_1 >= this.nx) {
                var6_6 = ((float[])this.stack[-1])[0];
            }
            var6_6 = ((float[])this.stack[0])[var1_1 + var2_2 * this.nx];
        }
        catch (ArrayIndexOutOfBoundsException v0) {
            this.MessageOutofBounds(var1_1, var2_2, 0, this.nx, this.ny, this.nz);
            return;
        }
        var8_8 = var2_2 * this.nx + var1_1;
        try {
            if (var1_1 + var4_4 > this.nx) {
                var6_6 = ((float[])this.stack[-1])[0];
            }
            var6_6 = ((float[])this.stack[0])[var1_1 + var4_4 - 1 + (var2_2 + var5_5 - 1) * this.nx];
            var9_10 = 0;
            while (var9_10 < var5_5) {
                var10_13 = 0;
                while (var10_13 < var4_4) {
                    ((float[])this.stack[0])[var10_13 + var8_8] = (float)var3_3[var10_13][var9_10];
                    ++var10_13;
                }
                var8_8 += this.nx;
                ++var9_10;
            }
            return;
        }
        catch (ArrayIndexOutOfBoundsException v1) {
            if (var1_1 + var4_4 > this.nx) {
                var4_4 = this.nx - var1_1;
            }
            if (var2_2 + var5_5 > this.ny) {
                var5_5 = this.ny - var2_2;
            }
            var8_8 = var2_2 * this.nx + var1_1;
            var9_11 = 0;
            ** while (var9_11 < var5_5)
        }
lbl-1000:
        // 1 sources

        {
            var10_14 = 0;
            while (var10_14 < var4_4) {
                ((float[])this.stack[0])[var10_14 + var8_8] = (float)var3_3[var10_14][var9_11];
                ++var10_14;
            }
            var8_8 += this.nx;
            ++var9_11;
            continue;
        }
lbl61:
        // 1 sources

    }

    public void put(int n, int n2, double[] dArray) {
        n += this.border;
        n2 += this.border;
        if (this.fast) {
            int n3 = 0;
            switch (this.dir) {
                case 0: {
                    int n4 = dArray.length;
                    n3 = n2 * this.nx + n;
                    int n5 = 0;
                    int n6 = 0;
                    if (n >= 0) {
                        n6 = n <= this.nx - n4 ? n4 : -n + this.nx;
                        int n7 = n5;
                        while (n7 < n6) {
                            ((float[])this.stack[0])[n3++] = (float)dArray[n7];
                            ++n7;
                        }
                        return;
                    }
                    n3 = n2 * this.nx;
                    n5 = -n;
                    n6 = n <= this.nx - n4 ? n4 : -n + this.nx;
                    int n8 = n5;
                    while (n8 < n6) {
                        ((float[])this.stack[0])[n3++] = (float)dArray[n8];
                        ++n8;
                    }
                    return;
                }
                case 1: {
                    int n9 = dArray.length;
                    n3 = n2 * this.nx + n;
                    int n10 = 0;
                    int n11 = 0;
                    if (n2 >= 0) {
                        n11 = n2 <= this.ny - n9 ? n9 : -n2 + this.ny;
                        int n12 = n10;
                        while (n12 < n11) {
                            ((float[])this.stack[0])[n3] = (float)dArray[n12];
                            n3 += this.nx;
                            ++n12;
                        }
                        return;
                    }
                    n3 = n;
                    n10 = -n2;
                    n11 = n2 <= this.ny - n9 ? n9 : -n2 + this.ny;
                    int n13 = n10;
                    while (n13 < n11) {
                        ((float[])this.stack[0])[n3] = (float)dArray[n13];
                        n3 += this.nx;
                        ++n13;
                    }
                    return;
                }
            }
            throw new ArrayStoreException("Unexpected direction" + this.dir);
        }
        int n14 = 0;
        switch (this.dir) {
            case 0: {
                int n15 = dArray.length;
                double d = 0.0;
                try {
                    if (n >= this.nx) {
                        d = ((float[])this.stack[-1])[0];
                    }
                    d = ((float[])this.stack[0])[n2 * this.nx];
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    this.MessageOutofBounds(n, n2, 0, this.nx, this.ny, this.nz);
                    return;
                }
                n14 = n2 * this.nx + n;
                int n16 = 0;
                int n17 = 0;
                if (n >= 0) {
                    n17 = n <= this.nx - n15 ? n15 : -n + this.nx;
                    int n18 = n16;
                    while (n18 < n17) {
                        ((float[])this.stack[0])[n14++] = (float)dArray[n18];
                        ++n18;
                    }
                    return;
                }
                n14 = n2 * this.nx;
                n16 = -n;
                n17 = n <= this.nx - n15 ? n15 : -n + this.nx;
                int n19 = n16;
                while (n19 < n17) {
                    ((float[])this.stack[0])[n14++] = (float)dArray[n19];
                    ++n19;
                }
                break;
            }
            case 1: {
                int n20 = dArray.length;
                try {
                    double d;
                    if (n >= this.nx) {
                        d = ((float[])this.stack[-1])[0];
                    }
                    d = ((float[])this.stack[0])[n2 * this.nx];
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    this.MessageOutofBounds(n, n2, 0, this.nx, this.ny, this.nz);
                    return;
                }
                n14 = n2 * this.nx + n;
                int n21 = 0;
                int n22 = 0;
                if (n2 >= 0) {
                    n22 = n2 <= this.ny - n20 ? n20 : -n2 + this.ny;
                    int n23 = n21;
                    while (n23 < n22) {
                        ((float[])this.stack[0])[n14] = (float)dArray[n23];
                        n14 += this.nx;
                        ++n23;
                    }
                    return;
                }
                n14 = n;
                n21 = -n2;
                n22 = n2 <= this.ny - n20 ? n20 : -n2 + this.ny;
                int n24 = n21;
                while (n24 < n22) {
                    ((float[])this.stack[0])[n14] = (float)dArray[n24];
                    n14 += this.nx;
                    ++n24;
                }
                return;
            }
            default: {
                throw new ArrayStoreException("Unexpected direction" + this.dir);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void put(int var1_1, double[] var2_2) {
        var1_1 += this.border;
        if (this.fast) {
            var3_3 = var2_2.length;
            var4_5 = 0;
            while (var4_5 < var3_3) {
                ((float[])this.stack[0])[var1_1 + var4_5] = (float)var2_2[var4_5];
                ++var4_5;
            }
            return;
        }
        var3_4 = 0.0;
        try {
            if (var1_1 < 0) {
                var3_4 = ((float[])this.stack[-1])[0];
            }
            if (var1_1 >= this.nx) {
                var3_4 = ((float[])this.stack[-1])[0];
            }
        }
        catch (ArrayIndexOutOfBoundsException v0) {
            this.MessageOutofBounds(var1_1, 0, 0, this.nx, this.ny, this.nz);
            return;
        }
        var5_6 = var2_2.length;
        try {
            if (var1_1 + var5_6 > this.nx) {
                var3_4 = ((float[])this.stack[-1])[0];
            }
            var6_7 = 0;
            while (var6_7 < var5_6) {
                ((float[])this.stack[0])[var1_1 + var6_7] = (float)var2_2[var6_7];
                ++var6_7;
            }
            return;
        }
        catch (ArrayIndexOutOfBoundsException v1) {
            var5_6 = this.nx - var1_1;
            var6_8 = 0;
            ** while (var6_8 < var5_6)
        }
lbl-1000:
        // 1 sources

        {
            ((float[])this.stack[0])[var1_1++] = (float)var2_2[var6_8];
            ++var6_8;
            continue;
        }
lbl37:
        // 1 sources

    }

    public void getNeighborhood(Coordinate coordinate, Object object) {
        switch (this.dimension) {
            case 2: {
                if (object instanceof double[][]) {
                    this.getNeighborhood(coordinate.x, coordinate.y, (double[][])object);
                    return;
                }
                if (object instanceof double[][][]) {
                    this.getNeighborhood(coordinate.x, coordinate.y, coordinate.z, (double[][][])object);
                    return;
                }
                if (object instanceof double[]) {
                    this.getNeighborhood(coordinate.x, coordinate.y, (double[])object);
                    return;
                }
            }
            case 3: {
                if (object instanceof double[][]) {
                    this.getNeighborhood(coordinate.x, coordinate.y, coordinate.z, (double[][])object);
                    return;
                }
                if (object instanceof double[][][]) {
                    this.getNeighborhood(coordinate.x, coordinate.y, coordinate.z, (double[][][])object);
                    return;
                }
                if (object instanceof double[]) {
                    this.getNeighborhood(coordinate.x, coordinate.y, coordinate.z, (double[])object);
                    return;
                }
            }
            case 1: {
                if (object instanceof double[]) {
                    this.getNeighborhood(coordinate.x, (double[])object);
                    return;
                }
                if (object instanceof double[][]) {
                    this.getNeighborhood(coordinate.x, 0, (double[][])object);
                    return;
                }
                if (!(object instanceof double[][][])) break;
                this.getNeighborhood(coordinate.x, 0, 0, (double[][][])object);
                return;
            }
        }
    }

    public void getNeighborhood(int n, int n2, int n3, double[][][] dArray) {
        n += this.border;
        n2 += this.border;
        n3 += this.border;
        int n4 = dArray.length;
        int n5 = dArray[0].length;
        int n6 = dArray[0][0].length;
        int n7 = (n4 - 1) / 2;
        int n8 = (n5 - 1) / 2;
        int n9 = (n6 - 1) / 2;
        int n10 = n - n7;
        int n11 = n2 - n8;
        int n12 = n3 - n9;
        double d = 0.0;
        if (this.fast) {
            int n13 = 0;
            int n14 = n10 + n11 * this.nx;
            int n15 = this.nx - n4;
            int n16 = n12;
            int n17 = 0;
            while (n17 < n6) {
                n13 = n14;
                int n18 = 0;
                while (n18 < n5) {
                    int n19 = 0;
                    while (n19 < n4) {
                        dArray[n19][n18][n17] = ((float[])this.stack[n16])[n13++];
                        ++n19;
                    }
                    n13 += n15;
                    ++n18;
                }
                ++n16;
                ++n17;
            }
            return;
        }
        try {
            if (n < 0) {
                d = ((float[])this.stack[-1])[0];
            }
            if (n >= this.nx) {
                d = ((float[])this.stack[-1])[0];
            }
            d = ((float[])this.stack[n3])[n + n2 * this.nx];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.MessageOutofBounds(n, n2, n3, this.nx, this.ny, this.nz);
            return;
        }
        catch (NullPointerException nullPointerException) {
            this.MessageOutofBounds(n, n2, n3, this.nx, this.ny, this.nz);
            return;
        }
        try {
            if (n <= n7) {
                d = ((float[])this.stack[-1])[0];
            }
            if (n > this.nx - n7 - 1) {
                d = ((float[])this.stack[-1])[0];
            }
            d = ((float[])this.stack[n3 + n9 - 1])[n + n7 - 1 + (n2 + n8 - 1) * this.nx];
            int n20 = 0;
            int n21 = n10 + n11 * this.nx;
            int n22 = this.nx - n4;
            int n23 = n12;
            int n24 = 0;
            while (n24 < n6) {
                n20 = n21;
                int n25 = 0;
                while (n25 < n5) {
                    int n26 = 0;
                    while (n26 < n4) {
                        dArray[n26][n25][n24] = ((float[])this.stack[n23])[n20++];
                        ++n26;
                    }
                    n20 += n22;
                    ++n25;
                }
                ++n23;
                ++n24;
            }
            return;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayStoreException(String.valueOf(String.valueOf(arrayIndexOutOfBoundsException)) + " Out of the image");
        }
        catch (NullPointerException nullPointerException) {
            throw new ArrayStoreException(String.valueOf(String.valueOf(nullPointerException)) + " Out of the image");
        }
    }

    public void getNeighborhood(int n, int n2, int n3, double[][] dArray) {
        FloatDataExtended floatDataExtended = null;
        Object[] objectArray = null;
        switch (this.dir) {
            case 3: {
                if (this.fast) {
                    n += this.border;
                    n2 += this.border;
                    n3 += this.border;
                    int n4 = dArray.length;
                    int n5 = dArray[0].length;
                    int n6 = (n4 - 1) / 2;
                    int n7 = (n5 - 1) / 2;
                    double d = 0.0;
                    int n8 = (n2 - n7) * this.nx + n - n6;
                    int n9 = this.nx - n4;
                    int n10 = 0;
                    while (n10 < n5) {
                        int n11 = 0;
                        while (n11 < n4) {
                            d = ((float[])this.stack[n3])[n8++];
                            dArray[n11][n10] = d < 0.0 ? d + 256.0 : d;
                            ++n11;
                        }
                        n8 += n9;
                        ++n10;
                    }
                    return;
                }
                floatDataExtended = new FloatDataExtended(this.nx, this.ny);
                objectArray = ((Data)floatDataExtended).getReferencePixels();
                n3 += this.border;
                try {
                    int n12 = this.nx * this.ny;
                    int n13 = 0;
                    int n14 = 0;
                    while (n14 < n12) {
                        ((float[])objectArray[0])[n13] = ((float[])this.stack[n3])[n13];
                        ++n13;
                        ++n14;
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    this.MessageOutofBounds(0, 0, n3, this.nx, this.ny, this.nz);
                    return;
                }
                catch (NullPointerException nullPointerException) {
                    this.MessageOutofBounds(0, 0, n3, this.nx, this.ny, this.nz);
                    return;
                }
                ((Data)floatDataExtended).getNeighborhood(n, n2, dArray);
                return;
            }
            case 5: {
                if (this.fast) {
                    n += this.border;
                    n2 += this.border;
                    n3 += this.border;
                    int n15 = dArray.length;
                    int n16 = dArray[0].length;
                    int n17 = (n15 - 1) / 2;
                    int n18 = (n16 - 1) / 2;
                    double d = 0.0;
                    int n19 = n - n17;
                    int n20 = n3 - n18;
                    int n21 = n2 * this.nx + n19;
                    int n22 = 0;
                    while (n22 < n16) {
                        int n23 = 0;
                        while (n23 < n15) {
                            d = ((float[])this.stack[n20])[n21 + n23];
                            dArray[n23][n22] = d < 0.0 ? d + 256.0 : d;
                            ++n23;
                        }
                        ++n20;
                        ++n22;
                    }
                    return;
                }
                floatDataExtended = new FloatDataExtended(this.nx, this.nz);
                objectArray = ((Data)floatDataExtended).getReferencePixels();
                n2 += this.border;
                try {
                    int n24 = n2 * this.nx;
                    int n25 = 0;
                    int n26 = 0;
                    while (n26 < this.nz) {
                        int n27 = 0;
                        while (n27 < this.nx) {
                            ((float[])objectArray[0])[n25++] = ((float[])this.stack[n26])[n27 + n24];
                            ++n27;
                        }
                        ++n26;
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    this.MessageOutofBounds(0, n2, 0, this.nx, this.ny, this.nz);
                    return;
                }
                ((Data)floatDataExtended).getNeighborhood(n, n3, dArray);
                return;
            }
            case 4: {
                if (this.fast) {
                    n += this.border;
                    n2 += this.border;
                    int n28 = dArray.length;
                    int n29 = dArray[0].length;
                    int n30 = (n28 - 1) / 2;
                    int n31 = (n29 - 1) / 2;
                    int n32 = (n3 += this.border) - n30;
                    int n33 = n2 - n31;
                    double d = 0.0;
                    int n34 = n33 * this.nx + n;
                    int n35 = n32;
                    int n36 = 0;
                    while (n36 < n29) {
                        n35 = n3;
                        int n37 = 0;
                        while (n37 < n28) {
                            d = ((float[])this.stack[n35])[n34];
                            dArray[n37][n36] = d < 0.0 ? d + 256.0 : d;
                            ++n35;
                            ++n37;
                        }
                        n34 += this.nx;
                        ++n36;
                    }
                    return;
                }
                floatDataExtended = new FloatDataExtended(this.nz, this.ny);
                objectArray = ((Data)floatDataExtended).getReferencePixels();
                n += this.border;
                try {
                    int n38 = n;
                    int n39 = 0;
                    int n40 = 0;
                    while (n40 < this.ny) {
                        int n41 = 0;
                        while (n41 < this.nz) {
                            ((float[])objectArray[0])[n39++] = ((float[])this.stack[n41])[n38];
                            ++n41;
                        }
                        n38 += this.nx;
                        ++n40;
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    this.MessageOutofBounds(n, 0, 0, this.nx, this.ny, this.nz);
                    return;
                }
                ((Data)floatDataExtended).getNeighborhood(n3, n2, dArray);
                return;
            }
        }
        throw new ArrayStoreException("Unexpected direction" + this.dir);
    }

    public void getNeighborhood(int n, int n2, int n3, double[] dArray) {
        FloatDataExtended floatDataExtended = null;
        float[] fArray = null;
        switch (this.dir) {
            case 0: {
                if (this.fast) {
                    n3 += this.border;
                    int n4 = dArray.length;
                    int n5 = (n4 - 1) / 2;
                    double d = 0.0;
                    int n6 = (n2 += this.border) * this.nx + (n += this.border) - n5;
                    int n7 = 0;
                    while (n7 < n4) {
                        dArray[n7] = (d = (double)((float[])this.stack[n3])[n6++]) < 0.0 ? d + 256.0 : d;
                        ++n7;
                    }
                    return;
                }
                floatDataExtended = new FloatDataExtended(this.nx, this.ny);
                fArray = (float[])((Data)floatDataExtended).getReferencePixels()[0];
                n3 += this.border;
                try {
                    int n8 = 0;
                    int n9 = this.nx * this.ny;
                    int n10 = 0;
                    while (n10 < n9) {
                        fArray[n8] = ((float[])this.stack[n3])[n8];
                        ++n8;
                        ++n10;
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    this.MessageOutofBounds(0, 0, n3, this.nx, this.ny, this.nz);
                    return;
                }
                catch (NullPointerException nullPointerException) {
                    this.MessageOutofBounds(0, 0, n3, this.nx, this.ny, this.nz);
                    return;
                }
                ((Data)floatDataExtended).setDirection(0);
                ((Data)floatDataExtended).getNeighborhood(n, n2, dArray);
                return;
            }
            case 1: {
                if (this.fast) {
                    n3 += this.border;
                    double d = 0.0;
                    int n11 = dArray.length;
                    int n12 = (n11 - 1) / 2;
                    int n13 = (n2 += this.border) - n12 * this.nx + (n += this.border);
                    int n14 = 0;
                    while (n14 < n11) {
                        dArray[n14] = (d = (double)((float[])this.stack[n3])[n13++]) < 0.0 ? d + 256.0 : d;
                        n13 += this.nx;
                        ++n14;
                    }
                    return;
                }
                floatDataExtended = new FloatDataExtended(this.nx, this.ny);
                fArray = (float[])((Data)floatDataExtended).getReferencePixels()[0];
                n3 += this.border;
                try {
                    int n15 = 0;
                    int n16 = this.nx * this.ny;
                    int n17 = 0;
                    while (n17 < n16) {
                        fArray[n15] = ((float[])this.stack[n3])[n15];
                        ++n15;
                        ++n17;
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    this.MessageOutofBounds(0, 0, n3, this.nx, this.ny, this.nz);
                    return;
                }
                catch (NullPointerException nullPointerException) {
                    this.MessageOutofBounds(0, 0, n3, this.nx, this.ny, this.nz);
                    return;
                }
                ((Data)floatDataExtended).setDirection(1);
                ((Data)floatDataExtended).getNeighborhood(n, n2, dArray);
                return;
            }
            case 2: {
                if (this.fast) {
                    double d = 0.0;
                    int n18 = dArray.length;
                    int n19 = (n18 - 1) / 2;
                    int n20 = (n3 += this.border) - n19;
                    int n21 = (n2 += this.border) * this.nx + (n += this.border);
                    int n22 = 0;
                    while (n22 < n18) {
                        dArray[n22] = (d = (double)((float[])this.stack[n20++])[n21]) < 0.0 ? d + 256.0 : d;
                        ++n22;
                    }
                    return;
                }
                floatDataExtended = new FloatDataExtended(this.nz, this.ny);
                fArray = (float[])((Data)floatDataExtended).getReferencePixels()[0];
                n += this.border;
                try {
                    int n23 = 0;
                    int n24 = n;
                    int n25 = 0;
                    while (n25 < this.ny) {
                        int n26 = 0;
                        while (n26 < this.nz) {
                            fArray[n23++] = ((float[])this.stack[n26])[n24];
                            ++n26;
                        }
                        n24 += this.nx;
                        ++n25;
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    this.MessageOutofBounds(n, 0, 0, this.nx, this.ny, this.nz);
                    return;
                }
                catch (NullPointerException nullPointerException) {
                    this.MessageOutofBounds(n, 0, 0, this.nx, this.ny, this.nz);
                    return;
                }
                ((Data)floatDataExtended).setDirection(0);
                ((Data)floatDataExtended).getNeighborhood(n3, n2, dArray);
                return;
            }
        }
        throw new ArrayStoreException("Unexpected direction" + this.dir);
    }

    public void getNeighborhood(int n, int n2, double[][] dArray) {
        n += this.border;
        n2 += this.border;
        int n3 = dArray.length;
        int n4 = dArray[0].length;
        int n5 = (n3 - 1) / 2;
        int n6 = (n4 - 1) / 2;
        int n7 = n - n5;
        int n8 = n2 - n6;
        double d = 0.0;
        if (this.fast) {
            int n9 = n8 * this.nx + n7;
            int n10 = this.nx - n3;
            int n11 = 0;
            while (n11 < n4) {
                int n12 = 0;
                while (n12 < n3) {
                    dArray[n12][n11] = ((float[])this.stack[0])[n9++];
                    ++n12;
                }
                n9 += n10;
                ++n11;
            }
            return;
        }
        try {
            if (n < 0) {
                d = ((float[])this.stack[-1])[0];
            }
            if (n >= this.nx) {
                d = ((float[])this.stack[-1])[0];
            }
            d = ((float[])this.stack[0])[n + n2 * this.nx];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.MessageOutofBounds(n, n2, 0, this.nx, this.ny, this.nz);
            return;
        }
        try {
            if (n <= n5) {
                d = ((float[])this.stack[-1])[0];
            }
            if (n > this.nx - n5 - 1) {
                d = ((float[])this.stack[-1])[0];
            }
            d = ((float[])this.stack[0])[n + n5 - 1 + (n2 + n6 - 1) * this.nx];
            int n13 = n8 * this.nx + n7;
            int n14 = this.nx - n3;
            int n15 = 0;
            while (n15 < n4) {
                int n16 = 0;
                while (n16 < n3) {
                    dArray[n16][n15] = ((float[])this.stack[0])[n13++];
                    ++n16;
                }
                n13 += n14;
                ++n15;
            }
            return;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayStoreException(String.valueOf(String.valueOf(arrayIndexOutOfBoundsException)) + " Out of the image");
        }
    }

    public void getNeighborhood(int n, int n2, double[] dArray) {
        n += this.border;
        n2 += this.border;
        int n3 = 0;
        double d = 0.0;
        switch (this.dir) {
            case 0: {
                int n4 = dArray.length;
                int n5 = (n4 - 1) / 2;
                int n6 = n - n5;
                if (this.fast) {
                    n3 = n2 * this.nx + n6;
                    int n7 = 0;
                    while (n7 < n4) {
                        dArray[n7] = ((float[])this.stack[0])[n3++];
                        ++n7;
                    }
                    return;
                }
                try {
                    if (n >= this.nx) {
                        d = ((float[])this.stack[-1])[0];
                    }
                    d = ((float[])this.stack[0])[n2 * this.nx];
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    this.MessageOutofBounds(n, n2, 0, this.nx, this.ny, this.nz);
                    return;
                }
                try {
                    if (n <= n5) {
                        d = ((float[])this.stack[-1])[0];
                    }
                    if (n > this.nx - n5 - 1) {
                        d = ((float[])this.stack[-1])[0];
                    }
                    n3 = n2 * this.nx + n6;
                    int n8 = 0;
                    while (n8 < n4) {
                        dArray[n8] = ((float[])this.stack[0])[n3++];
                        ++n8;
                    }
                    return;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    throw new ArrayStoreException(String.valueOf(String.valueOf(arrayIndexOutOfBoundsException)) + " Out of the image");
                }
            }
            case 1: {
                int n9 = dArray.length;
                int n10 = (n9 - 1) / 2;
                int n11 = n2 - n10;
                if (this.fast) {
                    n3 = n11 * this.nx + n;
                    int n12 = 0;
                    while (n12 < n9) {
                        dArray[n12] = ((float[])this.stack[0])[n3++];
                        n3 += this.nx;
                        ++n12;
                    }
                    return;
                }
                try {
                    if (n < 0) {
                        d = ((float[])this.stack[-1])[0];
                    }
                    if (n >= this.nx) {
                        d = ((float[])this.stack[-1])[0];
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    this.MessageOutofBounds(n, 0, 0, this.nx, this.ny, this.nz);
                    return;
                }
                try {
                    d = ((float[])this.stack[0])[n + (n2 + n10 - 1) * this.nx];
                    n3 = n11 * this.nx + n;
                    int n13 = 0;
                    while (n13 < n9) {
                        dArray[n13] = ((float[])this.stack[0])[n3++];
                        n3 += this.nx;
                        ++n13;
                    }
                    return;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    throw new ArrayStoreException(String.valueOf(String.valueOf(arrayIndexOutOfBoundsException)) + " Out of the image");
                }
            }
        }
        throw new ArrayStoreException("Unexpected direction" + this.dir);
    }

    public void getNeighborhood(int n, double[] dArray) {
        int n2 = dArray.length;
        int n3 = (n2 - 1) / 2;
        double d = 0.0;
        int n4 = (n += this.border) - n3;
        if (this.fast) {
            int n5 = n4;
            int n6 = 0;
            while (n6 < n2) {
                dArray[n6] = ((float[])this.stack[0])[n5++];
                ++n6;
            }
            return;
        }
        try {
            if (n < 0) {
                d = ((float[])this.stack[-1])[0];
            }
            if (n >= this.nx) {
                d = ((float[])this.stack[-1])[0];
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.MessageOutofBounds(n, 0, 0, this.nx, this.ny, this.nz);
            return;
        }
        try {
            if (n <= n3) {
                d = ((float[])this.stack[-1])[0];
            }
            if (n > this.nx - n3 - 1) {
                d = ((float[])this.stack[-1])[0];
            }
            int n7 = n4;
            int n8 = 0;
            while (n8 < n2) {
                dArray[n8] = ((float[])this.stack[0])[n7++];
                ++n8;
            }
            return;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayStoreException(String.valueOf(String.valueOf(arrayIndexOutOfBoundsException)) + " Out of the image");
        }
    }

    public void get(Coordinate coordinate, Data data) {
        if (!data.isExtended()) {
            this.dir = this.dir;
            switch (data.getDimension()) {
                case 1: {
                    switch (this.dimension) {
                        case 3: {
                            this.get(coordinate.x, coordinate.y, coordinate.z, data, this.dir);
                            return;
                        }
                        case 2: {
                            this.get(coordinate.x, coordinate.y, data, this.dir);
                            return;
                        }
                        case 1: {
                            this.get(coordinate.x, data);
                            return;
                        }
                    }
                }
                case 2: {
                    switch (this.dimension) {
                        case 3: {
                            this.get(coordinate.x, coordinate.y, coordinate.z, data, this.dir);
                            return;
                        }
                        case 2: {
                            this.get(coordinate.x, coordinate.y, data);
                            return;
                        }
                        case 1: {
                            this.get(coordinate.x, 0, data);
                            return;
                        }
                    }
                }
                case 3: {
                    switch (this.dimension) {
                        case 3: {
                            this.get(coordinate.x, coordinate.y, coordinate.z, data);
                            return;
                        }
                        case 2: {
                            this.get(coordinate.x, coordinate.y, coordinate.z, data);
                            return;
                        }
                        case 1: {
                            this.get(coordinate.x, coordinate.y, coordinate.z, data);
                            return;
                        }
                        default: {
                            return;
                        }
                    }
                }
                default: {
                    return;
                }
            }
        }
        throw new IndexOutOfBoundsException("Extended image");
    }

    public void put(Coordinate coordinate, Data data) {
        if (!data.isExtended()) {
            this.dir = this.dir;
            switch (data.getDimension()) {
                case 1: {
                    switch (this.dimension) {
                        case 3: {
                            this.put(coordinate.x, coordinate.y, coordinate.z, data, this.dir);
                            return;
                        }
                        case 2: {
                            this.put(coordinate.x, coordinate.y, data, this.dir);
                            return;
                        }
                        case 1: {
                            this.put(coordinate.x, data);
                            return;
                        }
                    }
                }
                case 2: {
                    switch (this.dimension) {
                        case 3: {
                            this.put(coordinate.x, coordinate.y, coordinate.z, data, this.dir);
                            return;
                        }
                        case 2: {
                            this.put(coordinate.x, coordinate.y, data);
                            return;
                        }
                        case 1: {
                            this.put(coordinate.x, 0, data);
                            return;
                        }
                    }
                }
                case 3: {
                    switch (this.dimension) {
                        case 3: {
                            this.put(coordinate.x, coordinate.y, coordinate.z, data);
                            return;
                        }
                        case 2: {
                            this.put(coordinate.x, coordinate.y, coordinate.z, data);
                            return;
                        }
                        case 1: {
                            this.put(coordinate.x, coordinate.y, coordinate.z, data);
                            return;
                        }
                        default: {
                            return;
                        }
                    }
                }
                default: {
                    return;
                }
            }
        }
        throw new IndexOutOfBoundsException("Extended image");
    }

    public void get(int n, Data data) {
        if (data.isExtended() || data.getDimension() != 1) {
            throw new IndexOutOfBoundsException("Extended image");
        }
        int n2 = data.getXSize();
        int n3 = data.getYSize();
        int n4 = data.getZSize();
        double[][][] dArray = new double[n2][n3][n4];
        this.get(n, 0, 0, dArray);
        data.put(0, 0, 0, dArray);
    }

    public void get(int n, int n2, Data data) {
        if (data.isExtended() || data.getDimension() != 2) {
            throw new IndexOutOfBoundsException("Extended image");
        }
        int n3 = data.getXSize();
        int n4 = data.getYSize();
        double[][] dArray = new double[n3][n4];
        this.get(n, n2, dArray);
        data.put(0, 0, dArray);
    }

    public void get(int n, int n2, Data data, int n3) {
        if (data.isExtended() || data.getDimension() != 1) {
            throw new IndexOutOfBoundsException("Extended image");
        }
        int n4 = data.getXSize();
        double[] dArray = new double[n4];
        this.get(n, n2, dArray);
        data.put(0, dArray);
    }

    public void get(int n, int n2, int n3, Data data) {
        if (data.isExtended() || data.getDimension() != 3) {
            throw new IndexOutOfBoundsException("Extended image");
        }
        int n4 = data.getXSize();
        int n5 = data.getYSize();
        int n6 = data.getZSize();
        double[][][] dArray = new double[n4][n5][n6];
        this.get(n, n2, n3, dArray);
        data.put(0, 0, 0, dArray);
    }

    public void get(int n, int n2, int n3, Data data, int n4) {
        if (!data.isExtended() && data.getDimension() != 3) {
            if (data.getDimension() == 1) {
                int n5 = data.getXSize();
                double[] dArray = new double[n5];
                this.dir = n4;
                this.get(n, n2, n3, dArray);
                data.put(0, dArray);
            } else if (data.getDimension() == 2) {
                int n6 = data.getXSize();
                int n7 = data.getYSize();
                double[][] dArray = new double[n6][n7];
                this.dir = n4;
                this.get(n, n2, n3, dArray);
                data.put(0, 0, dArray);
            }
        } else {
            throw new IndexOutOfBoundsException("Extended image");
        }
    }

    public void put(int n, int n2, Data data) {
        if (data.getDimension() != 2 || data.isExtended()) {
            throw new IndexOutOfBoundsException("bad dimension");
        }
        int n3 = data.getWidth();
        int n4 = data.getHeight();
        double[][] dArray = new double[n3][n4];
        data.get(0, 0, dArray);
        this.put(n, n2, dArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void put(int n, int n2, Data data, int n3) {
        if (data.isExtended()) throw new IndexOutOfBoundsException("Extended input");
        if (data.getDimension() == 2 && n3 == 3) {
            int n4 = data.getWidth();
            int n5 = data.getHeight();
            double[][] dArray = new double[n4][n5];
            data.get(0, 0, dArray);
            this.put(n, n2, dArray);
            return;
        } else {
            if (data.getDimension() != 1) throw new IndexOutOfBoundsException("Bad dimension");
            int n6 = data.getWidth();
            double[] dArray = new double[n6];
            this.dir = n3;
            data.get(0, dArray);
            this.put(n, n2, dArray);
        }
    }

    public void put(int n, int n2, int n3, Data data) {
        if (data.isExtended()) {
            throw new IndexOutOfBoundsException("bad dimension");
        }
        int n4 = data.getWidth();
        int n5 = data.getHeight();
        int n6 = data.getZSize();
        double[][][] dArray = new double[n4][n5][n6];
        data.get(0, 0, 0, dArray);
        this.put(n, n2, n3, dArray);
    }

    public void put(int n, int n2, int n3, Data data, int n4) {
        if (!data.isExtended()) {
            if (data.getDimension() == 3 && n4 == 6) {
                int n5 = data.getWidth();
                int n6 = data.getHeight();
                int n7 = data.getZSize();
                double[][][] dArray = new double[n5][n6][n7];
                data.get(0, 0, 0, dArray);
                this.put(n, n2, n3, dArray);
            } else if (data.getDimension() == 2) {
                int n8 = data.getWidth();
                int n9 = data.getHeight();
                double[][] dArray = new double[n8][n9];
                this.dir = n4;
                data.get(0, 0, dArray);
                this.put(n, n2, n3, dArray);
            } else if (data.getDimension() == 1) {
                int n10 = data.getWidth();
                double[] dArray = new double[n10];
                this.dir = n4;
                data.get(0, dArray);
                this.put(n, n2, n3, dArray);
            }
        } else {
            throw new IndexOutOfBoundsException("bad dimension");
        }
    }

    public void put(int n, Data data) {
        if (data.getDimension() != 1 || data.isExtended()) {
            throw new IndexOutOfBoundsException("bad dimension");
        }
        int n2 = data.getWidth();
        double[] dArray = new double[n2];
        data.get(0, dArray);
        this.put(n, dArray);
    }

    public Data extendBorder(int n) {
        throw new IndexOutOfBoundsException("operation denied");
    }

    public Data extendBorder(int n, int n2) {
        throw new IndexOutOfBoundsException("operation denied");
    }

    public Data extendBorder(int n, int n2, int n3) {
        throw new IndexOutOfBoundsException("operation denied");
    }

    public void updateBorder() {
        if (this.dimension == 1) {
            int n = this.nx - 2 * this.border;
            DoubleData doubleData = new DoubleData(n, 1);
            double[] dArray = new double[n];
            this.get(0, dArray);
            ((Data)doubleData).put(0, dArray);
            double[] dArray2 = new double[this.nx];
            ((Data)doubleData).setBoundaryCondition(this.boundaryCondition, this.border);
            ((Data)doubleData).getNeighborhood((n - 1) / 2, dArray2);
            this.put(-this.border, dArray2);
            return;
        }
        if (this.dimension == 2) {
            int n = this.nx - 2 * this.border;
            int n2 = this.ny - 2 * this.border;
            DoubleData doubleData = new DoubleData(n, n2);
            double[][] dArray = new double[n][n2];
            this.get(0, 0, dArray);
            ((Data)doubleData).put(0, 0, dArray);
            double[][] dArray3 = new double[this.nx][this.ny];
            ((Data)doubleData).setBoundaryCondition(this.boundaryCondition, this.border);
            ((Data)doubleData).getNeighborhood((n - 1) / 2, (n2 - 1) / 2, dArray3);
            this.put(-this.border, -this.border, dArray3);
            return;
        }
        if (this.dimension == 3) {
            int n = this.nx - 2 * this.border;
            int n3 = this.ny - 2 * this.border;
            int n4 = this.nz - 2 * this.border;
            DoubleData doubleData = new DoubleData(n, n3, n4);
            double[][][] dArray = new double[n][n3][n4];
            this.get(0, 0, 0, dArray);
            ((Data)doubleData).put(0, 0, 0, dArray);
            double[][][] dArray4 = new double[this.nx][this.ny][this.nz];
            ((Data)doubleData).setBoundaryCondition(this.boundaryCondition, this.border);
            ((Data)doubleData).getNeighborhood((n - 1) / 2, (n3 - 1) / 2, (n4 - 1) / 2, dArray4);
            this.put(-this.border, -this.border, -this.border, dArray4);
            return;
        }
    }

    public Data removeBorder() {
        if (this.dimension == 1) {
            int n = this.nx - 2 * this.border;
            FloatData floatData = new FloatData(n, 1);
            double[] dArray = new double[n];
            this.get(0, dArray);
            ((Data)floatData).put(0, dArray);
            return floatData;
        }
        if (this.dimension == 2) {
            int n = this.nx - 2 * this.border;
            int n2 = this.ny - 2 * this.border;
            FloatData floatData = new FloatData(n, n2);
            double[][] dArray = new double[n][n2];
            this.get(0, 0, dArray);
            ((Data)floatData).put(0, 0, dArray);
            return floatData;
        }
        if (this.dimension == 3) {
            int n = this.nx - 2 * this.border;
            int n3 = this.ny - 2 * this.border;
            int n4 = this.nz - 2 * this.border;
            FloatData floatData = new FloatData(n, n3, n4);
            double[][][] dArray = new double[n][n3][n4];
            this.get(0, 0, 0, dArray);
            ((Data)floatData).put(0, 0, 0, dArray);
            return floatData;
        }
        throw new IndexOutOfBoundsException("bad dimension");
    }

    public Object[] getReferencePixels() {
        return this.stack;
    }

    public ImageProcessor getImageProcessor(int n) {
        return this.istack.getProcessor(n);
    }

    public ImageStack getImageStack() {
        return this.istack;
    }

    public boolean isExtended() {
        return true;
    }

    public int getType() {
        return 2;
    }

    public int getWidth() {
        return this.nx;
    }

    public int getHeight() {
        return this.ny;
    }

    public int getXSize() {
        return this.nx;
    }

    public int getYSize() {
        return this.ny;
    }

    public int getZSize() {
        return this.nz;
    }

    public int getTotalSize() {
        return this.size;
    }

    public int[] getSize() {
        int[] nArray = null;
        if (this.dimension == 1) {
            nArray = new int[]{this.nx};
        } else if (this.dimension == 2) {
            nArray = new int[]{this.nx, this.ny};
        } else if (this.dimension == 3) {
            nArray = new int[]{this.nx, this.ny, this.nz};
        }
        return nArray;
    }

    public int getDimension() {
        return this.dimension;
    }

    public void setConstant(double d) {
        int n = 0;
        while (n < this.nz) {
            int n2 = 0;
            while (n2 < this.ny) {
                int n3 = 0;
                while (n3 < this.nx) {
                    ((float[])this.stack[n])[n3 + this.nx * n2] = (float)d;
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
    }

    public void setBoundaryCondition(int n) {
        this.border = n;
    }

    public void setBoundaryCondition(int n, int n2) {
        this.boundaryCondition = n;
        this.border = n2;
    }

    public void setDirection(int n) {
        this.dir = n;
    }

    public int getDirection() {
        return this.dir;
    }

    public void normalizeContrast() {
        double d;
        double d2;
        double d3 = 0.0;
        double d4 = 255.0;
        double d5 = Statistic.getMinimum(this);
        if (d5 - (d2 = Statistic.getMaximum(this)) == 0.0) {
            d = 1.0;
            d5 = (d4 - d3) / 2.0;
        } else {
            d = (d4 - d3) / (d2 - d5);
        }
        int n = 0;
        while (n < this.nz) {
            int n2 = 0;
            while (n2 < this.ny) {
                int n3 = 0;
                while (n3 < this.nx) {
                    ((float[])this.stack[n])[n3 + this.nx * n2] = (float)(d * ((double)((float[])this.stack[n])[n3 + this.nx * n2] - d5) + d3);
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
    }

    public ImagePlus show(String string) {
        ImageProcessor imageProcessor = this.istack.getProcessor(1);
        imageProcessor.resetMinAndMax();
        ImagePlus imagePlus = new ImagePlus(string, this.istack);
        imagePlus.show();
        return imagePlus;
    }

    public ImagePlus show(String string, Point point) {
        ImageProcessor imageProcessor = this.istack.getProcessor(1);
        imageProcessor.resetMinAndMax();
        ImagePlus imagePlus = new ImagePlus(string, this.istack);
        imagePlus.show();
        ImageWindow imageWindow = imagePlus.getWindow();
        imageWindow.setLocation(point.x, point.y);
        return imagePlus;
    }

    public void updateDisplay(ImagePlus imagePlus) {
        imagePlus.updateAndDraw();
    }

    public void disableFast() {
        this.fast = false;
    }

    public void enableFast() {
        this.fast = true;
    }

    private static int floor(double d) {
        if (d >= 0.0) {
            return (int)d;
        }
        int n = (int)d - 1;
        return (int)(d - (double)n) + n;
    }

    private static int ceil(double d) {
        return -FloatDataExtended.floor(-d);
    }

    private static int round(double d) {
        return FloatDataExtended.floor(d + 0.5);
    }

    public void add(double d) {
        float f = (float)d;
        double d2 = this.nx * this.ny;
        int n = 0;
        while (n < this.nz) {
            int n2 = 0;
            while ((double)n2 < d2) {
                float[] fArray = (float[])this.stack[n];
                int n3 = n2++;
                fArray[n3] = fArray[n3] + f;
            }
            ++n;
        }
    }

    public void subtract(double d) {
        float f = (float)d;
        double d2 = this.nx * this.ny;
        int n = 0;
        while (n < this.nz) {
            int n2 = 0;
            while ((double)n2 < d2) {
                float[] fArray = (float[])this.stack[n];
                int n3 = n2++;
                fArray[n3] = fArray[n3] - f;
            }
            ++n;
        }
    }

    public void multiply(double d) {
        float f = (float)d;
        double d2 = this.nx * this.ny;
        int n = 0;
        while (n < this.nz) {
            int n2 = 0;
            while ((double)n2 < d2) {
                float[] fArray = (float[])this.stack[n];
                int n3 = n2++;
                fArray[n3] = fArray[n3] * f;
            }
            ++n;
        }
    }

    public void divide(double d) {
        float f = (float)d;
        double d2 = this.nx * this.ny;
        int n = 0;
        while (n < this.nz) {
            int n2 = 0;
            while ((double)n2 < d2) {
                float[] fArray = (float[])this.stack[n];
                int n3 = n2++;
                fArray[n3] = fArray[n3] / f;
            }
            ++n;
        }
    }

    public void pow(double d) {
        double d2 = this.nx * this.ny;
        int n = 0;
        while (n < this.nz) {
            int n2 = 0;
            while ((double)n2 < d2) {
                ((float[])this.stack[n])[n2] = (float)Math.pow(((float[])this.stack[n])[n2], d);
                ++n2;
            }
            ++n;
        }
    }

    public void sqrt() {
        double d = this.nx * this.ny;
        int n = 0;
        while (n < this.nz) {
            int n2 = 0;
            while ((double)n2 < d) {
                ((float[])this.stack[n])[n2] = FloatDataExtended.round(Math.sqrt(((float[])this.stack[n])[n2]));
                ++n2;
            }
            ++n;
        }
    }

    public void abs() {
        double d = this.nx * this.ny;
        int n = 0;
        while (n < this.nz) {
            int n2 = 0;
            while ((double)n2 < d) {
                ((float[])this.stack[n])[n2] = FloatDataExtended.round(Math.abs(((float[])this.stack[n])[n2]));
                ++n2;
            }
            ++n;
        }
    }

    public void add(Data data) {
        int n = data.getType();
        int n2 = data.getDimension();
        if (data.isExtended() && n == 2 && n2 == this.dimension) {
            if (data.getWidth() != this.nx) {
                throw new ArrayStoreException("Unexpected operand image size");
            }
            if (data.getHeight() != this.ny) {
                throw new ArrayStoreException("Unexpected operand image size");
            }
            if (data.getZSize() != this.nz) {
                throw new ArrayStoreException("Unexpected operand image size");
            }
            Object[] objectArray = data.getReferencePixels();
            double d = this.nx * this.ny;
            int n3 = 0;
            while (n3 < this.nz) {
                int n4 = 0;
                while ((double)n4 < d) {
                    float[] fArray = (float[])this.stack[n3];
                    int n5 = n4;
                    fArray[n5] = fArray[n5] + ((float[])objectArray[n3])[n4];
                    ++n4;
                }
                ++n3;
            }
        }
    }

    public void subtract(Data data) {
        int n = data.getType();
        int n2 = data.getDimension();
        if (data.isExtended() && n == 2 && n2 == this.dimension) {
            if (data.getWidth() != this.nx) {
                throw new ArrayStoreException("Unexpected operand image size");
            }
            if (data.getHeight() != this.ny) {
                throw new ArrayStoreException("Unexpected operand image size");
            }
            if (data.getZSize() != this.nz) {
                throw new ArrayStoreException("Unexpected operand image size");
            }
            Object[] objectArray = data.getReferencePixels();
            double d = this.nx * this.ny;
            int n3 = 0;
            while (n3 < this.nz) {
                int n4 = 0;
                while ((double)n4 < d) {
                    float[] fArray = (float[])this.stack[n3];
                    int n5 = n4;
                    fArray[n5] = fArray[n5] - ((float[])objectArray[n3])[n4];
                    ++n4;
                }
                ++n3;
            }
        }
    }

    public void multiply(Data data) {
        int n = data.getType();
        int n2 = data.getDimension();
        if (data.isExtended() && n == 2 && n2 == this.dimension) {
            if (data.getWidth() != this.nx) {
                throw new ArrayStoreException("Unexpected operand image size");
            }
            if (data.getHeight() != this.ny) {
                throw new ArrayStoreException("Unexpected operand image size");
            }
            if (data.getZSize() != this.nz) {
                throw new ArrayStoreException("Unexpected operand image size");
            }
            Object[] objectArray = data.getReferencePixels();
            double d = this.nx * this.ny;
            int n3 = 0;
            while (n3 < this.nz) {
                int n4 = 0;
                while ((double)n4 < d) {
                    float[] fArray = (float[])this.stack[n3];
                    int n5 = n4;
                    fArray[n5] = fArray[n5] * ((float[])objectArray[n3])[n4];
                    ++n4;
                }
                ++n3;
            }
        }
    }

    public void divide(Data data) {
        int n = data.getType();
        int n2 = data.getDimension();
        if (data.isExtended() && n == 2 && n2 == this.dimension) {
            if (data.getWidth() != this.nx) {
                throw new ArrayStoreException("Unexpected operand image size");
            }
            if (data.getHeight() != this.ny) {
                throw new ArrayStoreException("Unexpected operand image size");
            }
            if (data.getZSize() != this.nz) {
                throw new ArrayStoreException("Unexpected operand image size");
            }
            Object[] objectArray = data.getReferencePixels();
            double d = this.nx * this.ny;
            int n3 = 0;
            while (n3 < this.nz) {
                int n4 = 0;
                while ((double)n4 < d) {
                    float[] fArray = (float[])this.stack[n3];
                    int n5 = n4;
                    fArray[n5] = fArray[n5] / ((float[])objectArray[n3])[n4];
                    ++n4;
                }
                ++n3;
            }
        }
    }

    public void MessageOutofBounds(int n, int n2, int n3, int n4, int n5, int n6) {
        if (n3 < 0) {
            throw new ArrayStoreException("z = " + n3 + " out of bounds z<0");
        }
        if (n3 >= n6) {
            throw new ArrayStoreException("z = " + n3 + " out of bounds z >= nz");
        }
        if (n2 < 0) {
            throw new ArrayStoreException("y = " + n2 + " out of bounds y<0");
        }
        if (n2 >= n5) {
            throw new ArrayStoreException("y = " + n2 + " out of bounds y >= ny");
        }
        if (n < 0) {
            throw new ArrayStoreException("x = " + n + " out of bounds x<0");
        }
        if (n >= n4) {
            throw new ArrayStoreException("x = " + n + " out of bounds x >= nx");
        }
    }
}

