/*
 * Decompiled with CFR 0.152.
 */
package data;

import data.ByteData;
import data.Coordinate;
import data.DoubleData;
import data.FloatData;
import data.ShortData;
import ij.ImagePlus;
import ij.ImageStack;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.awt.Point;

public abstract class Data {
    public static final int BYTE = 0;
    public static final int SHORT = 1;
    public static final int FLOAT = 2;
    public static final int DOUBLE = 6;
    public static final int MIRROR = 0;
    public static final int PERIODIC = 1;
    public static final int CONSTANT = 2;
    public static final int ZERO = 3;
    public static final int NONE = 5;
    public static final int X = 0;
    public static final int Y = 1;
    public static final int Z = 2;
    public static final int XY = 3;
    public static final int ZY = 4;
    public static final int XZ = 5;
    public static final int XYZ = 6;
    public static final int RED = 0;
    public static final int GREEN = 1;
    public static final int BLUE = 2;

    public static Data create(int n, int n2) {
        Data data = null;
        switch (n2) {
            case 0: {
                data = new ByteData(n, 1);
                break;
            }
            case 1: {
                data = new ShortData(n, 1);
                break;
            }
            case 2: {
                data = new FloatData(n, 1);
                break;
            }
            case 6: {
                data = new DoubleData(n, 1);
                break;
            }
            default: {
                throw new ArrayStoreException("Unexpected image type");
            }
        }
        return data;
    }

    public static Data create(int n, int n2, int n3) {
        Data data = null;
        switch (n3) {
            case 0: {
                data = new ByteData(n, n2);
                break;
            }
            case 1: {
                data = new ShortData(n, n2);
                break;
            }
            case 2: {
                data = new FloatData(n, n2);
                break;
            }
            case 6: {
                data = new DoubleData(n, n2);
                break;
            }
            default: {
                throw new ArrayStoreException("Unexpected image type");
            }
        }
        return data;
    }

    public static Data create(int n, int n2, int n3, int n4) {
        Data data = null;
        switch (n4) {
            case 0: {
                data = new ByteData(n, n2, n3);
                break;
            }
            case 1: {
                data = new ShortData(n, n2, n3);
                break;
            }
            case 2: {
                data = new FloatData(n, n2, n3);
                break;
            }
            case 6: {
                data = new DoubleData(n, n2, n3);
                break;
            }
            default: {
                throw new ArrayStoreException("Unexpected image type");
            }
        }
        return data;
    }

    public static Data create(Object object) {
        Data data = null;
        if (object instanceof byte[][][]) {
            data = Data.create(((byte[][][])object).length, ((byte[][][])object)[0].length, ((byte[][][])object)[0][0].length, 0);
        } else if (object instanceof byte[][]) {
            data = Data.create(((byte[][])object).length, ((byte[][])object)[0].length, 0);
        } else if (object instanceof byte[]) {
            data = Data.create(((byte[])object).length, 0);
        } else if (object instanceof float[][][]) {
            data = Data.create(((float[][][])object).length, ((float[][][])object)[0].length, ((float[][][])object)[0][0].length, 2);
        } else if (object instanceof float[][]) {
            data = Data.create(((float[][])object).length, ((float[][])object)[0].length, 2);
        } else if (object instanceof float[]) {
            data = Data.create(((float[])object).length, 2);
        } else if (object instanceof short[][][]) {
            data = Data.create(((short[][][])object).length, ((short[][][])object)[0].length, ((short[][][])object)[0][0].length, 1);
        } else if (object instanceof short[][]) {
            data = Data.create(((short[][])object).length, ((short[][])object)[0].length, 1);
        } else if (object instanceof short[]) {
            data = Data.create(((short[])object).length, 1);
        } else if (object instanceof double[][][]) {
            data = Data.create(((double[][][])object).length, ((double[][][])object)[0].length, ((double[][][])object)[0][0].length, 6);
        } else if (object instanceof double[][]) {
            data = Data.create(((double[][])object).length, ((double[][])object)[0].length, 6);
        } else if (object instanceof short[]) {
            data = Data.create(((double[])object).length, 6);
        }
        data.setPixels(object);
        return data;
    }

    public static Data create(ImageProcessor imageProcessor) {
        Data data = null;
        if (imageProcessor instanceof ByteProcessor) {
            data = new ByteData(imageProcessor);
        } else if (imageProcessor instanceof ShortProcessor) {
            data = new ShortData(imageProcessor);
        } else if (imageProcessor instanceof FloatProcessor) {
            data = new FloatData(imageProcessor);
        } else {
            throw new ArrayStoreException("Unexpected image type");
        }
        return data;
    }

    public static Data create(ImagePlus imagePlus) {
        Data data = null;
        if (imagePlus.getProcessor() instanceof ByteProcessor) {
            data = new ByteData(imagePlus);
        } else if (imagePlus.getProcessor() instanceof ShortProcessor) {
            data = new ShortData(imagePlus);
        } else if (imagePlus.getProcessor() instanceof FloatProcessor) {
            data = new FloatData(imagePlus);
        } else {
            if (imagePlus.getProcessor() instanceof ColorProcessor) {
                throw new ArrayStoreException("Channel expected");
            }
            throw new ArrayStoreException("Unexpected image type");
        }
        return data;
    }

    public static Data create(ImagePlus imagePlus, int n) {
        Data data = null;
        if (imagePlus.getProcessor() instanceof ByteProcessor) {
            data = new ByteData(imagePlus);
        } else if (imagePlus.getProcessor() instanceof ShortProcessor) {
            data = new ShortData(imagePlus);
        } else if (imagePlus.getProcessor() instanceof FloatProcessor) {
            data = new FloatData(imagePlus);
        } else if (imagePlus.getProcessor() instanceof ColorProcessor) {
            data = new ByteData(imagePlus, n);
        } else {
            throw new ArrayStoreException("Unexpected image type");
        }
        return data;
    }

    public static Data create(ImageStack imageStack) {
        Data data = null;
        if (imageStack.getProcessor(1) instanceof ByteProcessor) {
            data = new ByteData(imageStack);
        } else if (imageStack.getProcessor(1) instanceof ShortProcessor) {
            data = new ShortData(imageStack);
        } else if (imageStack.getProcessor(1) instanceof FloatProcessor) {
            data = new FloatData(imageStack);
        } else {
            throw new ArrayStoreException("Unexpected image type");
        }
        return data;
    }

    public static ImagePlus showColor(String string, Data data, Data data2, Data data3) {
        int n = data.getXSize();
        int n2 = data.getYSize();
        int n3 = data.getZSize();
        int n4 = data2.getXSize();
        int n5 = data2.getYSize();
        int n6 = data2.getZSize();
        int n7 = data3.getXSize();
        int n8 = data3.getYSize();
        int n9 = data3.getZSize();
        ImagePlus imagePlus = null;
        if (n == n7 && n == n4 && n2 == n8 && n2 == n5) {
            if (n3 == n9 && n3 == n6) {
                Data data4 = null;
                Data data5 = null;
                Data data6 = null;
                ImageStack imageStack = new ImageStack(n, n2);
                if (!(data instanceof ByteData)) {
                    data4 = data.duplicate(0);
                }
                if (!(data2 instanceof ByteData)) {
                    data5 = data2.duplicate(0);
                }
                if (!(data3 instanceof ByteData)) {
                    data6 = data3.duplicate(0);
                }
                int n10 = 0;
                while (n10 < n3) {
                    ColorProcessor colorProcessor = new ColorProcessor(n, n2);
                    colorProcessor.setRGB(data instanceof ByteData ? (byte[])data.getImageProcessor(n10).getPixels() : (byte[])data4.getImageProcessor(n10).getPixels(), data2 instanceof ByteData ? (byte[])data2.getImageProcessor(n10).getPixels() : (byte[])data5.getImageProcessor(n10).getPixels(), data3 instanceof ByteData ? (byte[])data3.getImageProcessor(n10).getPixels() : (byte[])data6.getImageProcessor(n10).getPixels());
                    imageStack.addSlice("", (ImageProcessor)colorProcessor);
                    ++n10;
                }
                imagePlus = new ImagePlus(string, imageStack);
                imagePlus.show();
                return imagePlus;
            }
            throw new ArrayStoreException("Unexpected image dimension");
        }
        return imagePlus;
    }

    public static void updateColor(ImagePlus imagePlus, Data data, Data data2, Data data3) {
        int n = data.getXSize();
        int n2 = data.getYSize();
        int n3 = data.getZSize();
        int n4 = data2.getXSize();
        int n5 = data2.getYSize();
        int n6 = data2.getZSize();
        int n7 = data3.getXSize();
        int n8 = data3.getYSize();
        int n9 = data3.getZSize();
        Object var13_13 = null;
        if (n == n7 && n == n4 && n2 == n8 && n2 == n5) {
            if (n3 == n9 && n3 == n6) {
                Data data4 = null;
                Data data5 = null;
                Data data6 = null;
                ImageStack imageStack = new ImageStack(n, n2);
                if (!(data instanceof ByteData)) {
                    data4 = data.duplicate(0);
                }
                if (!(data2 instanceof ByteData)) {
                    data5 = data2.duplicate(0);
                }
                if (!(data3 instanceof ByteData)) {
                    data6 = data3.duplicate(0);
                }
                int n10 = 0;
                while (n10 < n3) {
                    ColorProcessor colorProcessor = new ColorProcessor(n, n2);
                    colorProcessor.setRGB(data instanceof ByteData ? (byte[])data.getImageProcessor(n10).getPixels() : (byte[])data4.getImageProcessor(n10).getPixels(), data2 instanceof ByteData ? (byte[])data2.getImageProcessor(n10).getPixels() : (byte[])data5.getImageProcessor(n10).getPixels(), data3 instanceof ByteData ? (byte[])data3.getImageProcessor(n10).getPixels() : (byte[])data6.getImageProcessor(n10).getPixels());
                    imageStack.addSlice("", (ImageProcessor)colorProcessor);
                    ++n10;
                }
                imagePlus.setStack("", imageStack);
            } else {
                throw new ArrayStoreException("Unexpected image dimension");
            }
        }
        imagePlus.updateAndDraw();
    }

    public abstract void get(Object var1);

    public abstract void put(Object var1);

    public abstract double get(Coordinate var1);

    public abstract void put(Coordinate var1, double var2);

    public abstract void get(Coordinate var1, Object var2);

    public abstract void put(Coordinate var1, Object var2);

    public abstract void get(int var1, int var2, int var3, double[][][] var4);

    public abstract void get(int var1, int var2, int var3, double[][] var4);

    public abstract void get(int var1, int var2, int var3, double[] var4);

    public abstract void get(int var1, int var2, double[][] var3);

    public abstract void get(int var1, int var2, double[] var3);

    public abstract void get(int var1, double[] var2);

    public abstract void put(int var1, int var2, int var3, double[][][] var4);

    public abstract void put(int var1, int var2, int var3, double[][] var4);

    public abstract void put(int var1, int var2, int var3, double[] var4);

    public abstract void put(int var1, int var2, double[][] var3);

    public abstract void put(int var1, int var2, double[] var3);

    public abstract void put(int var1, double[] var2);

    public abstract void getNeighborhood(Coordinate var1, Object var2);

    public abstract void getNeighborhood(int var1, int var2, int var3, double[][][] var4);

    public abstract void getNeighborhood(int var1, int var2, int var3, double[][] var4);

    public abstract void getNeighborhood(int var1, int var2, int var3, double[] var4);

    public abstract void getNeighborhood(int var1, int var2, double[][] var3);

    public abstract void getNeighborhood(int var1, int var2, double[] var3);

    public abstract void getNeighborhood(int var1, double[] var2);

    public abstract void get(Coordinate var1, Data var2);

    public abstract void put(Coordinate var1, Data var2);

    public abstract void get(int var1, int var2, int var3, Data var4);

    public abstract void get(int var1, int var2, int var3, Data var4, int var5);

    public abstract void get(int var1, int var2, Data var3);

    public abstract void get(int var1, int var2, Data var3, int var4);

    public abstract void get(int var1, Data var2);

    public abstract void put(int var1, int var2, int var3, Data var4);

    public abstract void put(int var1, int var2, int var3, Data var4, int var5);

    public abstract void put(int var1, int var2, Data var3);

    public abstract void put(int var1, int var2, Data var3, int var4);

    public abstract void put(int var1, Data var2);

    public abstract Object[] getReferencePixels();

    public abstract ImageProcessor getImageProcessor(int var1);

    public abstract ImageStack getImageStack();

    public abstract double getInterpolatedPixel(double var1);

    public abstract double getInterpolatedPixel(double var1, double var3);

    public abstract double getInterpolatedPixel(double var1, double var3, double var5);

    public abstract void copy(Data var1);

    public abstract Data duplicate();

    public abstract Data duplicate(int var1);

    public abstract boolean isExtended();

    public abstract void enableFast();

    public abstract void disableFast();

    public abstract int getType();

    public abstract int getWidth();

    public abstract int getHeight();

    public abstract int getXSize();

    public abstract int getYSize();

    public abstract int getZSize();

    public abstract int getTotalSize();

    public abstract int[] getSize();

    public abstract int getDimension();

    public abstract void setPixels(Object var1);

    public abstract void getPixels(Object var1);

    public abstract void setDirection(int var1);

    public abstract int getDirection();

    public abstract void setConstant(double var1);

    public abstract void add(double var1);

    public abstract void subtract(double var1);

    public abstract void multiply(double var1);

    public abstract void divide(double var1);

    public abstract void pow(double var1);

    public abstract void sqrt();

    public abstract void abs();

    public abstract void add(Data var1);

    public abstract void subtract(Data var1);

    public abstract void multiply(Data var1);

    public abstract void divide(Data var1);

    public abstract void normalizeContrast();

    public abstract ImagePlus show(String var1);

    public abstract ImagePlus show(String var1, Point var2);

    public abstract void setBoundaryCondition(int var1);

    public abstract void setBoundaryCondition(int var1, int var2);

    public abstract Data extendBorder(int var1, int var2, int var3);

    public abstract Data extendBorder(int var1, int var2);

    public abstract Data extendBorder(int var1);

    public abstract Data removeBorder();

    public abstract void updateBorder();

    public abstract void updateDisplay(ImagePlus var1);
}

