function im = loadimage(img);

if  exist(img)
    [fpath,fname,fextension,fversion] = fileparts(char(img));
    
    if strcmp(char(fextension),'.dcm')
        im = dicomread(img); im = uint16(im);
        info = dicominfo(img)
    elseif strcmp(char(fextension),'.pgx')
        im = loadpgx(img);
    else
        [im,clrmap] = imread (img);
    end
else
    display('Such image is not available ...');
end

% Show the input image
%figure;
disp( 'Displaying the input image...');
%clf;
%imagesc(img, [0, 255]);
%AutoImageA(im);
%image(im);
imview(im,[]);
%imagesc(im);
%title('Input image');
%axis image off;
%colormap(gray);
%colormap gray(256);
